declare class XMLNodeBase {
    protected _data: Partial<XNode> & Pick<XNode, 'children'>;
    constructor(data: XNode);
    getElementsByTagName(tagName: string): XMLElement[];
}
export declare class XMLElement extends XMLNodeBase {
    protected _data: XNode;
    constructor(data: XNode);
    setAttribute(name: string, value: string): void;
    getAttribute(name: string): unknown | undefined;
    appendChild(tagName: string, attributes?: Record<string, string>, children?: (XNode | string)[]): XMLElement;
}
export declare class XMLParser extends XMLNodeBase {
    constructor(data?: XNode);
    parse(str: string): XMLParser;
    getElementsByTagName(tagName: string): XMLElement[];
    toString(): string;
}
export declare function parseXML(str: string): XMLParser;
export interface XNode {
    tagName: string;
    attributes: Record<string, string>;
    children: (string | XNode)[];
    pos?: number;
}
export {};
//# sourceMappingURL=XMLParser.d.ts.map