# CP Node Package Build System

This directory contains a Node.js application with a webpack-based build system that bundles specific JavaScript files in the directory and subdirectories.

## Project Structure

```
ns/
├── server.js                    # Main server file
├── livepreviewserver.js         # Live preview server
├── designOption/
│   ├── CPGetDesignOptionContent.js
│   └── fsAdapter.js
├── review/
│   ├── upload.js
│   └── utils.js
├── package.json                 # Dependencies and scripts
├── webpack.config.js           # Webpack configuration
└── dist/                       # Build output directory (generated)
```

## Available Scripts

### Build Scripts
- `npm run build` - Build for production (minified and optimized)
- `npm run build:dev` - Build for development (with source maps)
- `npm run watch` - Build for development and watch for changes

### Runtime Scripts
- `npm start` - Start the main server
- `npm run dev` - Start the live preview server

## Installation

1. Install dependencies:
```bash
npm install
```

2. Build the project:
```bash
# For production
npm run build

# For development
npm run build:dev
```

## Build Output

The build process will:
1. Bundle the following JavaScript files:
   - `server.js` (main server)
   - `livepreviewserver.js` (live preview server)
   - `designOption/CPGetDesignOptionContent.js`
   - `designOption/fsAdapter.js`
   - `review/upload.js`
   - `review/utils.js`
2. Exclude `node_modules` from the bundle
3. Output bundled files to the `dist/` directory
4. Apply optimization and minification in production mode

## Webpack Configuration

The webpack configuration:
- Targets Node.js environment
- Excludes node_modules as externals
- Creates separate bundles for each JavaScript file
- Applies Terser minification in production
- Generates source maps in development

## Development Workflow

1. **Development**: Use `npm run watch` to automatically rebuild on file changes
2. **Testing**: Run `npm run build:dev` to build with source maps for debugging
3. **Production**: Use `npm run build` for optimized production builds

## File Structure After Build

```
dist/
├── server.js                    # Bundled main server
├── livepreviewserver.js         # Bundled live preview server
├── designOption/
│   ├── CPGetDesignOptionContent.js
│   └── fsAdapter.js
├── review/
│   ├── upload.js
│   └── utils.js
```

## Notes

- The build system bundles specific JavaScript files for optimal performance
- Node modules are treated as externals and not bundled
- Console logs are preserved in production builds for debugging
- Source maps are generated in development mode for easier debugging 