// polyfills.js

// -------------------------------------------------------------------------
// CRITICAL: Ensure global.crypto and global.fetch are exposed.
// This MUST be at the very top of this file to ensure they are available
// before any other code (including transitive dependencies) runs.
// -------------------------------------------------------------------------

// Crypto polyfill/exposure for crypto.getRandomValues()
if (typeof global.crypto === 'undefined' || typeof global.crypto.getRandomValues === 'undefined') {
  try {
    const { webcrypto } = require('node:crypto');
    if (webcrypto && typeof webcrypto.getRandomValues === 'function') {
      global.crypto = webcrypto;
      console.log('Node.js native Web Crypto API exposed as global.crypto');
    }
  } catch (e) {
    console.warn('Could not expose native Node.js crypto.webcrypto:', e.message);
  }
} else {
  console.log('global.crypto.getRandomValues already present.');
}

// Fetch API exposure
// Node.js 18+ has native global fetch. We just need to ensure it's on 'global'.
if (typeof global.fetch === 'undefined') {
  try {
    // In Node.js 18+, fetch is typically part of the global scope.
    // If it's not here, it might be due to webpack's `node` configuration.
    // The webpack.config.js has been adjusted to set `global: true` which should help.
    // If you still face issues, you might need `const fetch = require('node-fetch');` here
    // and ensure 'node-fetch' is installed in your package.json.
    console.warn('global.fetch is undefined, which is unexpected in Node.js 18+. Check webpack config or environment.');
    // Attempt to directly assign Node.js's native fetch if it exists on globalThis but not global.
    if (typeof globalThis.fetch !== 'undefined') {
        global.fetch = globalThis.fetch;
        global.Headers = globalThis.Headers;
        global.Request = globalThis.Request;
        global.Response = globalThis.Response;
        console.log('Node.js native Fetch API exposed as global.fetch');
    }
  } catch (e) {
    console.warn('Could not ensure global.fetch availability:', e.message);
  }
} else {
  console.log('global.fetch already present.');
}

// -------------------------------------------------------------------------
// Other Polyfills (if genuinely needed and not provided by Node.js natively)
// -------------------------------------------------------------------------

// Polyfill for XMLHttpRequest (if needed, typically for older code relying on browser XMLHttpRequest)
try {
  if (typeof global.XMLHttpRequest === 'undefined') {
    const XMLHttpRequest = require('xmlhttprequest').XMLHttpRequest;
    global.XMLHttpRequest = XMLHttpRequest;
    console.log('XMLHttpRequest polyfill loaded');
  }
} catch (error) {
  console.warn('Could not load XMLHttpRequest polyfill (xmlhttprequest module might be missing):', error.message);
}

// Mock other browser globals that might be needed by some libraries
global.window = global.window || global;
global.document = global.document || {};
global.navigator = global.navigator || {};
global.location = global.location || {};

console.log('All polyfills setup attempts completed from polyfills.js.');