const fs = require("fs");

class FSAdapter {
    readDir(dirPath) {
        return fs.readdirSync(dirPath)
    }
    isDirectory(filePath) {
        return fs.statSync(filePath).isDirectory();
    }
    readFile(dirPath, fileName) {
        return fs.promises.readFile(dirPath + "/" + fileName)
    }
}

module.exports = new FSAdapter();

