/*
 *  ADOBE CONFIDENTIAL
 *
 *  Copyright 2006-2024, Adobe Systems Incorporated
 *
 *  All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains the property of
 *  Adobe Systems Incorporated and its suppliers, if any.  The intellectual and
 *  technical concepts contained herein are proprietary to Adobe Systems
 *  Incorporated and its suppliers and may be covered by U.S. and Foreign
 *  Patents, patents in process, and are protected by trade secret or copyright
 *  law.  Dissemination of this information or reproduction of this material is
 *  strictly forbidden unless prior written permission is obtained from Adobe
 *  Systems Incorporated.
 *
 *   Author: Nitesh Bhargava<nbhargava@adobe.com>, 24-Nov-2023
 */
require('../../polyfills.js');
const { createHash } = require('crypto');
const { createHTTPService } = require('@dcx/http');

async function generateMD5Hash(buffer) {
	const md5Hash = createHash('md5');
	md5Hash.update(buffer);
	return md5Hash.digest('base64');
}

function createHTTPServiceSetAPIKey(appKey, authToken) {
	const service = createHTTPService(function (service) {
		service.setAuthToken(authToken);
	});
	service.setApiKey(appKey);
	return service;
}

function getPlatFormUrl(env) {
	if(env === 'stage') {
		return "https://platform-cs-stage.adobe.io";
	}
	return "https://platform-cs.adobe.io";
}

function getCCreviewURL(env) {
	if(env === 'stage') {
		return 'https://ccassetreview-stage.adobe.io/api/v1';
	}
	return  'https://ccassetreview.adobe.io/api/v1';
}
module.exports = { generateMD5Hash, createHTTPServiceSetAPIKey, getPlatFormUrl, getCCreviewURL};