/*
 *  ADOBE CONFIDENTIAL
 *
 *  Copyright 2006-2016, Adobe Systems Incorporated
 *
 *  All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains the property of
 *  Adobe Systems Incorporated and its suppliers, if any.  The intellectual and
 *  technical concepts contained herein are proprietary to Adobe Systems
 *  Incorporated and its suppliers and may be covered by U.S. and Foreign
 *  Patents, patents in process, and are protected by trade secret or copyright
 *  law.  Dissemination of this information or reproduction of this material is
 *  strictly forbidden unless prior written permission is obtained from Adobe
 *  Systems Incorporated.
 *
 *   Author: Soham Sardar<ssardar@adobe.com>, 24-Nov-2017
 */
require('../polyfills.js');
const AWS = require('aws-sdk');
var express = require("express");
var app = express();
//var proxy = require('http-proxy-middleware');
var bodyParser = require("body-parser");
var fs = require("fs");
var os = require("os");
var fontFinder = require("font-finder");
var path = require("path");
var opn = require("opn");
var child_process = require("child_process");
var puppeteer = require("puppeteer");
var client = require("https");
var https = require("https");
const crypto = require('crypto');
var http = require("http");
const fsPromises = fs.promises;
const { createRepoAPISession } = require("@dcx/repo-api-session");
const {
  Directory,
  DirectoryMediaType,
  createAsset,
  File,
} = require("@dcx/assets");
const { getAllFilePathForDirectories, getDesignOptionJsonFromFilePath } = require("./designOption/CPGetDesignOptionContent");
const fsImpl = require("./designOption/fsAdapter");

var qs = require("querystring");
var cpTempDirectoryPath;
var cpContentDirectoryPath;
var cpProjectDirectoryPath;
var cpCharacterDirectoryPath;
var cpStockDirectoryPath;
var cpChromiumExecPath;
var ppid = -1;
var cpApplicationMode = ""; //Make it a number?
var cpDesignOptionsELearningAssetsPath;// eLearning assets directory path
var UI_COMPONENTS_ROOT = path.resolve(__dirname, "../ui_components");
var desingOptionsInstallDirPath = path.resolve(__dirname, "../DesignOptions"); // install directory Design option path. 
var defaultThemesPath = path.resolve(__dirname, "../Gallery/Layouts/13_0/ThemeV1");

// Theme editor sample project data path. We are reading from INSTALLDIR
var cpThemeEditorAssetsPath = "../Gallery/Layouts/13_0/ThemeEditorAssets";
var cpThemeEditorSampleProjectDataPath = path.resolve(__dirname, cpThemeEditorAssetsPath,"ThemeEditorSlides.json");
var cpThemeEditorSampleProjectImagesPath = path.resolve(__dirname, cpThemeEditorAssetsPath, "images");

const { uploadReview, updateReview, listReviews, findProjectDirectory, renameAsset, getCacheKey, discardAsset, uploadComponents } = require("./review/upload");
const { createHTTPServiceSetAPIKey, getPlatFormUrl } = require("./review/utils");
const { getSystemFonts } = require("./systemFontFinder");
var freep = -1;

// var ELEARNING_HOME = "https://elearning.adobe.com";
// var JsSearch = require('js-search');
//TODO: suni@ global variables are a discouraged practice. Will revisit this later and use express's system of configuration management
//      been facing issues with it as of now. Focused on improving the build time of CPNextUI
global.developmentMode = false;

var CHROMIUM_PATH_MAC_INTEL = '/chrome/mac-117.0.5938.92/chrome-mac-x64/Google Chrome for Testing.app/Contents/MacOS/Google Chrome for Testing';
var CHROMIUM_PATH_MAC_ARM = '/chrome/mac_arm-117.0.5938.92/chrome-mac-arm64/Google Chrome for Testing.app/Contents/MacOS/Google Chrome for Testing';
var CHROMIUM_PATH_WIN = '/.cache/puppeteer/chrome/win64-117.0.5938.92/chrome-win64/chrome.exe';
var PUPPETTER_DEV_MODE = false; // flip this see the thumbnail magic happening in Chromium browser.

app.use(bodyParser({ limit: '50mb' })); // Increased the limit to accomodate puppeteer related changes.

const PLATFORM_URL = getPlatFormUrl("prod");

try {
  // Checking if the development.txt file is present in the dist folder. If yes, the the mode is 'development' else 'production'
  const developmentFile = path.resolve(
    __dirname,
    "../CPNextUI/dist/development.txt"
  );

  if (fs.existsSync(developmentFile)) {
    console.log("The mode of operation is 'development'");
    global.developmentMode = true;
  }
} catch (err) {
  console.error("Operation failed to check development mode", err);
}

//Adding middleware to set response header indicating if Development Mode is true
app.use((req, res, next) => {
  if (global.developmentMode === true) {
    res.set("DevelopmentMode", "True");
  }
  next();
});

app.use(bodyParser.json()); // support json encoded bodies
app.use(
  bodyParser.urlencoded({
    extended: true,
  })
); // support encoded bodies
app.use(express.static(__dirname));
app.use("/ui_components", express.static(UI_COMPONENTS_ROOT));
app.get("/cpnext/dist/*.js", function (req, res, next) {
  if (
    req.url !== "/cpnext/dist/runtime~main.bundle.js" &&
    req.url !== "/cpnext/dist/runtime~welcome.bundle.js" &&
    req.url !== "/cpnext/dist/runtime~captureDialog.bundle.js" &&
    req.url !== "/cpnext/dist/runtime~themeEditor.bundle.js" &&
    req.url !== "/cpnext/dist/cpAppEnv.js" &&
    global.developmentMode === false
  ) {
    req.url = req.url + ".br";
    res.set("Content-Encoding", "br");
    res.set("Content-Type", "text/javascript");
  }
  next();
});

function generateEnvFile() {
  //cpAppEnv.js file needs to be generated. This file contains environment variables for frontend
  let envFile = path.resolve(__dirname, "../CPNextUI/cpAppEnv.js");
  try {
    fs.writeFileSync(
      envFile,
      `
      window.__CP_APP_MODE__ = "${cpApplicationMode}"
      `
    );
  } catch (e) {
    console.log(
      "Failed to edit Captivate Env!",
      " Error=",
      e.name,
      ": " + e.message
    );
  }
}

/*
 * Thumbnail image creation code starts from here. Thumbnails images are taken
 * using Pupeeteer.  Puppeteer is headless browser, Chromium packaged as a node module.
 * This allows the clients to load a web page and take snapshots of the same.
 * To take the snapshot image of the thumbnail DOM, we are extracing styles,
 * sticking the same with `outerHTML` of the thumbnail DOM. In the future we should
 * use at a case where charm is running in a minimal way in the browser. This would
 * be way faster for taking screenshots of the thumbnail DOM.
*/

// Global puppeteer browser instance. Instead of creating multiple instances of browser
// we create one and reuse the same for snapshoting.
let gBrowser = null;
let gHeadStylesString = null;
let gBrowserPid = null;

/**
 * Tries to kill the existing browser process
 * because the browser might have got detached.
 */
let closeAnyExistingBrowserInstance = () => {
  if (gBrowser && !gBrowser.isConnected()) {
    try {
      if (gBrowserPid) {
        process.kill(gBrowserPid);
      }
    } catch (err) {
      // This is a non critical error. We can safely
      // ignore any errors.
      console.log(`Error occured in closeAnyExistingBrowserInstance: Error: ${err.toString()}`)
    }
    finally {
      gBrowserPid = null;
      gBrowser = null;
    }
  }
}

/**
 *
 * This function makes sure we have a valid puppeteer browser instance used for taking
 * thumbail snapshots.
 */
let ensureBrowser = async () => {
  // Check if we have a valid browser. If not, go ahead and create one.
  if (!gBrowser || !gBrowser.isConnected()) {
    closeAnyExistingBrowserInstance();

    let tempFolderName = cpTempDirectoryPath + "/ImageCache/";
    
    // Use __dirname since the server runs from nodejs directory, not server directory
    const baseCachePath = path.join(__dirname, '.cache', 'puppeteer');
    
    let executablePath = null;
    
    // Try to find the correct Chrome executable based on platform and architecture
    if (process.platform === "darwin") {
      // For Mac, use architecture-specific path based on current architecture
      const isArm = process.arch === 'arm64';
      const chromePath = isArm ? 
        path.join(baseCachePath, 'mac_arm', 'chrome-mac-arm64', 'Google Chrome for Testing.app', 'Contents', 'MacOS', 'Google Chrome for Testing') :
        path.join(baseCachePath, 'mac_intel', 'chrome-mac-x64', 'Google Chrome for Testing.app', 'Contents', 'MacOS', 'Google Chrome for Testing');
      
      if (fs.existsSync(chromePath)) {
        executablePath = chromePath;
      }
    } else if (process.platform === "win32") {
      // For Windows, use Intel architecture path
      const chromePath = path.join(baseCachePath, 'win_intel', 'chrome-win64', 'chrome.exe');
      
      if (fs.existsSync(chromePath)) {
        executablePath = chromePath;
      }
    }
    
    try {
      // Try with custom executable path if found
      if (executablePath && fs.existsSync(executablePath)) {
        gBrowser = await puppeteer.launch({
          executablePath: executablePath,
          headless: !PUPPETTER_DEV_MODE,
          userDataDir: tempFolderName
        });
      } else {
        // Fallback to default Puppeteer Chrome
        gBrowser = await puppeteer.launch({
          headless: !PUPPETTER_DEV_MODE,
          userDataDir: tempFolderName
        });
      }

      gBrowserPid = gBrowser.process().pid;

      // It is important we listen to this call as there are cases on mac where
      // the browser is getting disconnecting from node, in case system sleeps.
      // TODO - Need a way to figure out the system sleep and close the browser
      // accordingly. Otherwise there would be zombie Chromium instances running
      // but disconnected.
      gBrowser.on('disconnected', () => {
        // Browser connection seem to be lost. Try to close any existing instance
        closeAnyExistingBrowserInstance();
      });
    } catch (error) {
      console.error("Failed to launch browser:", error);
      throw error;
    }
  }
}

/**
 * 
 * API to initialize the styles string in node. This method also makes sure
 * there is a valid browser instance, apart from initializing the styles.
 * @req - request object. It contains the styles string that goes into the
 * `<head>` of the snapshot HTML.
 * @res - used to send success or failure messages.
 */
app.post("/initStyles", async function (req, res) {
  try {
    gHeadStylesString = req.body.headData;

    await ensureBrowser();

    res.send({ msg: "success" });
  } catch (err) {
    res.send({ err: err.toString() });
  }
});

/**
 * Sanitize HTML content to remove problematic JavaScript
 */
function sanitizeHTML(html) {
  // Remove script tags and their content
  html = html.replace(/<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi, '');
  
  // Remove event handlers (onclick, onload, etc.)
  html = html.replace(/\s*on\w+\s*=\s*["'][^"']*["']/gi, '');
  
  // Remove javascript: URLs
  html = html.replace(/javascript:/gi, '');
  
  // Remove any remaining script-like content
  html = html.replace(/<[^>]*script[^>]*>/gi, '');
  
  return html;
}

/**
 *
 * API to take a snapshot of the thumbnail HTML DOM using puppeteer. Thumbnail creation
 * using puppeteer is done as a two part process. First time a thumbnail image is requested,
 * we first extract all the styles from Charm as a string and set these once using the
 * `initStyles` call. This is for optimizing the amount of HTML that is getting extracted
 * during the thumbail snapshot creation call. Styles seldom change in Charm (updating presets
 * or changing theme etc.). We update the styles only in these cases. Once the styles are updated
 * we stich the styles and the HTML node outerHTML into a HTML. We then take the snapshot of this HTML.
 * @req - request object. It contains the `outerHMTL` of the thumbnail node, the file to which the image needs
 * to be saved to and the size of the target thumbnail image.
 * @res - used to send success or failure messages.
 */

app.post("/createThumbnail", async function (req, res) {

  try {
    var thumbnailHTML = req.body.thumbnailHTML;
    var fileName = req.body.fileName;
    var thumbnailSize = req.body.thumbnailSize;
    var filePath = cpTempDirectoryPath + "/ImageCache/" + fileName;
    var page = null;

    // Make sure we have a valid browser instance.
    await ensureBrowser();

    // create new page object.
    page = await gBrowser.newPage();

    // Combine the thumbnail snapshot along with the styles data to form a proper HTML.
    var htmlContent = "<html>" + gHeadStylesString + "<body>" + decodeURIComponent(thumbnailHTML) + "</body></html>";
    
    // Sanitize the HTML to remove problematic JavaScript
    htmlContent = sanitizeHTML(htmlContent);

    // set viewport width and height
    await page.setViewport({ width: thumbnailSize.width, height: thumbnailSize.height });

    // Disable JavaScript to prevent browser API access errors
    await page.setJavaScriptEnabled(false);

    // finally set the content in the page.
    try {
      // Use goto with data URL instead of setContent to avoid JavaScript evaluation issues
      const dataUrl = 'data:text/html;charset=utf-8,' + encodeURIComponent(htmlContent);
      await page.goto(dataUrl, {
        waitUntil: 'domcontentloaded',
        timeout: 30000
      });
    } catch (contentError) {
      // Try again with a simpler approach - create a temporary file
      try {
        const tempHtmlPath = path.join(cpTempDirectoryPath, 'temp_thumbnail.html');
        fs.writeFileSync(tempHtmlPath, htmlContent, 'utf8');
        const fileUrl = 'file://' + tempHtmlPath;
        await page.goto(fileUrl, { waitUntil: 'domcontentloaded', timeout: 30000 });
        // Clean up temp file
        fs.unlinkSync(tempHtmlPath);
      } catch (fileError) {
        throw contentError; // Throw original error
      }
    }

    await page.screenshot({ path: filePath });

    res.send({ message: "success", source: filePath });

  } catch (err) {
    // Send error back to client.
    res.send({ err: err.toString() });
  } finally {
    if (page) {
      page.close();
    }
  }
});

process.on('exit', () => {
  if (gBrowser && gBrowser.isConnected()) {
    gBrowser.close();
  }
})
app.use("/cpnext", express.static(path.resolve(__dirname, "../CPNextUI")));
app.use("/cpnext/placeholder", express.static(path.resolve(__dirname, "../CPNextUI/src/assets/placeholder")));
const defaultImagePath = path.resolve(
  __dirname,
  "../CPNextUI/src/assets/vr/" + "DefaultImage.png"
);
const resizeHandlerPath = path.resolve(
  __dirname,
  "../ui_components/ThreeDSlideRenderer/resources/" + "ThreeD_ResizeHandler.svg"
);

app.use("/designoptions", express.static(desingOptionsInstallDirPath));
try {
  var arguments = JSON.parse(process.argv[2]);
  cpTempDirectoryPath = arguments.TempFolderPath;
  cpContentDirectoryPath = arguments.SharedFolderBasePath;
  cpProjectDirectoryPath = arguments.ProjectsFolderPath;
  cpCharacterDirectoryPath = arguments.CharacterFolderPath;
  cpStockDirectoryPath = arguments.StockFolderPath;
  cpApplicationMode = arguments.AppMode;

  if (arguments.PreferencesFolderPath && process.platform === "darwin") {
    if (!fs.existsSync(arguments.PreferencesFolderPath + CHROMIUM_PATH_MAC_INTEL)) {
      cpChromiumExecPath = arguments.PreferencesFolderPath + CHROMIUM_PATH_MAC_INTEL;
    } else {
      cpChromiumExecPath = arguments.PreferencesFolderPath + CHROMIUM_PATH_MAC_ARM;
    }
  } else {
    cpChromiumExecPath = __dirname + CHROMIUM_PATH_WIN;
  }
  cpDesignOptionsELearningAssetsPath =
    arguments.DesignOptionsELearningAssetsPath; // eLearning assets path

  app.use(
    "/customDesignOptions",
    express.static(path.resolve(cpDesignOptionsELearningAssetsPath))
  );
  app.use("/preview", express.static(path.resolve(cpTempDirectoryPath)));
  app.use("/showcontent", express.static(path.resolve(cpContentDirectoryPath)));
  app.use("/showstock", express.static(path.resolve(cpStockDirectoryPath)));
  app.use(
    "/showcharacter",
    express.static(path.resolve(cpCharacterDirectoryPath))
  );
  app.use(["/data"], express.static(path.resolve(cpTempDirectoryPath, "../")));
  generateEnvFile();
  ppid = process.argv[3];
  let portFilePath = cpTempDirectoryPath + "/" + "node_port.txt";
  try {
    var listener = app.listen(0, "0.0.0.0", function (err, data) {
      freep = `${listener.address().port}`;
      console.log("node server listening on port: " + freep);
      if (err) {
        console.log("Listen error: " + err.toString());
      }
      fs.writeFileSync(portFilePath, freep, (err) => {
        if (err) throw err;
      });
      console.log("server started at port: " + freep);
    });
  } catch (ex) {
    console.log("Listen exception: " + ex);
  }

  if (ppid >= 0) {
    setInterval(function () {
      if (ppid != process.ppid) {
        process.exit(1);
      }
    }, 1 * 60 * 1000);
  }
} catch (err) {
  console.error(err);
  let portFilePath = cpTempDirectoryPath + "/" + "log.txt";
  fs.writeFileSync(portFilePath, err, (err) => {
    if (err) throw err;
  });
}

app.get("/", function (req, res) {
  var indexFilePath = path.resolve(__dirname, "./deploy/index.html");
  res.sendFile(indexFilePath);
});

app.get("/previewFromPublishFolder", function (req, res) {
  var filePath = req.query.filePath;
  var indexFilePath = path.resolve(filePath, "./index.html");
  opn(indexFilePath);
  res.send({ message: "success" });
});

app.get("/getSystemFonts", async (req, res) => {
  try {
    const fontList = await getSystemFonts();
    res.send({ fontList });
  } catch (e) {
    console.error("Error fetching fonts:", e);
    res.status(500).send({ error: "Font parsing failed", details: e.message });
  }
});

app.get("/getImageData", function (req, res) {
  var fileName = req.query.fileName;
  var isThemeEditor = req.query.isThemeEditor;

  var srcPath = null;
  if (isThemeEditor) {
    srcPath = path.join(cpThemeEditorSampleProjectImagesPath, fileName);
  } else {
    srcPath = cpTempDirectoryPath + "/ImageCache/" + fileName;
  }

  if (!fs.existsSync(srcPath)) {
    res.status(404).send({
      err: "File " + fileName + " doesn't exist",
    });
    return;
  }

  var data = fs.readFile(srcPath, "base64", function (err, data) {
    if (!err) {
      res.send({
        image: data,
      });
    }
    else {
      res.status(500).send({
        err: err,
      });
    }
  })
});

app.post("/createFile", function (req, res) {
  try {
    var fileData = req.body.base64Encoded;
    var fileName = req.body.fileName;
    var filePath = cpTempDirectoryPath + "/" + fileName;
    const fileDataBuffer = Buffer.from(fileData, 'base64');
    fs.writeFileSync(filePath, fileDataBuffer);
    res.send({ filePath: filePath });
  } catch (err) {
    // Send error back to client.
    res.send({ err: err.toString() });
  }
});


app.post("/createFileFromURL", function (req, res) {
  try {
    const url = req.body.url;
    const fileName = req.body.fileName;
    const filePath = process.platform !== "win32" ? cpTempDirectoryPath + "/" + fileName : cpTempDirectoryPath + "\\" + fileName;

    // Create write stream for the destination file
    const writeStream = fs.createWriteStream(filePath);

    // Use https for HTTPS URLs
    const protocol = url.startsWith('https') ? https : http;
    
    // Make HTTP/HTTPS request to the URL
    protocol.get(url, (response) => {
      // Check if the request was successful
      if (response.statusCode !== 200) {
        writeStream.close();
        fs.unlink(filePath, () => {}); // Clean up the file
        return res.status(response.statusCode).send({ 
          err: `Failed to download file: ${response.statusCode}` 
        });
      }

      // Pipe the response directly to the file
      response.pipe(writeStream);

      // Handle completion
      writeStream.on('finish', () => {
        writeStream.close();
        res.send({ filePath: filePath });
      });

      // Handle errors
      writeStream.on('error', (err) => {
        writeStream.close();
        fs.unlink(filePath, () => {}); // Clean up the file
        res.status(500).send({ err: err.toString() });
      });
    }).on('error', (err) => {
      writeStream.close();
      fs.unlink(filePath, () => {}); // Clean up the file
      res.status(500).send({ err: err.toString() });
    });

  } catch (err) {
    res.status(500).send({ err: err.toString() });
  }
});

app.post("/createImageFile", function (req, res) {
  const fileData = req.body.base64Encoded;
  const fileName = req.body.fileName;
  const blurSlideItemDirPath = cpTempDirectoryPath + "/ImageCache/BlurImageCache/";
  const filePath = blurSlideItemDirPath + fileName;
  const base64Data = decodeURIComponent(fileData).replace(
    /^data:image\/png;base64,/,
    ""
  );
  if (base64Data.length > 0) {
    fs.writeFile(filePath, base64Data, { encoding: 'base64' }, function (err) {
      if (!err) {
        res.send({ message: "success" });
      } else {
        res.send({
          err: err,
        });
      }
    });
  }
});

app.post("/createImage", function (req, res) {
  try {
    var fileData = req.body.base64Encoded;
    var fileName = req.body.fileName;
    var replaceExisting = req.body.replaceExisting === undefined ? true : Boolean(req.body.replaceExisting);
    var filePath = cpTempDirectoryPath + "/ImageCache/" + fileName;
    if (!fs.existsSync(filePath) || replaceExisting) {
      const imageDataBuffer = Buffer.from(fileData, 'base64');
      fs.writeFileSync(filePath, imageDataBuffer);
    }
    res.send({ filePath: filePath });
  } catch (err) {
    // Send error back to client.
    res.send({ err: err.toString() });
  }
});

app.post("/downloadImage", (req, res) => {
  const downloadImage = (imageUrl, outputPath) => {
    return new Promise((resolve, reject) => {
      const options = {
        headers: {
          'Accept-Encoding': 'gzip, deflate',
        },
      };

      client.get(imageUrl, options, (response) => {
        if (response.statusCode !== 200) {
          res.status(response.statusCode);
          res.send({ message: "Error" });
          reject(new Error(`Request Failed with a Status Code: ${response.statusCode}`));
          return;
        }

        const fileStream = fs.createWriteStream(outputPath);
        response.pipe(fileStream);

        fileStream.on('finish', () => {
          fileStream.close();
          res.status(200);
          const finalPath = outputPath.replace(/\\/g, "/");
          res.send({ message: finalPath });
          resolve();
        });

        fileStream.on('error', (error) => {
          res.status(500);
          res.send({ message: `Error. ${JSON.stringify(error)}` });
          reject(error);
        });
      });
    });
  };
  var outputPath = path.resolve(cpTempDirectoryPath + `/ImageCache/${req.body.fileName}`);
  downloadImage(req.body.url, outputPath)
    .then(console.log)
    .catch(console.error);
})

app.get("/placeholder/mac", async function (req, res) {
  try {
    res.send("../CPNextUI/src/assets/placeholder/mac/index.html");
  } catch (err) {
    // Send error back to client.
    res.send({ err: err.toString() });
  }
});

app.get("/placeholder/win", async function (req, res) {
  try {
    res.send("../CPNextUI/src/assets/placeholder/win/index.html");
  } catch (err) {
    // Send error back to client.
    res.send({ err: err.toString() });
  }
});

app.get("/doesFileExistAlready", function (req, res) {
  var fileName = req.query.file;
  if (fileName && fs.existsSync(fileName)) res.send({ message: "success" });
  else res.send({ message: "failure" });
});

app.get("/doesPathExist", async function (req, res) {
  var folderPath = req.query.path;
  fs.access(folderPath, fs.constants.R_OK | fs.constants.W_OK, (err) => {
    if (err) {
      res.send(404, { err: err })
    } else {
      res.send(200, {})
    }
  });
})

app.get("/viewFolder", function (req, res) {
  var folderName = req.query.folder;
  if (folderName && fs.existsSync(folderName)) {
    var cmd = process.platform === "win32" ? "start" : "open";
    child_process.exec(cmd + ' "" "' + folderName + '"', function (error) {
      res.send({ message: "success" });
    });
  } else {
    res.send({ message: "failure" });
  }
});

app.get("/openURL", function (req, res) {
  opn(req.query.url);
  res.send({ message: "success" });
});

app.get("/convertImage", function (req, res) {
  var fileName = req.query.file;
  var srcPath;
  if (fileName == undefined || fileName == "undefined" || fileName == "")
    srcPath = defaultImagePath;
  else {
    if (req.query.objectType == "SVG")
      srcPath = cpTempDirectoryPath + "/" + req.query.file;
    else srcPath = cpTempDirectoryPath + "/ImageCache/" + req.query.file;
  }
  console.log(srcPath);
  var data = fs.readFile(srcPath, "base64", function (err, data) {
    if (!err) {
      console.log("File read done and Sending Data");
      res.send({
        image: data,
      });
    } else {
      res.send({
        err: err,
      });
    }
  });
});

const designOptionDirectoryApiInfo = {
  [desingOptionsInstallDirPath]: { apiUrl: "/designoptions", isCustomDesignOption: false },
  [cpDesignOptionsELearningAssetsPath]: { apiUrl: "/customDesignOptions", isCustomDesignOption: true },
}

/**
 * Api to get all the default design options for widgets.
 * @req - request object. it has locale, that we passed as a query param.
 * @res - res object is used to send response to ui. we send all the default design option to ui as a response.
 */
app.get("/getDesignOptions", async function (req, res) {
  // desingOptionsInstallDirPath: install directory Designoption path
  // cpDesignOptionsELearningAssetsPath: eLearning assets directory path fordesign option.
  const directories = [
    desingOptionsInstallDirPath,
    cpDesignOptionsELearningAssetsPath,
  ];
  const locale = req.query.locale;
  const { filePaths, dirTree } = getAllFilePathForDirectories(directories, fsImpl, designOptionDirectoryApiInfo);
  const { newDesignOptions, designOptionThumbnailMap } = await getDesignOptionJsonFromFilePath(filePaths, locale, fsImpl);
  Promise.all(newDesignOptions)
    .then((response) => {
      const designOptions = response.filter((res) => !!res);
      res.send({
        designOptions,
        dirInfo: dirTree,
        designOptionThumbnailMap,
      });
    })
    .catch((error) => {
      res.send({
        err: error.message,
      });
    });
});

/**
 * Api to get all the design options from a specific zip or directory in import workflow.
 * @req - request object. it has locale, that we passed as a query param.
 * @res - res object is used to send response to ui. we send all the default design option to ui as a response.
 */
app.get("/getDesignOptionsForImportWorkflow", async function (req, res) {
  const designOptionImportPath = req.query.designOptionImportPath;
  const locale = req.query.locale;
  const directories = [
    desingOptionsInstallDirPath,
    designOptionImportPath,
  ];
  const importDirInfo = {
    [desingOptionsInstallDirPath]: { isCustomDesignOption: false },
    [designOptionImportPath]: { isCustomDesignOption: true },
  }
  try {
    const { filePaths } = getAllFilePathForDirectories(directories, fsImpl, importDirInfo);
    let { newDesignOptions, designOptionThumbnailMap } = await getDesignOptionJsonFromFilePath(filePaths, locale, fsImpl);
    newDesignOptions = newDesignOptions.filter((res) => res && res.isCustomDesignOption);
    res.send({
      designOptions: newDesignOptions,
      designOptionThumbnailMap,
    });
  } catch (error) {
    res.send({
      err: error.message,
    });
  }
});

/**
 * Api to get all the theme files .
 * @req - nothing.
 * @res - res object is used to send response to ui. we send all the themes to ui as a response.
 */
app.get("/getThemes", function (req, res) {
  const themes = [];
  const themePath = path.join(cpDesignOptionsELearningAssetsPath, "../Layouts/ThemeV1");

  // First get default themes from INSTALLDIR
  // Then get user themes from eLearningAssets
  let themeFolders = getAllFilePathForDirectories([defaultThemesPath], fsImpl, designOptionDirectoryApiInfo).filePaths.concat(getAllFilePathForDirectories([themePath], fsImpl, designOptionDirectoryApiInfo).filePaths);

  themeFolders.forEach((directory) => {
    let themesObj = {};
    fs.readdirSync(directory.dirPath).forEach(file => {
      const localPath = path.join(directory.dirPath, file);
      const dirName = directory.dirPath.split("\\").splice(-1)[0];
      // Check if the file is a JSON file, read it and add it to the themes object
      // This is to avoid files like .DS_Store etc that might be present in the directory
      if (file.endsWith(".json")) {
        const fileContent = JSON.parse(fs.readFileSync(localPath, { encoding: "utf8" }))
        const fileName = file.replace(".json", "")
        themesObj.dirName = dirName;
        themesObj[fileName] = fileContent;
      }
    });
    themes.push(themesObj)
  })

  res.send({ themes })
})

app.get("/getThemeEditorData", function (req, res) {
  try {
    const data = JSON.parse(fs.readFileSync(cpThemeEditorSampleProjectDataPath, 'utf8'));
    return res.send({ data })
  } catch (err) {
    console.error(err);
    return res.send({ err })
  }
})

app.get("/getTempLocation", function (req, res) {
  let filePath = os.tmpdir();
  res.send({ "tempDirPath": filePath });
});

app.post("/getAudioData", function (req, res) {
  var filePath = req.body.filePath;
  let buffer = fs.readFileSync(filePath);
  res.send(buffer);
});

function execPythonCommand(req, res, pyFile) {
  var url = req.body.url;
  var scriptPath = path.resolve(__dirname, `./loaders/${pyFile}`);
  var pythonPath = os.platform() == 'win32' ? `${path.join(process.env.APPDATA, '..', 'Local')}\\Programs\\Python\\Python311\\python` :
    '/Library/Frameworks/Python.framework/Versions/3.11/bin/python3.11';
  const pythonCommand = (os.platform() == 'win32') ? pythonPath : `arch -arm64 ${pythonPath}`; // This is the command to run Python. On ARM64, it's usually 'python3'.
  const child = child_process.exec(`${pythonCommand} "${scriptPath}" "${url}"`, (error, stdout, stderr) => {
    if (error) {
      res.send({
        err_3: error,
      });
      return;
    }
    if (stderr) {
      res.send({
        err_2: stderr,
      });
      return;
    }
    res.send({
      response: stdout,
    });
    return;
  });
  child.on('exit', (code) => {
    if (code) {
      res.send({
        err_1: code,
      });
    }
  });
}

/*APi to load a pdf document using python */
app.post("/loadPDF", function (req, res) {
  execPythonCommand(req, res, 'PDFLoader.py');
});

/*APi to load a word document using python */
app.post("/loadWordDoc", function (req, res) {
  execPythonCommand(req, res, 'WordDocLoader.py');
});

app.post("/serviceToken", function (req, res) {
  var options = {
    'method': 'POST',
    'hostname': 'ims-na1-stg1.adobelogin.com',
    'path': '/ims/token/v1',
    'headers': {
      'content-type': 'application/x-www-form-urlencoded',
      'accept': 'application/json'
    },
    'maxRedirects': 20
  };
  var reqIms = client.request(options, function (resIms) {
    var chunks = [];

    resIms.on("data", function (chunk) {
      chunks.push(chunk);
    });

    resIms.on("end", function (chunk) {
      var body = Buffer.concat(chunks);
      res.send(body.toString())
    });

    resIms.on("error", function (error) {
      res.send(error)
    });
  });

  var postData = qs.stringify({
    'grant_type': 'authorization_code',
    'client_id': req.body.apiKey,
    'code': req.body.authCode,
    'client_secret': req.body.secCode
  });

  reqIms.write(postData);

  reqIms.end();
});

app.post("/saveAsThemeEditorJson", function (req, res) {
  let error = null;
  try {
    if (req.body) {
      fs.writeFile(cpThemeEditorSampleProjectDataPath, JSON.stringify(req.body, null, 2), (err) => { error = err; });
    }
  } catch (err) { error = err; }

  if (error) {
    console.log("ERROR: write file for saveAsThemeEditorJson: ", error);
    res.status(500).send({ error: error.toString() });
  } else {
    console.log("Write file for saveAsThemeEditorJson: ", error || "SUCCESS");
    res.status(200).send({ message: "SUCCESS" });
  }
})

app.post("/createAssetWithReviewContent", async function (req, res) {
  try {
    //const signal = req.abortController.signal;
    const accessToken = req.headers.authorization;
    const apiKey = req.headers["x-api-key"];

    const contentFolderPath = req.body.contentFolderPath;
    const assetNameToSet = req.body.assetName;
    const projectName = req.body.projectName;
    const projectID = req.body.projectGUID;

    const { assetId, projectDirectoryAssetId } = await uploadReview(accessToken, assetNameToSet, contentFolderPath, apiKey, projectID, projectName)

    const assetInfo = { assetId, assetNameToSet }
    res.send({ msg: "success", assetInfo, projectDirectoryAssetId });
  } catch (err) {
    res.status(400);
    //console.log(err)
    res.send({ err, msg: err.toString() });
  }
});

app.post("/populateAssetWithReviewContent", async function (req, res) {
  try {
    //const signal = req.abortController.signal;
    const accessToken = req.headers.authorization;
    const apiKey = req.headers["x-api-key"];

    const contentFolderPath = req.body.contentFolderPath;
    const assetURN = req.body.assetId;
    const projectName = req.body.projectName;
    const projectID = req.body.projectGUID;

    const { assetId, lastUpdatedOn } = await uploadComponents(accessToken, assetURN, contentFolderPath, apiKey, projectID, projectName)

    const assetInfo = { assetId }
    res.send({ msg: "success", assetInfo, lastUpdatedOn });
  } catch (err) {
    res.status(400);
    //console.log(err)
    res.send({ err, msg: err.toString() });
  }
});



app.post("/updateAssetWithReviewContent", async function (req, res) {
  try {
    const accessToken = req.headers.authorization;
    const apiKey = req.headers["x-api-key"];

    const contentFolderPath = req.body.contentFolderPath;
    const assetURN = req.body.assetURN;

    const { assetId, lastUpdatedOn } = await updateReview(accessToken, assetURN, contentFolderPath, apiKey)

    res.send({ msg: "success", assetId, lastUpdatedOn });
  } catch (err) {
    res.status(400);
    console.log(`Error while updating the asset: ${err}`);
    res.send({ err, msg: err.toString() });
  }
});

app.post("/getReviewList", async function (req, res) {
  try {
    const accessToken = req.headers.authorization;
    const projectId = req.body.projectId;
    const apiKey = req.headers["x-api-key"];
    const service = createHTTPServiceSetAPIKey(apiKey, accessToken);
    const session = createRepoAPISession(service, PLATFORM_URL);
    const projectDirectoryAssetId = await findProjectDirectory(accessToken, apiKey, projectId)
    if (projectDirectoryAssetId == null) {
      const reviewList = []
      res.send({ msg: "success", reviewList });
      return;
    }
    const reviewList = await listReviews(service, session, accessToken, projectDirectoryAssetId, apiKey)
    res.send({ msg: "success", reviewList, projectDirectoryAssetId });
  } catch (err) {
    res.status(400);
    console.log(`Error while getting the review list: ${err}`);
    res.send({ err, msg: err.toString() });
  }
});

app.post("/renameAsset", async function (req, res) {
  try {
    const accessToken = req.headers.authorization;
    const assetId = req.body.assetId;
    const newName = req.body.newName;
    const apiKey = req.headers["x-api-key"];
    const service = createHTTPServiceSetAPIKey(apiKey, accessToken);
    const session = createRepoAPISession(service, PLATFORM_URL);
    const resp = await renameAsset(session, assetId, newName);
    res.send({ msg: "success", resp });
  } catch (err) {
    res.status(400);
    console.log(`Error while renaming the asset: ${err}`);
    res.send({ err, msg: err.toString() });
  }
});

app.post("/deleteAsset", async function (req, res) {
  try {
    const accessToken = req.headers.authorization;
    const assetId = req.body.assetId;
    const apiKey = req.headers["x-api-key"];
    const service = createHTTPServiceSetAPIKey(apiKey, accessToken);
    const session = createRepoAPISession(service, PLATFORM_URL);
    const resp = await discardAsset(session, accessToken, apiKey, assetId);
    res.send({ msg: "success", resp })
  } catch (err) {
    res.status(400);
    console.log(`Error while deleting asset: ${err}`);
    res.send({ err, msg: err.toString() });
  }
});
app.get('/api/cache/:key', (req, res) => {
  const key = req.params.key;
  const data = getCacheKey(key)
  res.json({ key, data });
  // Check if the key exists in the cache

});

app.post("/uploadToS3", async function (req, res) {
  try {
    const { filePath, accessKeyId, secretAccessKey, sessionToken, region, bucketName, key } = req.body;
    AWS.config.update({
      accessKeyId,
      secretAccessKey,
      sessionToken,
      region
    });

    // Create an S3 instance
    const s3 = new AWS.S3();

    // Read the file from the specified path
    const convertedPath = filePath.replace(/\\/g, '/');
    const newPath = convertedPath.replace(/\.cpt$/, '.zip');
    const s3Key = key + "/" + path.basename(newPath);

    const fileData = await fs.promises.readFile(newPath);

    // Upload the file to S3 with progress tracking
    const uploadParams = {
      Bucket: bucketName,
      Key: s3Key,
      Body: fileData
    };
    const upload = s3.upload(uploadParams);
    upload.send((err, data) => {
      if (err) {
        res.status(400).send({ err, msg: err.toString() });
      } else {
        res.send({ msg: "success", data });
      }
    });

  } catch (err) {
    res.status(400).send({ err, msg: err.toString() });
  }
});

app.get("/genAiRes", async function (req, res) {
  try {
    const { url } = req.query;
    const options = new URL(url);
    options.method = 'GET';
    let chunks = [];
    client.get(options, (response) => {
      response.on('data', (chunk) => {
        chunks.push(chunk)
      });
      response.on('end', () => {
        const buffer = Buffer.concat(chunks);
        res.writeHead(200, { "Content-Type": "application/octet-stream" });
        res.end(buffer);
      });
    }).on('error', (err) => {
      res.status(400).send({ err: err.toString() });
    });
  } catch (err) {
    res.status(400).send({ err: err.toString() });
  }
});










// app.get('/getResizeHandler', function (req, res) {
//     var srcPath = resizeHandlerPath;
//     var data = fs.readFile(srcPath, 'base64', function(err, data) {
//         if (!err) {
//             console.log("File read done and Sending Data");
//             res.send({
//                 image: data
//             });
//         } else {
//             res.send({
//                 err: err
//             });
//         }
//     });
// });

// app.get('/writeImage', function(req, res){
//     var path = cpTempDirectoryPath + "/SlideThumbnail.jpeg";
//     var base64Data = decodeURIComponent(req.query.imageData).replace(/^data:image\/jpeg;base64,/, "") ;
//     if(base64Data.length > 0){
//         fs.writeFile(path, base64Data, 'base64', function(err) {
//             if (!err) {
//                 res.send({message: "success"});
//             }
//         });
//     }
// });

// app.get('/deletefile', function(req, res){
//     var file = req.query.path;
//     var deletePath = cpProjectDirectoryPath +"/" +file;
//     // delete file named 'sample.txt'
//     fs.unlink(deletePath, function (err) {
//         if (!err){
//             console.log('File deleted!');
//             res.send({deleted:true});
//         }
//         else{
//             res.send({deleted:false});
//         }

//     });
// });

// app.get('/downloadedassets', function(req, res){
//     var type = req.query.type;
//     var sortby = req.query.sortby;
//     var dir = "";
//     if(type == "projects"){
//         dir = cpProjectDirectoryPath;
//         if(dir != undefined && dir != ""){
//             fs.readdir(dir, function(err, files){
//                 if(!err){
//                 files = files.filter(function(fileName){
//                     var fileExtension = fileName.split('.').pop();
//                     if(fileExtension == "cptx"){
//                         return fileName;
//                     }
//                   })
//                   .map(function (fileName) {
//                     var currentPath = path.resolve(dir,fileName);
//                   return {
//                     res_name:fileName,
//                     asset_file_name: fileName,
//                     res_url: currentPath,
//                     time: fs.statSync(currentPath).mtime.getTime()
//                   };
//                 })
//                 .sort(function (a, b) {
//                     if(sortby == "recent")
//                         return b.time - a.time;
//                     else if(sortby == "name")
//                         return a.res_name.localeCompare(b.res_name);
//                     else
//                         return a.res_name.localeCompare(b.res_name);
//                     })
//                 .map(function (v) {
//                   return v });
//                 res.send({error:false,data:files});
//                 }
//                 else{
//                     res.send({error:true,data:[]})
//                 }
//               });

//         }
//         else{
//             res.send({error:true,data:[]})
//         }
//     }
//     else if(type == "characters"){
//         // var walk = function(dir, done) {
//         //     var results = [];
//         //     fs.readdir(dir, function(err, list) {
//         //       if (err) return done(err);
//         //       var pending = list.length;
//         //       if (!pending) return done(null, results);
//         //       list.forEach(function(file) {
//         //         file = path.resolve(dir, file);
//         //         fs.stat(file, function(err, stat) {
//         //           if (stat && stat.isDirectory()) {
//         //             walk(file, function(err, res) {
//         //               results = results.concat(res);
//         //               if (!--pending) done(null, results);
//         //             });
//         //           } else {
//         //             results.push(file);
//         //             if (!--pending) done(null, results);
//         //           }
//         //         });
//         //       });
//         //     });
//         //   };
//         //   var dirsToScan = [];
//         //   var isDirectoryType = function(file,parent_file,callback){
//         //         fs.stat(file, function(err, stat) {
//         //             if (stat && stat.isDirectory()) {
//         //                 callback({isDirectory:true,parent_file:parent_file});
//         //             }
//         //             else{
//         //                 callback({isDirectory:false,parent_file:parent_file});
//         //             }
//         //           });
//         //     }
//         // fs.readdir(directoryToScan, function(err, files){
//         //     var itemsProcessed = 0;
//         //     if(!err){
//         //         files.forEach(function(file) {
//         //             var parent_file = file;
//         //             file = path.resolve(cpCharacterDirectoryPath, file);
//         //             isDirectoryType(file,parent_file,function(response){
//         //                 if (response.isDirectory) {
//         //                     dirsToScan.push({file:file,parent_file:response.parent_file});
//         //                 }
//         //                 itemsProcessed++;
//         //                 if(itemsProcessed === files.length) {
//         //                     processCharacterParentDirs(dirsToScan);
//         //                 }
//         //             });
//         //         });
//         //     }
//         //     else{
//         //         res.send({error:false,data:[]});
//         //     }
//         //   fs.readdir(cpCharacterDirectoryPath, function(err, files){
//         //     var itemsProcessed = 0;
//         //     if(!err){
//         //         files.forEach(function(file) {
//         //             var parent_file = file;
//         //             file = path.resolve(cpCharacterDirectoryPath, file);
//         //             isDirectoryType(file,parent_file,function(response){
//         //                 if (response.isDirectory) {
//         //                     dirsToScan.push({file:file,parent_file:response.parent_file});
//         //                 }
//         //                 itemsProcessed++;
//         //                 if(itemsProcessed === files.length) {
//         //                     processCharacterParentDirs(dirsToScan);
//         //                 }
//         //             });
//         //         });
//         //     }
//         //     else{
//         //         res.send({error:false,data:[]});
//         //     }
//         //     var processCharacterParentDirs = function(dirs){
//         //         var characters = [];
//         //         var dirsProcessed = 0;
//         //         dirsToScan.forEach(function(dir){
//         //             var dirToScan = dir.file;
//         //             var dirParent = dir.parent_file;
//         //             fs.readdir(dirToScan, function(err, files){
//         //                 if(!err){
//         //                     var res_url = "";
//         //                     files.forEach(function(file){
//         //                         res_url = path.resolve(dirToScan,file);
//         //                         characters.push({"data":{"low":[],"high":[],"thumbnails":[]},"res_name":file,"res_url":res_url,"parent_folder_name":dirParent,time: fs.statSync(res_url).mtime.getTime()});
//         //                     });
//         //                     dirsProcessed++;
//         //                     if(dirsProcessed == dirsToScan.length){
//         //                         processCharacterDirs(characters);
//         //                     }
//         //                 }
//         //                 else{
//         //                     dirsProcessed++;
//         //                     if(dirsProcessed == dirsToScan.length){
//         //                         processCharacterDirs(characters);
//         //                     }
//         //                 }
//         //             });
//         //         });
//         //     }

//                 var processCharacterDirs = function(characters){
//                 var charactersProcessed = 0;
//                 var totalCount = Object.keys(characters).length;
//                 if(totalCount){
//                     characters.forEach(function(character,index) {
//                         var character_info = character;
//                         var character_dir = character_info['res_url'];
//                         character_thumbnail_dir = path.resolve(character_dir,"thumbnails");
//                         character_low_images_dir = path.resolve(character_dir,"images","low");
//                         character_high_images_dir = path.resolve(character_dir,"images","high");
//                         characters[index]['thumbnails_dir'] = character_thumbnail_dir;
//                         characters[index]['low_dir'] = character_low_images_dir;
//                         characters[index]['high_dir'] = character_high_images_dir;
//                         var character_name = character_info['res_name'];
//                         scanDir(character_thumbnail_dir,character_name,index,function(response){
//                             if(response && response.data && response.data.length  && characters[response.index]){
//                                 characters[response.index]['data']['thumbnails'] = response.data;
//                                 var thumbnails_array = {};//{0:response.data[0].file,1:response.data[1].file,2:response.data[2].file,3:response.data[3].file};
//                                // characters[response.index]['thumbnails_url'] = JSON.stringify(thumbnails_array);
//                                 if(characters[response.index]['res_order'])
//                                     characters[response.index]['res_order'] = Math.min(response.data.length,characters[response.index]['res_order']);
//                                 else
//                                     characters[response.index]['res_order'] = response.data.length;
//                             }
//                             else{
//                                 characters[response.index] = null;
//                             }
//                             charactersProcessed++;
//                             if(charactersProcessed === 3*totalCount){
//                                 processResult(characters);
//                             }
//                         });

//                         scanDir(character_low_images_dir,character_name,index,function(response){
//                             if(response && response.data && response.data.length && characters[response.index]){
//                                 characters[response.index]['data']['low'] = response.data;
//                                 if(characters[response.index]['res_order'])
//                                     characters[response.index]['res_order'] = Math.min(response.data.length,characters[response.index]['res_order']);
//                                 else
//                                     characters[response.index]['res_order'] = response.data.length;
//                             }
//                             else{
//                                 characters[response.index] = null;
//                             }
//                             charactersProcessed++;
//                             if(charactersProcessed === 3*totalCount){
//                                 processResult(characters);
//                             }
//                         });

//                         scanDir(character_high_images_dir,character_name,index,function(response){
//                             if(response && response.data && response.data.length  && characters[response.index]){
//                                 characters[response.index]['data']['high'] = response.data;
//                                 if(characters[response.index]['res_order'])
//                                     characters[response.index]['res_order'] = Math.min(response.data.length,characters[response.index]['res_order']);
//                                 else
//                                     characters[response.index]['res_order'] = response.data.length;
//                             }
//                             else{
//                                 characters[response.index] = null;
//                             }
//                             charactersProcessed++;
//                             if(charactersProcessed === 3*totalCount){
//                                 processResult(characters);
//                             }
//                         });
//                     });
//                 }
//                 else{
//                     processResult(characters);
//                 }
//             }

//             var scanDir = function(dir,character,index,callback){
//                 fs.readdir(dir, function(err, files){
//                     if(!err){
//                         var filesWithInfo = [];
//                         var res_url="";
//                         files.forEach(function(file){
//                             res_url = path.resolve(dir,file);
//                             filesWithInfo.push({"file":file,"time": fs.statSync(res_url).mtime.getTime()});
//                         });
//                         filesWithInfo = filesWithInfo.sort(function (a, b) {
//                             if(sortby == "recent")
//                                 return b.time - a.time;
//                             else if(sortby == "name")
//                                 return a.file.localeCompare(b.file);
//                             else
//                                 return a.file.localeCompare(b.file);
//                          })
//                         callback({error:false,name:character,data:filesWithInfo,index:index});
//                     }
//                     else
//                         callback({error:true,name:character,data:[],index:index});
//                   });
//             }

//             var processResult = function(characters){
//                 res.send({error:false,data:characters});
//             }

//             var characters = [];
//             var dirToScan = path.resolve(cpCharacterDirectoryPath,"Assets");
//             var res_url = path.resolve(dirToScan,"Assets");
//             var dirParent = "Assets";
//             var resName = "Assets";
//             if (fs.existsSync(res_url))
//                 characters.push({"data":{"low":[],"high":[],"thumbnails":[]},"res_name":resName,"res_url":res_url,"parent_folder_name":dirParent,time: fs.statSync(res_url).mtime.getTime()});
//             processCharacterDirs(characters);

//           //});
//     }
//     else if(type == "images"){
//         dir = cpStockDirectoryPath;
//         if(dir != undefined && dir != ""){
//             fs.readdir(dir, function(err, files){
//                 if(!err){
//                 files = files.filter(function(fileName){
//                     var fileDetails = fileName.split('.');
//                     var fileExtension = "";
//                     var fileBaseName = "";
//                     if(fileDetails.length==2){
//                         fileBaseName = fileDetails[0];
//                         fileExtension = fileDetails[1];
//                     }
//                     if(fileExtension == "jpg" || fileExtension == "jpeg" || fileExtension == "png"|| fileExtension == "svg"){
//                         var thumbnailPath = path.join(dir,"/thumbnails/",fileBaseName+".png");
//                         if (fs.existsSync(thumbnailPath)) {
//                             return fileName;
//                         }

//                     }
//                   })
//                   .map(function (fileName) {
//                     var fileDetails = fileName.split('.');
//                     var currentPath = path.resolve(dir,fileName);
//                     return {
//                       res_name:fileName,
//                       asset_file_name: fileName,
//                       res_url: currentPath,
//                       thumbnail_file_name:fileDetails[0]+".png",
//                       thumbnails_url:path.join("thumbnails/",fileDetails[0]+".png"),
//                       time: fs.statSync(currentPath).mtime.getTime()
//                     };
//                   })
//                  .sort(function (a, b) {
//                     if(sortby == "recent")
//                         return b.time - a.time;
//                     else if(sortby == "name")
//                         return a.res_name.localeCompare(b.res_name);
//                     else
//                         return a.res_name.localeCompare(b.res_name);
//                  })
//                 .map(function (v) {
//                   return v });
//                 res.send({error:false,data:files});
//                 }
//                 else{
//                     res.send({error:true,data:[]});
//                 }
//               });
//         }
//         else{
//             res.send({error:true,data:[]});
//         }
//     }
//     else if(type == "videos"){
//         dir = cpStockDirectoryPath;
//         if(dir != undefined && dir != ""){
//             fs.readdir(dir, function(err, files){
//                 if(!err){
//                 files = files.filter(function(fileName){
//                     var fileDetails = fileName.split('.');
//                     var fileExtension = "";
//                     var fileBaseName = "";
//                     if(fileDetails.length==2){
//                         fileBaseName = fileDetails[0];
//                         fileExtension = fileDetails[1];
//                     }
//                     if(fileExtension == "avi" || fileExtension == "mp4" || fileExtension == "flv"|| fileExtension == "3gp"|| fileExtension == "wmv"|| fileExtension == "mov"){
//                         var thumbnailPath = path.join(dir,"/thumbnails/",fileName+".png");
//                         if (fs.existsSync(thumbnailPath)) {
//                             return fileName;
//                         }

//                     }
//                   })
//                   .map(function (fileName) {
//                     var fileDetails = fileName.split('.');
//                     var currentPath = path.resolve(dir,fileName);
//                     return {
//                       res_name:fileName,
//                       asset_file_name: fileName,
//                       res_url: currentPath,
//                       thumbnail_file_name:fileDetails[0]+".png",
//                       thumbnails_url:path.join("thumbnails/",fileName+".png"),
//                       time: fs.statSync(currentPath).mtime.getTime()
//                     };
//                   })
//                  .sort(function (a, b) {
//                     if(sortby == "recent")
//                         return b.time - a.time;
//                     else if(sortby == "name")
//                         return a.res_name.localeCompare(b.res_name);
//                     else
//                         return a.res_name.localeCompare(b.res_name);
//                     })
//                 .map(function (v) {
//                   return v });
//                 res.send({error:false,data:files});
//                 }
//                 else{
//                     res.send({error:true,data:[]});
//                 }
//               });
//         }
//         else{
//             res.send({error:true,data:[]})
//         }
//     }
//     else{
//         res.send({error:true,data:[]})
//     }
// });

// app.get('/getCharacterPreview', function(req, res){

// 	var json = req.query;
// 	var path = Object.keys(json);
// 	var srcPath = path[0];
// 	var bitmap = fs.readFileSync(srcPath);
//     // convert binary data to base64 encoded string
//     var base64data = new Buffer(bitmap).toString('base64');
// 	res.send(base64data);
// });

// var unique = function(a) {
//     if(a == undefined)
//         return [];
//     for(var i=0; i<a.length; ++i) {
//         if(a[i]== null){
//             a.splice(i--, 1);
//             continue;
//         }
//         for(var j=i+1; j<a.length; ++j) {
//             if(a[j]== null || a[i].id === a[j].id)
//                 a.splice(j--, 1);
//         }
//     }
//     return a;
// };

// app.post('/offline', function(req, res){
//    var params = req.body;
//     var dir = cpContentDirectoryPath;
//     var info_file = "";
//     if(params.asset_type == "1"){
//         info_file = path.join(dir,"Templates","info.json");
//     }
//     else if(params.asset_type == "2"){
//         info_file = path.join(dir,"Slides","info.json");
//     }
//     else if(params.asset_type == "2"){
//         info_file = path.join(dir,"Slides","info.json");
//     }
//     else if(params.asset_type == "3"){
//         info_file = path.join(dir,"Characters","info.json");
//     }
//     else if(params.asset_type == "4"){
//         info_file = path.join(dir,"Poses","info.json");
//     }
//     else if(params.asset_type == "5"){
//         info_file = path.join(dir,"Videos","info.json");
//     }
//     else if(params.asset_type == "6"){
//         info_file = path.join(dir,"Images","info.json");
//     }
//     else if(params.asset_type == "7"){
//         info_file = path.join(dir,"Icons","info.json");
//     }
//     else if(params.asset_type == "8"){
//         info_file = path.join(dir,"Buttons","info.json");
//     }
//     else if(params.asset_type == "9"){
//         info_file = path.join(dir,"360Images","info.json");
//     }
//     else if(params.asset_type == "10"){
//         info_file = path.join(dir,"Games","info.json");
//     }
//     else if(params.asset_type == "11"){
//         info_file = path.join(dir,"Themes","info.json");
//     }
//     else if(params.asset_type == "12"){
//         info_file = path.join(dir,"Audios","info.json");
//     }
//     var result = {};
//     if(info_file != undefined && info_file != ""){
//         fs.readFile(info_file, "utf8", function read(err, data) {
//             if(!err){
//                 if(IsJsonString(data)){
//                     var content = JSON.parse(data);
//                     var data = content.content;
//                     var search = new JsSearch.Search('id');;
//                     search.addIndex('input_tags');
//                     search.addIndex('res_parent_id');
//                     search.addDocuments(data);
//                     var project_type = params.asset_project_type?params.asset_project_type:"";
//                     var parent_id = params.asset_parent_id? params.asset_parent_id:0;
//                     var asset_industry = params.asset_industry?params.asset_industry:'all';
//                     var asset_course = params.asset_course_type?params.asset_course_type:"all";
//                     var asset_style = params.asset_style?params.asset_style:"all";
//                     var asset_gender = params.asset_gender?params.asset_gender:"all";
//                     var search_word = params.search_key?params.search_key:"";
//                     var asset_filters = (params.filters&&params.filters.length)?params.filters:[];
//                     var initialSearchWord = "";
//                     if(project_type && project_type!=""){
//                         if(initialSearchWord == "")
//                             initialSearchWord = project_type;
//                         else
//                             initialSearchWord = initialSearchWord + "|" +project_type;
//                     }
//                     if(parent_id && parent_id!=0){
//                         if(initialSearchWord == "")
//                             initialSearchWord = parent_id;
//                         else
//                             initialSearchWord = initialSearchWord + "|" +parent_id;
//                     }

//                     if(asset_industry && asset_industry!="" && asset_industry!="all"){
//                         if(initialSearchWord == "")
//                             initialSearchWord = asset_industry;
//                         else
//                             initialSearchWord = initialSearchWord + "|" +asset_industry;
//                     }

//                     if(asset_course && asset_course!="" && asset_course!="all"){
//                         if(initialSearchWord == "")
//                             initialSearchWord = asset_course;
//                         else
//                             initialSearchWord = initialSearchWord + "|" +asset_course;
//                     }

//                     if(asset_style && asset_style!="" && asset_style!="all"){
//                         if(initialSearchWord == "")
//                             initialSearchWord = asset_style;
//                         else
//                             initialSearchWord = initialSearchWord + "|" +asset_style;
//                     }

//                     if(asset_gender && asset_gender!="" && asset_gender!="all"){
//                         if(initialSearchWord == "")
//                             initialSearchWord = asset_gender;
//                         else
//                             initialSearchWord = initialSearchWord + "|" +asset_gender;
//                     }
//                     if(initialSearchWord && initialSearchWord!="")
//                         data = search.search(initialSearchWord);
//                     // search = new JsSearch.Search('id');;
//                     // search.addIndex('res_parent_id');
//                     // search.addDocuments(data);
//                     // if(parent_id)
//                     //     data = search.search(parent_id);
//                     if(search_word && search_word != ""){
//                         search = new JsSearch.Search('id');;
//                         search.addIndex('res_name');
//                         search.addIndex('res_description');
//                         search.addIndex('input_tags');
//                         search.addDocuments(data);
//                         data = search.search(search_word);
//                     }
//                     if(asset_filters.length){
//                         var filterResults = [];
//                         var currentResult = [];
//                         search = new JsSearch.Search('id');
//                         search.addIndex('input_tags');
//                         search.addDocuments(data);
//                         for(var i=0;i<asset_filters.length;i++){
//                             currentResult = search.search(asset_filters[i]);
//                             filterResults = filterResults.concat(currentResult);
//                         }
//                         data = unique(filterResults);
//                     }
//                     result['content'] = data.length?data:[];
//                     result['hits'] = data.length?data.length:0;
//                     res.send(result);
//                 }
//                 else{
//                     result['content'] = [];
//                     result['hits'] = 0;
//                     res.send(result);
//                 }
//             }
//             else{
//                 result['content'] = [];
//                 result['hits'] = 0;
//                 res.send(result);
//             }
//         });
//     }
//     else{
//         result['content'] = [];
//         result['hits'] = 0;
//         res.send(result);
//     }
// });

// app.get('/video', function(req, res) {
//     // const path = 'assets/sample.mp4'
//     let path = cpTempDirectoryPath + "/VideoCache/" + req.query.path;
//     if (path == undefined || path == "undefined" || path == "") {
//         path = defaultVideoSourcePath;
//     }
//     const stat = fs.statSync(path)
//     const fileSize = stat.size
//     const range = req.headers.range
//     if (range) {
//         const parts = range.replace(/bytes=/, "").split("-")
//         const start = parseInt(parts[0], 10)
//         const end = parts[1] ?
//             parseInt(parts[1], 10) :
//             fileSize - 1
//         const chunksize = (end - start) + 1
//         const file = fs.createReadStream(path, {
//             start,
//             end
//         })
//         const head = {
//             'Content-Range': `bytes ${start}-${end}/${fileSize}`,
//             'Accept-Ranges': 'bytes',
//             'Content-Length': chunksize,
//             'Content-Type': 'video/mp4',
//         }
//         res.writeHead(206, head);
//         file.pipe(res);
//     } else {
//         const head = {
//             'Content-Length': fileSize,
//             'Content-Type': 'video/mp4',
//         }
//         res.writeHead(200, head)
//         fs.createReadStream(path).pipe(res)
//     }
// });
// var IsJsonString = function(str) {
//     try {
//         JSON.parse(str);
//     } catch (e) {
//         return false;
//     }
//     return true;
// }
// var restream = function(proxyReq, req, res, options) {
//     if (req.body) {
//         let bodyData = JSON.stringify(req.body);
//         proxyReq.setHeader('Content-Type','application/json');
//         proxyReq.setHeader('Content-Length', Buffer.byteLength(bodyData));
//         proxyReq.write(bodyData);
//     }
// }

// var customRouter = function(req) {
//     if(req.body && req.body.isoffline && req.body.isoffline == 'true'){
//         console.log("offline... navigating to localhost " + freep);
//         return "http://localhost:"+freep+"/offline";
//     }
//     else{
//         return ELEARNING_HOME;
//     }
//   };

// //Change "secure" option to false in dev environment
// app.use(proxy('/elearningproxy', { target: ELEARNING_HOME, changeOrigin: true, secure:true, onProxyReq: restream,
//     pathRewrite:
//         function(path,req) {
//             if(req.body && req.body.isoffline && req.body.isoffline == 'true'){
//                 return "";
//             }
//             else
//                 return path.replace('/elearningproxy','');
//         },router:customRouter
// }));

// //Change "secure" option to false in dev environment
// app.use(proxy('/elearningproxy', { target: ELEARNING_HOME, changeOrigin: true, secure:true, onProxyReq: restream,
//     pathRewrite:
//         function(path,req) {
//             return path.replace('/elearningproxy','');
//         }
// }));

//Uncomment the below code and comment the above to test from browser
// app.listen(8000, function () {
//  });
