const path = require("path");
const webpack = require("webpack");

module.exports = {
  entry: "./src/server.js",
  target: "node",
  externals: [
    // Exclude @dcx modules from bundling - they will be provided by node_modules
    {
      '@dcx/dcx-js': 'commonjs @dcx/dcx-js',
      '@dcx/repo-api-session': 'commonjs @dcx/repo-api-session',
      '@dcx/assets': 'commonjs @dcx/assets',
      '@dcx/http': 'commonjs @dcx/http'
    }
  ],
  plugins: [
    new webpack.ProvidePlugin({
      __awaiter: ["tslib", "__awaiter"],
    }),
    new webpack.IgnorePlugin({
      // Ignore optional native dependencies that cause warnings
      resourceRegExp: /^(utf-8-validate|bufferutil|canvas|fsevents)$/
    }),
  ],
  module: {
    rules: [],
  },
  resolve: {
    extensions: [".js"],
    fallback: {
      // Handle optional native dependencies
      "utf-8-validate": false,
      "bufferutil": false,
      "canvas": false,
      "fsevents": false
    }
  },
  output: {
    filename: "server.js",
    path: path.resolve(__dirname, "../ns"),
  },
  node: {
    __dirname: false,
    __filename: false,
  },
};