/*************************************************************************************
*
* ADOBE CONFIDENTIAL
* __________________
*
* Copyright 1986 - 2010 Adobe Systems Incorporated
* All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains the property
* of Adobe Systems Incorporated and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe Systems
* Incorporated and its suppliers and may be covered by U.S. and Foreign
* Patents, patents in process, and are protected by trade secret or
* copyright law. Dissemination of this information or reproduction of this
* material is strictly forbidden unless prior written permission is
* obtained from Adobe Systems Incorporated.
*************************************************************************************/

/*************************************************************************************
    * File Name      :     fcmsapi.h
    *
    * Purpose        :     List of CMS APIs and Data types.
    *
    * Author         :     Ankur, Prakash
    *
    * Date           :     10th Feb 2011
    *
    * Comments       :     None
(************************************************************************************/

#ifndef FCMSAPI_H
#define FCMSAPI_H

/************************************************************************************/
/* CMS Data types - start */
/************************************************************************************/

#ifndef F_CMSOpResultT_DEFINED
# define F_CMSOpResultT_DEFINED

typedef enum {
    FV_CMSOpNone = 00,
    FV_CMSOpItemUpdated = 02,
    FV_CMSOpDependentsUpdated = 04,
    FV_CMSOpDependentsDeleted = 010,
    FV_CMSOpItemDeleted = 020,
    FV_CMSOpChildAdded = 040,
    FV_CMSOpRootUpdated = 0100,
	FV_CMSOpDocumentOpened = 0200
} F_CMSOpResultT;

#endif /* F_CMSOpResultT_DEFINED */


#ifndef F_CMSResultT_DEFINED
# define F_CMSResultT_DEFINED

typedef struct F_CMSResultT
{
    StatusT 		status;
    UIntT 			opResult;/* Operation's result. If CMSCommand needs CMSTree update, assign F_CMSOpResultT values,
							  * else can return any value depending on operation. e.g. opResult = True/False for FA_CMSIsValidCommand;
							  * opResult = CMSPropertyNewMaxOpCode; for FA_CMSGetPropertyMaxOpCode. etc. */
	StringT 		message; /* If operation fails, user can send error message to FrameMaker.
							  * For FA_CMSObjectOpenReadOnly, FA_CMSObjectEdit command, user can return file-name which is downloaded. */
	F_ObjHandlesT 	cmsItems;
} F_CMSResultT;

#endif /* F_CMSResultT_DEFINED */

#ifndef F_CMSItemPropertyT_DEFINED
# define F_CMSItemPropertyT_DEFINED

/* Note: User can add custom properties after F_CMSItemProperty_Max.
 * (F_CMSItemProperty_Min to F_CMSItemProperty_Max is used for internal purpose only.)
 * Also, custom property will be internally stored as string(s). */
typedef enum {
    FP_CMSItemProperty_Min = 00,
    FP_CMSItemProperty_ItemName = 01,
    FP_CMSItemProperty_ItemServerPath = 02,
    FP_CMSItemProperty_ItemLocalPath = 03,
    FP_CMSItemProperty_ItemIsCheckedOut = 04,
    FP_CMSItemProperty_ItemCheckedOutByCurrentUser = 05,
    FP_CMSItemProperty_ItemIsContainer = 06,
    FP_CMSItemProperty_ItemType = 07,
    FP_CMSItemProperty_ItemFileType = 010,
    FP_CMSItemProperty_ItemVersion = 011,
    FP_CMSItemProperty_Max = 0100
} F_CMSItemPropertyT;

#endif /* F_CMSItemPropertyT_DEFINED */


#ifndef F_CMSItemTypeValueT_DEFINED
# define F_CMSItemTypeValueT_DEFINED

typedef enum {
    FV_CMSItemTypeValue_Min = 00,
    FV_CMSItemTypeValue_Root = 01,
    FV_CMSItemTypeValue_Folder = 02,
    FV_CMSItemTypeValue_File = 03,
    FV_CMSItemTypeValue_General = 04,
    FV_CMSItemTypeValue_Max = 05
} F_CMSItemTypeValueT;

#endif /* F_CMSItemTypeValueT_DEFINED */

#ifndef F_CMSItemFileTypeValueT_DEFINED
# define F_CMSItemFileTypeValueT_DEFINED

typedef enum {
    FV_CMSItemFileTypeValue_Min = 00,
    FV_CMSItemFileTypeValue_Xml = 01,
    FV_CMSItemFileTypeValue_FmDoc = 02,
    FV_CMSItemFileTypeValue_Mif = 03,
    FV_CMSItemFileTypeValue_DitaMap = 04,
    FV_CMSItemFileTypeValue_DitaTopic = 05,
    FV_CMSItemFileTypeValue_FmBook = 06,
    FV_CMSItemFileTypeValue_Text = 07,
    FV_CMSItemFileTypeValue_Img = 010,
    FV_CMSItemFileTypeValue_General = 011,
    FV_CMSItemFileTypeValue_Max = 012
} F_CMSItemFileTypeValueT;

#endif /* F_CMSItemFileTypeValueT_DEFINED */


#ifndef F_CMSPropertyT_DEFINED
# define F_CMSPropertyT_DEFINED

typedef struct F_CMSPropertyT
{
	UIntT 			prop; /* Property Id value of enum F_CMSItemPropertyT or custom property added by user */
    StringT 		label;
    BoolT 			isMultiValue;
    BoolT 			isEditable;
    F_TypedValsT 	*values;
} F_CMSPropertyT;

#endif /* F_CMSPropertyT_DEFINED */


#ifndef F_CMSPropertiesT_DEFINED
# define F_CMSPropertiesT_DEFINED

typedef struct F_CMSPropertiesT
{
	IntT 			len;
	F_CMSPropertyT	*val;
} F_CMSPropertiesT;

#endif /* F_CMSPropertiesT_DEFINED */


#ifndef F_CMSCommandsT_DEFINED
# define F_CMSCommandsT_DEFINED

/*
 * Note:
 *		FA_CMSObjectDownload - User will get this command from Import dialog.
 *		FA_CMSObjectDownloadItem - If file is checked out by current user, user will get this command from Open dialog.
 *		FA_CMSObjectDownloadForOpen - If file is checked out by other user or not in checked-out state ,
 *									user will get this command from Open dialog.
 */

typedef enum {
    FA_CMSCommandMin = 00,
    FA_CMSCreateConnection = 01,
    FA_CMSSetRootObject = 02,
    FA_CMSCreateConnMgrUI = 03,
    FA_CMSGetItemFromPath = 04,
    FA_CMSCloseConnection = 05,
    FA_CMSGetCommandMaxOpCode = 06,
    FA_CMSGetPropertyMaxOpCode = 07,
    FA_CMSObjectCheckout = 010,
    FA_CMSObjectCheckin = 011,
    FA_CMSObjectCancelCheckout = 012,
    FA_CMSObjectEdit = 013,
    FA_CMSObjectOpenReadOnly = 014,
    FA_CMSObjectDelete = 015,
    FA_CMSObjectShowVersion = 016,
    FA_CMSObjectShowDependents = 017,
    FA_CMSObjectShowProperties = 020,
    FA_CMSObjectShowCheckOutFiles = 021,
    FA_CMSObjectDownload = 022,
    FA_CMSObjectDownloadItem = 023,
    FA_CMSObjectDownloadForOpen = 024,
    FA_CMSObjectUploadFile = 025,
    FA_CMSObjectUploadFolder = 026,
    FA_CMSObjectGetChildren = 027,
    FA_CMSObjectIsSame = 030,
    FA_CMSObjectRefresh = 031,
    FA_CMSSimpleSearch = 032,
    FA_CMSAdvancedSearch = 033,
    FA_CMSGetItems = 034,
    FA_CMSBuildContextMenu = 035,
    FA_CMSIsValidCommand = 036,
    FA_CMSReview = 037,
    FA_CMSGetVersionLabels = 040,
    FA_CMSCommandMax = 0100
} F_CMSCommandsT;

#endif /* F_CMSCommandsT_DEFINED */

#ifndef F_CMSMenuTypeT_DEFINED
# define F_CMSMenuTypeT_DEFINED

typedef enum {
    FV_CMSMenu_Min = 00,
    FV_CMSMenu_Is_Item = 01,
    FV_CMSMenu_Is_Disabled = 02,
    FV_CMSMenu_Is_Separator = 04,
    FV_CMSMenu_Is_SubMenu = 010,
    FV_CMSMenu_Max = 020
} F_CMSMenuTypeT;

#endif /* F_CMSMenuTypeT_DEFINED */


#ifndef F_CMSMenuItemT_DEFINED
# define F_CMSMenuItemT_DEFINED

typedef struct F_CMSMenuItemT
{
    IntT 			id;
    StringT 		name;
    UIntT			flags; /* Use values of enum F_CMSMenuTypeT */
}F_CMSMenuItemT;

#endif /* F_CMSMenuItemT_DEFINED */


#ifndef F_CMSVersioningStrategyT_DEFINED
# define F_CMSVersioningStrategyT_DEFINED

typedef enum {
    FV_CMSVersion_Min = 00,
    FV_CMSSameVersion = 01,
    FV_CMSMinorVersion = 02,
    FV_CMSMajorVersion = 03,
    FV_CMSVersion_Max = 04
} F_CMSVersioningStrategyT;

#endif /* F_CMSVersioningStrategyT_DEFINED */


#ifndef F_CMSCheckinParamT_DEFINED
# define F_CMSCheckinParamT_DEFINED

typedef struct F_CMSCheckinParamT
{
    UIntT						version; /* Use values of enum F_CMSVersioningStrategyT */
    StringT 					versionLabel;
    StringT 					description;
    StringT 					checkinComment;
    BoolT 						makeThisCurrentVersion;
} F_CMSCheckinParamT;

#endif /* F_CMSCheckinParamT_DEFINED */


#ifndef F_CMSCustomizeCheckoutUI_DEFINED
# define F_CMSCustomizeCheckoutUI_DEFINED

typedef enum {
    FV_CMSCheckoutUI_Id_ShowDependents = 01
} F_CMSCustomizeCheckoutUI;

#endif /* F_CMSCustomizeCheckoutUI_DEFINED */


#ifndef F_CMSCustomizeCheckinUI_DEFINED
# define F_CMSCustomizeCheckinUI_DEFINED

typedef enum {
    FV_CMSCheckinUI_Id_SameVersion = 01,
    FV_CMSCheckinUI_Id_MinorVersion = 02,
    FV_CMSCheckinUI_Id_MajorVersion = 04,
    FV_CMSCheckinUI_Id_VersionLabel = 010,
    FV_CMSCheckinUI_Id_Description = 020,
    FV_CMSCheckinUI_Id_CheckinComment = 040,
    FV_CMSCheckinUI_Id_MakeThisCurrentVersion = 0100
} F_CMSCustomizeCheckinUI;

#endif /* F_CMSCustomizeCheckinUI_DEFINED */


#ifndef F_CMSCustomizeDeleteUI_DEFINED
# define F_CMSCustomizeDeleteUI_DEFINED

typedef enum {
    FV_CMSDeleteUI_DeleteAllVersion = 01,
    FV_CMSDeleteUI_DeleteAllDependents = 02
} F_CMSCustomizeDeleteUI;

#endif /* F_CMSCustomizeDeleteUI_DEFINED */


#ifndef F_CMSDeleteParamT_DEFINED
# define F_CMSDeleteParamT_DEFINED

typedef struct F_CMSDeleteParamT
{
    BoolT 	deleteAllVersion;
    BoolT 	deleteAllDependents;
} F_CMSDeleteParamT;

#endif /* F_CMSDeleteParamT_DEFINED */


#ifndef F_CMSCommandArgsIdT_DEFINED
# define F_CMSCommandArgsIdT_DEFINED

/*
 * Note: For automation API: For writing Delete UI functionality, Documentum client can use
 * 		FV_CMSCommandDeleteAllVersionId (value = True/False) and FV_CMSCommandDeleteAllDependentsId (value = True/False) arguments,
 * 	whereas Sharepoint client can use FV_CMSCommandDeleteAllVersionId (value = True - Delete file, False - Delete all version except last) argument.
 */

typedef enum {
    FV_CMSCommandId_Min = 00,
    FV_CMSCommandNameId = 01,
    FV_CMSCommandConnTypeId = 02,
    FV_CMSCommandServerId = 03,
    FV_CMSCommandUserNameId = 04,
    FV_CMSCommandPasswordId = 05,
    FV_CMSCommandUserField1 = 06,
    FV_CMSCommandRepositoryId = 06,
    FV_CMSCommandUserField2 = 07,
    FV_CMSCommandFilePathId = 010,
    FV_CMSCommandSearchStringId = 011,
    FV_CMSCommandAdvancedSearchStringId = 012,
    FV_CMSCommandId = 013,
    FV_CMSContextMenuId = 014,
    FV_CMSContextMenuString = 015,
    FV_CMSSilentOperation = 016,
    FV_CMSCommandCheckoutWithDescendentId = 017,
    FV_CMSCommandCheckinMakeCurrentVersionId = 020,
    FV_CMSCommandCheckinKeepLocalCopyId = 021,
    FV_CMSCommandCheckinMinorVersionId = 022,
    FV_CMSCommandCheckinVersionLabelId = 023,
    FV_CMSCommandCheckinDescriptionId = 024,
    FV_CMSCommandCheckinCommentId = 025,
    FV_CMSCommandDeleteAllVersionId = 026,
    FV_CMSCommandDeleteAllDependentsId = 027,
    FV_CMSCommandOpenReadOnlyId = 030,
    FV_CMSCommandSilentOpenId = 031,
    FV_CMSCommandRefreshDependentsId = 032,
    FV_CMSCommandIsAEMSSO = 033,
	FV_CMSCommandUseUUID = 034,
    FV_CMSCommandId_Max = 035
} F_CMSCommandArgsIdT;

#endif /* F_CMSCommandArgsIdT_DEFINED */


#ifndef F_CMSUserFieldTypeT_DEFINED

typedef enum {
	FV_CMSUserFieldType_Edit = 0,
	FV_CMSUserFieldType_FileBrowse = 1,
	FV_CMSUserFieldType_FolderBrowse = 2
}F_CMSUserFieldTypeT;

#endif /* F_CMSUserFieldTypeT_DEFINED */

#ifndef F_CMSInfoT_DEFINED
# define F_CMSInfoT_DEFINED

typedef struct F_CMSInfoT
{
	StringT cmsName;
    F_StringsT userFields;
    BoolT userLoginUi;
} F_CMSInfoT;

#endif /* F_CMSInfoT_DEFINED */


#ifndef F_CMSInfosT_DEFINED
# define F_CMSInfosT_DEFINED

typedef struct F_CMSInfosT
{
	IntT len;
	F_CMSInfoT *val;
} F_CMSInfosT;

#endif /* F_CMSInfosT_DEFINED */

/************************************************************************************/
/* CMS Data types - end */
/************************************************************************************/


/************************************************************************************/
/* CMS - API Error Handling. - start */
/************************************************************************************/
/* Note: The Error codes from -112 to -176 (64 in total) are reserved for CMS APIs. */
#define FE_CMSNameAlreadyRegistered		-112	/* F_ApiRegisterCMS will return this status if cms name is already registered. */
#define FE_CMSBadSessionId				-113	/* APIs which works on as Session can return this error if Session Id does not exists. */
#define FE_CMSBadObjectId				-114	/* APIs which needs to set attribute, children etc for an object, will return this error status. */
#define FE_CMSSessionFailed				-115	/* If session failed due to some reason, then all APIs can return this status. */
#define FE_CMSBadCommandId				-116	/* APIs which needs to set attribute, children etc for an object, will return this error status. */
#define FE_CMSObjectCreationFailed		-117	/* F_ApiCMSCreateObject will return this status if cms object creation fails. */
#define FE_CMSRootObjectExists			-118	/* If root already exists and user wants to set root, return this error. */
#define FE_CMSBadItemFileType			-119	/* Bad Item File Type. */
#define FE_CMSBadItemType				-120	/* Bad Item Type. */
#define FE_CMSBadItemContainerType		-121	/* Item's container value is not properly set. */
#define FE_CMSSessionCreationFailed		-122	/* Session creation failed. */
#define FE_CMSIsValidCMSCommand			-123	/* If User wants FM to take care of IsValidCMSCommand, he/she can set opResult to this value. */
/************************************************************************************/
/* CMS - API Error Handling - end. */
/************************************************************************************/

/************************************************************************************/
/* CMS Automation API Error Handling - start. */
/************************************************************************************/
#define FE_CMSFailedLogin				-150
#define FE_CMSFailedCheckout			-151
#define	FE_CMSFailedCheckin				-152
#define	FE_CMSFailedCancelCheckout		-153
#define FE_CMSFailedDelete				-154
#define FE_CMSFailedOpenFile			-155
#define	FE_CMSFailedUploadObject		-156
#define	FE_CMSFailedDownloadObject		-157
#define	FE_CMSFailedGetItemFrompath		-158
#define FE_CMSFailedLogout				-159
/************************************************************************************/
/* CMS Automation API Error Handling - end. */
/************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

extern F_CMSInfosT 			F_ApiAllocateCMSInfos 		(IntT numCMSInfos);
extern VoidT 				F_ApiDeallocateCMSInfos 	(F_CMSInfosT *cmsInfop);

extern F_CMSPropertiesT 	F_ApiAllocateCMSProperties 	(IntT numCMSProperties);
extern VoidT 				F_ApiDeallocateCMSProperties (F_CMSPropertiesT *cmsPropertiesp);

/************************************************************************************/
/* CMS Callback - start */
/************************************************************************************/

extern VoidT 				F_ApiCMSCommand 		(F_ObjHandleT cmsSessionId,
														const F_ObjHandlesT *objectIds,
														IntT command,
														const F_IdValuePairsT *arguments,
														F_CMSResultT *statusp);

/************************************************************************************/
/* CMS Callback - end */
/************************************************************************************/


/************************************************************************************/
/* CMS API - start */
/************************************************************************************/

extern F_ObjHandleT 		F_ApiCMSRegister 		(ConStringT cmsName);

extern F_ObjHandleT 		F_ApiCMSCreateObject 	(F_ObjHandleT cmsSessionId);

extern VoidT 				F_ApiCMSEnableCommand 	(F_ObjHandleT cmsSessionId,
														F_ObjHandleT objectId,
														UIntT commandId);

extern VoidT 				F_ApiCMSDisableCommand 	(F_ObjHandleT cmsSessionId,
														F_ObjHandleT objectId,
														UIntT commandId);

extern F_ObjHandleT	 		F_ApiCMSAddMenuEntry 	(F_ObjHandleT menuId,
														const F_CMSMenuItemT *menuEntryp);

extern F_ObjHandleT			F_ApiCMSGetCmsIdFromName (ConStringT cmsName);

extern F_CMSInfoT			F_ApiCMSGetCMSInfo		(F_ObjHandleT cmsId);

extern F_ObjHandleT			F_ApiCMSGetCmsIdFromSession	(F_ObjHandleT cmsSessionId);

extern F_CMSInfosT			F_ApiCMSGetCmsInfoList ();

/************************************************************************************/
/* Various CMS UI related APIs - start */
/************************************************************************************/
extern VoidT 				F_ApiCMSConfigLoginUI 	(F_ObjHandleT cmsId,
														const F_StringsT *userFields,
														BoolT userLoginUI);

extern VoidT 				F_ApiCMSConfigLoginUIEx 	(F_ObjHandleT cmsId,
														const F_TypedValsT *userFieldsConfigp,
														BoolT userLoginUI);

extern VoidT 				F_ApiCMSShowSearchUI		(F_ObjHandleT cmsSessionId,
														F_ObjHandleT objectId, 
														const F_TypedValsT *searchParams);

extern BoolT 				F_ApiCMSShowCheckoutUI	(F_ObjHandleT sessionId,
														F_ObjHandleT objectId,
														UIntT hideUiItems);

extern F_CMSCheckinParamT	 F_ApiCMSShowCheckinUI	(F_ObjHandleT sessionId,
														F_ObjHandleT objectId,
														UIntT hideUiItems);

extern VoidT 				F_ApiCMSShowCancelCheckoutUI (F_ObjHandleT sessionId,
														F_ObjHandleT objectId);

extern F_CMSDeleteParamT 	F_ApiCMSShowDeleteUI 	(F_ObjHandleT cmsSessionId,
														F_ObjHandleT objectId,
														UIntT hideUiItems);

extern BoolT 				F_ApiCMSShowCommonListUI (F_ObjHandleT cmsSessionId,
														F_ObjHandleT objectId,
														UIntT commandId,
														ConStringT title,
														const F_TypedValsT *columnProperties);

extern F_CMSPropertiesT 	F_ApiCMSShowPropertyUI	(F_ObjHandleT cmsSessionId,
														F_ObjHandleT objectId,
														const F_CMSPropertiesT *props);

extern F_ObjHandleT			F_ApiCMSShowBrowseRepositoryUI	(F_ObjHandleT cmsSessionId,
																BoolT showContainerOnly);

extern F_CMSPropertiesT 	F_ApiCMSShowPropertyUIWithTitle	(F_ObjHandleT cmsSessionId,
															F_ObjHandleT objectId,
															const F_CMSPropertiesT *props,
															ConStringT title);
/************************************************************************************/
/* Various CMS UI related APIs - end */
/************************************************************************************/

/************************************************************************************/
/* Property Set/Get API - start */
/************************************************************************************/
extern F_PropValsT 			F_ApiCMSGetProperties 	(F_ObjHandleT cmsSessionId,
														F_ObjHandleT objectId);

extern F_PropValT 			F_ApiCMSGetProperty 	(F_ObjHandleT cmsSessionId,
														F_ObjHandleT objectId,
														const F_PropIdentT *propertyId);

extern VoidT 				F_ApiCMSSetProperties (F_ObjHandleT cmsSessionId,
														F_ObjHandleT objectId,
														const F_PropValsT *propVals);

extern VoidT 				F_ApiCMSSetProperty 	(F_ObjHandleT cmsSessionId,
														F_ObjHandleT objectId,
														const F_PropValT *propVal);
/************************************************************************************/
/* Property Set/Get API - end */
/************************************************************************************/

/************************************************************************************/
/* CMS Automation related APIs - start */
/************************************************************************************/
extern F_ObjHandleT			F_ApiCMSLogin	(const F_IdValuePairsT *setVal);

extern StatusT				F_ApiCMSLogout	(F_ObjHandleT cmsSessionId);

extern StatusT				F_ApiCMSCheckout	(F_ObjHandleT cmsSessionId,
													F_ObjHandleT cmsObjectId,
													BoolT rootWithDescendants);

extern StatusT				F_ApiCMSCheckin	(F_ObjHandleT cmsSessionId,
												F_ObjHandleT objectId,
												const F_IdValuePairsT *checkinParam);

extern StatusT				F_ApiCMSCancelCheckout	(F_ObjHandleT cmsSessionId,
														F_ObjHandleT objectId);

extern StatusT				F_ApiCMSDelete	(F_ObjHandleT cmsSessionId,
												F_ObjHandleT cmsObjectId,
												const F_IdValuePairsT *deleteParams);

extern F_ObjHandleT 		F_ApiCMSOpenFile	(F_ObjHandleT cmsSessionId,
													F_ObjHandleT cmsObjectId,
													const F_IdValuePairsT *openParams);

extern StatusT				F_ApiCMSUploadObject	(F_ObjHandleT cmsSessionId,
														F_ObjHandleT cmsObjectId,
														ConStringT localFilePath);

extern StringT				F_ApiCMSDownloadObject	(F_ObjHandleT cmsSessionId,
														F_ObjHandleT cmsObjectId);

extern F_ObjHandleT			F_ApiGetCMSObjectFromPath	(F_ObjHandleT cmsSessionId,
															ConStringT urlPath);
extern StatusT F_ApiCMSAddToRecentFiles (F_ObjHandleT cmsSessionId, 
	F_ObjHandleT objectId);
extern StatusT F_ApiCMSAddToFavouriteFolders (F_ObjHandleT cmsSessionId, 
	F_ObjHandleT objectId);
extern StatusT F_ApiCMSRemoveFromFavouriteFolders (
	F_ObjHandleT cmsSessionId, F_ObjHandleT objectId);
extern BoolT F_ApiCMSIsFavouriteFolder (F_ObjHandleT cmsSessionId, 
	F_ObjHandleT objectId);
/************************************************************************************/
/* CMS Automation related APIs - end */
/************************************************************************************/


/************************************************************************************/
/* CMS API - end */
/************************************************************************************/


#ifdef __cplusplus
}
#endif

#endif /* FCMSAPI_H */
