/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2007 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains the property of
* Adobe Systems Incorporated and its suppliers, if any.  The intellectual
* and technical concepts contained herein are proprietary to Adobe Systems
* Incorporated and its suppliers and may be covered by U.S. and Foreign
* Patents, patents in process, and are protected by trade secret or
* copyright law. Dissemination of this information or reproduction of this
* material is strictly forbidden unless prior written permission is
* obtained from Adobe Systems Incorporated.
**************************************************************************/

#ifndef _FNetLib_h__
#define _FNetLib_h__

#ifdef __cplusplus
extern "C" {
#endif // #ifdef __cplusplus

typedef enum F_NetLibErr
{
	F_NL_NONE = 0,
	
	/* Start error codes */
	F_NL_NOT_INITIALIZED,
	F_NL_NOT_FOUND,
	F_NL_IO_ERROR,
	F_NL_MEMORY_ERROR,
	F_NL_BAD_INPUT_DATA,
	F_NL_SERVER_NOT_RESPONDING,
	F_NL_UNKNOWN_HOST,
	F_NL_TIMED_OUT,
	F_NL_UNKNOWN_AUTH_TYPE,
	F_NL_HTTP_ERROR,
	F_NL_HTTP_NOT_MODIFIED,
	F_NL_HTTP_NOT_FOUND,
	F_NL_HTTP_FORBIDDEN,
	F_NL_HTTP_AUTH_REQUIRED,
	F_NL_HTTP_SERVER_ERROR,
	F_NL_HTTP_LOCKED,
	F_NL_HTTP_UNLOCKED,
	F_NL_HTTP_NOT_IMPLEMENTED,
	F_NL_CANCELLED,
	
	/* Add new error codes above this */
	/* End error codes */
	F_NL_UNKNOWN_ERROR,
} F_NetLibErr;

// FdeNetLib_Get wrapper function
extern ErrorT F_NetLibGet FARGS((ConStringT geturl, StringT *pathp, F_NetLibErr *errp));

// FdeNetLib_GetNew wrapper function
extern ErrorT F_NetLibGetNew FARGS((ConStringT geturl, StringT *pathp, F_NetLibErr *errp));

// FdeNetLib_GetCacheFile wrapper function
extern ErrorT F_NetLibGetCacheFile FARGS((ConStringT url, StringT *pathp));

// FdeNetLib_IsNetFile wrapper function
extern ErrorT F_NetLibIsNetFile FARGS((ConStringT url));

// FdeNetLib_CleanURL wrapper function
extern ErrorT F_NetLibCleanURL FARGS((ConStringT oldurl, StringT *newurlp));

// FdeNetLib_QueryCacheForURL wrapper function
extern ErrorT F_NetLibQueryCacheForURL FARGS((ConStringT path, StringT *urlp));

// FdeNetLib_QueryCacheForPath wrapper function
extern ErrorT F_NetLibQueryCacheForPath FARGS((ConStringT url, StringT *pathp));

// FdeNetLib_GetAbsoluteURL wrapper function
extern ErrorT F_NetLibGetAbsoluteURL FARGS((ConStringT baseurl, ConStringT relativeurl, StringT *absurlp));

// FdeNetLib_GetRelativeURL wrapper function
extern ErrorT F_NetLibGetRelativeURL FARGS((ConStringT baseurl, ConStringT otherurl, StringT *relativeurlp));

// FdeNetLib_UnescapeStr wrapper function
extern VoidT F_NetLibUnescapeStr FARGS((StringT str));

// FdeNetLib_UploadFolder wrapper function
extern ErrorT F_NetLibUploadFolder FARGS((ConStringT puturl, ConStringT localfolderpath));

// FdeNetLib_Put wrapper function
extern ErrorT F_NetLibPut FARGS((ConStringT puturl, ConStringT localfilepath));

// FdeNetLib_Save wrapper function
extern ErrorT F_NetLibSave FARGS((ConStringT puturl));

#ifdef __cplusplus
} // extern "C"
#endif // #ifdef __cplusplus

#endif // #ifndef _FNetLib_h__
