/*
 * Decompiled with CFR 0.152.
 */
package com.aem.pageexporter.servlets;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.contentsync.PageExporter;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Properties(value={@Property(name="service.description", value={"Page Export Servlet1"}), @Property(name="service.ranking", intValue={100000})})
@Component(metatype=false)
@SlingServlet(methods={"GET"}, resourceTypes={"cq:Page"}, selectors={"export"}, extensions={"zip"}, generateComponent=false)
public class PageExporterOverride
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 46862471784503008L;
    private static final Logger log = LoggerFactory.getLogger(PageExporterOverride.class);
    @Reference
    private PageExporter exporter;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.exportCustom(request, response);
    }

    public synchronized void exportCustom(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Page page = (Page)request.getResource().adaptTo(Page.class);
        if (page == null) {
            response.sendError(204);
            return;
        }
        String fileName = page.getTitle();
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".zip");
        try {
            this.exporter.export(page, request, (HttpServletResponse)response);
        }
        catch (WCMException e) {
            log.error("Page export failed: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void bindExporter(PageExporter pageExporter) {
        this.exporter = pageExporter;
    }

    protected void unbindExporter(PageExporter pageExporter) {
        if (this.exporter == pageExporter) {
            this.exporter = null;
        }
    }
}

