<%--
/****************************************************************/
/*                                                              */
/* ADOBE CONFIDENTIAL                                           */
/* _ _ _ _ _ _ _ _ _ _ _ _ _                                    */
/*                                                              */
/* Copyright [2010-2011] Adobe Systems Incorporated             */
/* All Rights Reserved.                                         */
/*                                                              */
/* NOTICE: All information contained herein is, and remains the */
/* property of Adobe Systems Incorporated and its suppliers, if */
/* any. The intellectual and technical concepts contained       */
/* herein are proprietary to Adobe Systems Incorporated and its */
/* suppliers and may be covered by U.S. and Foreign Patents,    */
/* patents in process, and are protected by trade secret or     */
/* copyright law. Dissemination of this information or          */
/* reproduction of this material is strictly forbidden unless   */
/* prior written permission is obtained from Adobe Systems      */
/* Incorporated.                                                */
/*                                                              */
/****************************************************************/

  ==============================================================================
  Default content script.
  Draws the HTML content.
  ==============================================================================
--%>
<%@include file="/libs/foundation/global.jsp" %>

<%@page import="java.util.*,
    java.net.*,
    com.day.cq.commons.Doctype,
    java.util.GregorianCalendar,
    com.day.cq.wcm.api.WCMMode,
    org.apache.commons.lang.StringEscapeUtils,
    java.util.regex.Pattern,
    java.util.regex.Matcher,
    com.adobe.connect.osgi.service.*,
    com.adobe.connect.osgi.info.*,
    com.adobe.connect.osgi.common.Constants,
    java.text.MessageFormat,  
    com.adobe.connect.osgi.util.*,
    com.adobe.connect.osgi.service.exception.*,
    com.adobe.granite.xss.XSSAPI,
    com.adobe.connect.client.xmlapi.APIException" 
%>
<%! private static final String XSSUtilService = "XSSUtilService";%>
<% 
    //Since xssUtilService object is not accessible java code therefoe adding it in the request scope
    XSSUtilService xssUtilService = sling.getService(com.adobe.connect.osgi.util.XSSUtilService.class);
    request.setAttribute(XSSUtilService, xssUtilService); 
%>

<%!
    private static final String COOKIE_TIME_ZONE = "time-zone";
    private static final String REQUEST_ATTRIB_TIME_ZONE = "time-zone";      
    private static TimeZone getTimeZone(HttpServletRequest request) throws Exception
    {
       
        TimeZone timeZone = (TimeZone)request.getAttribute(REQUEST_ATTRIB_TIME_ZONE);
        if (timeZone != null)
            return timeZone;

        Cookie cookieTimeZone = ((org.apache.sling.api.SlingHttpServletRequest)request).getCookie(COOKIE_TIME_ZONE);

        if (cookieTimeZone != null)
        {
            String value = java.net.URLDecoder.decode(cookieTimeZone.getValue(), "UTF-8");
            if (value != null && value.length() > 0)
            {
                for (String zoneId : TimeZone.getAvailableIDs()) 
                {
                    if (value.equals(zoneId))
                    {
                        timeZone = TimeZone.getTimeZone(value);
                        request.setAttribute(REQUEST_ATTRIB_TIME_ZONE, timeZone);
                        return timeZone;
                    }
                }
            }
        }

        timeZone = TimeZone.getDefault();
        request.setAttribute(REQUEST_ATTRIB_TIME_ZONE, timeZone);
        return timeZone;
    }
    
    private static final String REQUEST_ATTRIB_EVENT_INFO = "event-info";

    private static String getAccountId(Node node, HttpServletRequest request, Node connectInfo, APIProvider connectAPIService, boolean isIndependentCQInstance) throws Exception {
        
        String accountId = ContentUtils.getConnectAccountId(node, request, connectInfo, isIndependentCQInstance); 
		
        if (accountId != null) {
            return accountId;
        } else {        
            // try to retrieve account-id from event-info if possible
            EventInfo eventInfo = getEventInfo(request, node, connectAPIService);
            if (eventInfo != null) {
                return eventInfo.getAccountId();
            } else {
                return null;
            }
        }
    }
    
    private static EventInfo getEventInfo(HttpServletRequest request, Node currentNode, APIProvider connectAPIService) throws Exception
    {
        
        XSSUtilService xssUtilService = (com.adobe.connect.osgi.util.XSSUtilService)request.getAttribute(XSSUtilService); 
        String eventId = xssUtilService.getValidLongAsString(request.getParameter("sco-id"));
        if ( null == eventId || 0 == eventId.length() ) {
            eventId = (String)request.getAttribute("sco-id");
            if ( null == eventId || 0 == eventId.length() ) {         
                Node parentContainerComponent = ContentUtils.getParentOfType(currentNode, Constants.EVENT_ASSOCIATER_COMPONENT_PATH, "cq:Page");
                if ( null == parentContainerComponent ) {
                    parentContainerComponent = ContentUtils.getParentOfType(currentNode, Constants.EVENT_ASSOCIATER_COMPONENT_PATH, "cq:Page");
                    if ( null == parentContainerComponent ) {
                        return null;
                    }
                }
                try {
                    eventId = parentContainerComponent.getProperty("sco").getString();
                } catch ( Exception e ) {
                    return null;
                }                   
                if ( null == eventId || 0 == eventId.length() ) {
                    return null;
                }
            }
        }
        
        String attributeName = REQUEST_ATTRIB_EVENT_INFO + "-" + eventId;
            
        EventInfo eventInfo = (EventInfo)request.getAttribute(attributeName);
        if (eventInfo != null)
            return eventInfo;

        try {
            eventInfo = connectAPIService.getEvent(eventId);
        } catch ( ConnectServiceException ex ) {
        if ( ! FailureCode.API_ERROR.equals(ex.getErrorCode()) )
            {
                throw ex;
            }
            eventInfo = null;            
        }
        
        request.setAttribute(attributeName, eventInfo);
        return eventInfo;
    }
    
    
    public boolean hasWriteAccess(Node pageNode, Session userSession) throws RepositoryException 
    {
          String path = pageNode.getPath();
          try 
          {
            userSession.checkPermission(path, "add_node,set_property");
            return true;
          }
          catch(java.security.AccessControlException e) 
          {
            return false;
          }
    }
    
    private String getTemplateFolderPath(String sites, String principalId, String accountId, String type, String access)
    {
        if ( access.equals("private") ) 
        {
               return sites + "/c1/" + accountId + "/en/events/" + type + "/private/" + principalId;
        }
        else
        {
            return sites + "/c1/" + accountId + "/en/events/" + type + "/shared";   
        }
    }
    
    private static final Pattern SCO_ID_REG_EX_PATTERN = Pattern.compile(".*[?&]sco-id=(\\d+).*");
%>

<%
    if (request.getParameter("sco-id") == null) {
        String referer = request.getHeader("Referer");
        if (referer != null) {
            Matcher matcher = SCO_ID_REG_EX_PATTERN.matcher(referer);
            if (referer.indexOf("/content/connect/")>0 && matcher.matches()) {
                request.setAttribute("sco-id", matcher.group(1)); 
            }
        }
    }

    // helper jsp for connect apis and global variables
    // add more initialization code here
    
    Node connectInfo = null;
    APIProvider connectAPIService = null;
    String connectServer = null;
    String connectSessionId = null;
    try
    {
        if (currentNode!=null) {
            connectInfo =  currentNode.getSession().getNode("/content/connect/connectinfo");
        }
        ConnectService connectService = sling.getService(ConnectService.class);
        connectServer = connectService.getConnectServerUrl();
        connectSessionId = ConnectUtil.validateAndGetConnectSessionId(request, connectServer);
        connectAPIService = connectService.getAPIProvider(connectSessionId);        
    }
    catch(Exception exp)
    {
        throw new Exception("unable to initialize connect properties",exp);
    }
    boolean isIndependentCQInstance = ContentUtils.isIndependentCQInstance(slingRequest.getResourceResolver().adaptTo(Session.class));
    String campaignId =request.getParameter("campaign-id"); 
	String cqSessionParameterString = ConnectUtil.getCQSessionParameterString(request);

%>
<%@include file="/apps/connect/languagePreference.jsp" %>
<% if ( null == request.getAttribute("isConnectClientLibIncluded") ) { 
    request.setAttribute("isConnectClientLibIncluded", true); %>
	
	<% if (WCMMode.fromRequest(request) != WCMMode.DISABLED) { %>
        <cq:includeClientLib categories="cq.widgets"/>
        <%  }   
		else { %>
			    <cq:includeClientLib categories="cq.shared"/>
		<% } %>
    <cq:includeClientLib categories="apps.connect-main"/>
    <% currentDesign.writeCssIncludes(pageContext); %>
    <%
    
    /*The campaign-id is to saved as a cookie. 
      Hence it is necessary to encode it, as 
      HIGH ASCII characters should not be saved in a cookie.*/
    if(campaignId != null)
    {
          campaignId = ConnectUtil.customUrlEncode(xssUtilService.filter(campaignId));
    }

    String scoIdForCampaign;
    try {
        scoIdForCampaign = currentNode.getParent().getParent().getProperty("sco").getString();
    } catch ( Exception e ) {
        scoIdForCampaign = null;
    }
    if (scoIdForCampaign == null || scoIdForCampaign.length() == 0) {
        scoIdForCampaign =  xssUtilService.getValidLongAsString(request.getParameter("sco-id"));
      if (scoIdForCampaign == null || scoIdForCampaign.length() == 0)
          scoIdForCampaign = (String)request.getAttribute("sco-id");
    }
    if(campaignId != null && !campaignId.isEmpty() && scoIdForCampaign != null && !scoIdForCampaign.isEmpty())
    {
        Cookie campaignCookie = new Cookie(scoIdForCampaign + "_campaign-id",campaignId);
        campaignCookie.setMaxAge(-1);
        if ( isIndependentCQInstance ) {
            campaignCookie.setPath("/");
        } else {
            campaignCookie.setPath(connectInfo.getProperty("sites").getString());
        }        
        response.addCookie(campaignCookie);

        /*Bug#3802091: Also set the generic campaign session cookie which is independent of the sco id. 
          This will be used for campaign tracking in case there are cross promoted events */

        Cookie eventSessionCampaignCookie = new Cookie("connectevent_campaign-id",campaignId);
        eventSessionCampaignCookie.setMaxAge(-1);
        if ( isIndependentCQInstance ) {
            eventSessionCampaignCookie.setPath("/");
        } else {
            eventSessionCampaignCookie.setPath(connectInfo.getProperty("sites").getString());
        }        
        response.addCookie(eventSessionCampaignCookie);
    }
    %>
    <% if (isIndependentCQInstance) { %>
        <cq:includeClientLib categories="apps.connect-main-css-overwrite"/>
    <% } %>
<% } %>
<%@include file="/apps/connect/custom_scripts.jsp" %>     