<%--
/****************************************************************/
/*                                                              */
/* ADOBE CONFIDENTIAL                                           */
/* _ _ _ _ _ _ _ _ _ _ _ _ _                                    */
/*                                                              */
/* Copyright [2010-2011] Adobe Systems Incorporated             */
/* All Rights Reserved.                                         */
/*                                                              */
/* NOTICE: All information contained herein is, and remains the */
/* property of Adobe Systems Incorporated and its suppliers, if */
/* any. The intellectual and technical concepts contained       */
/* herein are proprietary to Adobe Systems Incorporated and its */
/* suppliers and may be covered by U.S. and Foreign Patents,    */
/* patents in process, and are protected by trade secret or     */
/* copyright law. Dissemination of this information or          */
/* reproduction of this material is strictly forbidden unless   */
/* prior written permission is obtained from Adobe Systems      */
/* Incorporated.                                                */
/*                                                              */
/****************************************************************/

  ==============================================================================
  Default content script.
  Draws the HTML content.
  ==============================================================================
--%>
<%@include file="/apps/connect/common.jsp" %>
<%@ page import="com.adobe.connect.osgi.util.*,java.util.Locale" %><%
String languagePref = request.getHeader("Accept-Language");
if ( languagePref == null || "".equals(languagePref) ) {
    languagePref = "en";
}
Locale loc = ConnectUtil.getLocale(languagePref.split(",", 2)[0]);
ResourceBundle defResBundle = slingRequest.getResourceBundle(loc);
String accountId = request.getParameter("accountId");
String eventCatalogPageLink = null;
// If the accountId is null, event catalog link must not be set.
if(accountId != null){
    eventCatalogPageLink = connectInfo.getProperty("sites").getString() + "/c1/" + xssUtilService.getValidLong(request.getParameter("accountId")) + "/" + connectInfo.getProperty("catalogRelativePath").getString() + "catalog.html";
}
String errorType = xssUtilService.encodeForHTMLAttr(request.getParameter("error"));
//pageLanguagePreference : Refer to /apps/connect/languagePreference.jsp which is included in the common.jsp 
%> 
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html lang="<%=pageLanguagePreference%>">
<head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
    <meta http-equiv="keywords" content=""/>
    <meta http-equiv="description" content=""/>
    <link href="/etc/designs/connect/clientlibs/main.css" rel="stylesheet" type="text/css"/>
    <title><%= defResBundle.getString("titleErrorPage") %></title>
</head>

<body class="body" style="background-color: #EAEAEA">
    <div class="main-bg">  
        <div class="connect-main-content" style="text-align: center;">
            <div class="email_page" style="background-color: #EAEAEA; padding: 0px; text-align: left;">
               <div style="background-color: WHITE; padding: 20px;">
                    <% if ( null == errorType ) { %>
                        <div class="error_page_header"><%= defResBundle.getString("errorTypeMissing") %></div>
                    <% } else {
                        if ( "cancelled".equals(errorType) ) { %>
                            <div class="error_page_header"><%= defResBundle.getString("headerCancelled") %></div>
                            <div class="error_page_details"><%= defResBundle.getString("cancelledErrorPageDetail") %></div>
                        <% } else if ( "not-published".equals(errorType)) { %>
                            <div class="error_page_header"><%= defResBundle.getString("headerUnpublished") %></div>
                            <div class="error_page_details"><%= defResBundle.getString("unpublishedErrorPageDetail") %></div>
                        <% } else if ( "wrong-account".equals(errorType)) { %>
                            <div class="error_page_header"><%= defResBundle.getString("headerWrongAccount") %></div>
                            <div class="error_page_details"><%= defResBundle.getString("wrongAccountErrorPageDetail") %></div>
                        <% } else if ( "event-page-not-found".equals(errorType)) { %>
                            <div class="error_page_header"><%= defResBundle.getString("eventPageNotFound") %></div>
                            <div class="error_page_details"><%= defResBundle.getString("eventPageNotFoundDetail") %></div>
                        <% } else if ( "access-denied".equals(errorType)) { %>
                            <div class="error_page_header"><%= defResBundle.getString("eventRegistrationNoAccess") %></div>
                            <div class="error_page_details"><%= defResBundle.getString("noAccessErrorPageDetail") %></div>
                        <% } else if ( "not-available".equals(errorType)) { %>
                            <div class="error_page_header"><%= defResBundle.getString("headerUnavailable") %></div>
                            <div class="error_page_details"><%= defResBundle.getString("unavailableErrorPageDetail") %></div>
						<% } %>
                    <% } %>
                    <div class="error_page_footer">
                        <%= defResBundle.getString("noteThankYou") %><br />                    
                        <%= defResBundle.getString("labelEventHost") %>
                    </div>
                    <% if ( ! isIndependentCQInstance && eventCatalogPageLink != null) { %>
                        <hr style="color: #808080; height: 1px; margin-bottom: 20px;" />
                        <div style="padding-bottom: 20px;  font-size: 14px;">
                            <a href="<%= eventCatalogPageLink %>"><%= defResBundle.getString("gotoEventCatalogPage") %></a>
                        </div>
                    <% } %>
                </div>
                
                <div style="font-size: 10px; color: #808080; font-family: Helvetica; font-style: normal; padding: 0px; margin-top: 20px;">
                    <%= defResBundle.getString("errorPageFooter") %>
                </div>
                
             </div>  
        </div>
    </div> 
</html>