
CQ.form.rte.ui.IcsVariableSelector = CQ.Ext.extend(CQ.form.rte.ui.TbElement, {

    variableSelector: null,

    variables: null,

    toolbar: null,

    constructor: function(id, plugin, tooltip, variables) {
        CQ.form.rte.ui.IcsVariableSelector.superclass.constructor.call(this, id, plugin, false,
                tooltip);
        this.variables = variables;
    },

    /**
     * Creates HTML code for rendering the options of the variable selector.
     * @return {String} HTML code containing the options of the variable selector
     * @private
     */
    createStyleOptions: function() {
        var htmlCode = "";
        if (this.variables) {
            for (var v in this.variables) {
                var variableToAdd = this.variables[v];
                htmlCode += "<option value=\"" + variableToAdd.value + "\">" + CQ.I18n.getMessage(variableToAdd.text) + "</option>";
            }
        }
        return htmlCode;
    },

    getToolbar: function() {
        return CQ.form.rte.ui.ToolbarBuilder.STYLE_TOOLBAR;
    },

    addToToolbar: function(toolbar) {
        this.toolbar = toolbar;
        if (CQ.Ext.isIE) {
            // the regular way doesn't work for IE anymore with Ext 3.1.1, hence working
            // around
            var helperDom = document.createElement("span");
            helperDom.innerHTML = "<select class=\"x-font-select\">"
                    + this.createStyleOptions() + "</span>";
            this.variableSelector = CQ.Ext.get(helperDom.childNodes[0]);
        } else {
            this.variableSelector = CQ.Ext.get(CQ.Ext.DomHelper.createDom({
                tag: "select",
                cls: "x-font-select",
                html: this.createStyleOptions()
            }));
        }
        this.variableSelector.on('focus', function() {
            this.plugin.editorKernel.isTemporaryBlur = true;
        }, this);
        // fix for a Firefox problem that adjusts the combobox' height to the height
        // of the largest entry
        this.variableSelector.setHeight(19);
        var addButton = {
            "itemId": this.id + "_insert",
            "iconCls": "x-edit-icsvariable",
            "text": CQ.I18n.getMessage("Insert"),
            "enableToggle": (this.toggle !== false),
            "scope": this,
            "handler": function() {
                this.plugin.execute(this.id + "_insert");
            },
            "clickEvent": "mousedown",
            "tabIndex": -1
        };
        toolbar.add(
            CQ.I18n.getMessage("Runtime Fields"),
            " ",
            this.variableSelector.dom,
            addButton
        );
    },

    createToolbarDef: function() {
        // todo support usage in global toolbar
        return null;
    },

    getSelectedVariable: function() {
        var variable = this.variableSelector.dom.value;
        if (variable.length > 0) {
            return variable;
        }
        return null;
    },

    getExtUI: function() {
        return this.variableSelector;
    },

    getInsertButtonUI: function() {
        return this.toolbar.items.map[this.id + "_insert"];
    }

});