package apps.connect.components.eventcalendarinvite;

import com.adobe.connect.osgi.info.Event;
import com.adobe.connect.osgi.util.ICSWriter;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;

import java.util.List;
import java.util.TimeZone;

public class item_ics extends SlingSafeMethodsServlet
{
    private static final Logger log = LoggerFactory.getLogger(item_ics.class);

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException
    {
        List<Event> eventList = (List<Event>) request.getSession().getAttribute("eventList");
        TimeZone timeZone = (TimeZone) request.getSession().getAttribute("timeZone");
		String eventOwnerEmail = (String) request.getSession().getAttribute("eventOwnerEmail");
		String resolvedMsg = (String) request.getSession().getAttribute("resolvedMsg");



        response.setContentType("text/calendar");
        response.setHeader("Content-Disposition", "attachment;filename=connect.ics");

        ByteArrayOutputStream buf = new ByteArrayOutputStream();

        try
        {
            ICSWriter icsWriter = new ICSWriter();
            buf = icsWriter.write(eventList, timeZone, eventOwnerEmail, resolvedMsg);
        }
        catch (Exception e)
        {
            log.error(e.getMessage(), e);
            throw new javax.servlet.ServletException(e);
        }

        response.getWriter().print(buf.toString());
        response.getWriter().close();
    }
}
