<%@include file="/apps/connect/common.jsp" %>
<cq:setContentBundle/>
<%
ResourceBundle resBundle = slingRequest.getResourceBundle(null);

String eventDuration = null;

EventInfo eventInfo = getEventInfo(slingRequest, currentNode, connectAPIService);
if (eventInfo != null) {
	String beginDateStr = eventInfo.getBeginDate();
	String endDateStr = eventInfo.getEndDate();
	String eventLang = eventInfo.getLang();
		
	if (beginDateStr != null && beginDateStr.length() > 0 && endDateStr != null && endDateStr.length() > 0 && eventLang != null && eventLang != null) {
	    Calendar beginDate = ConnectUtil.parseDate(beginDateStr);
	    Calendar endDate   = ConnectUtil.parseDate(endDateStr);
	    TimeZone tz = getTimeZone(request);
	    beginDate.setTimeZone(tz);
	    endDate.setTimeZone(tz);
	
	    Locale locale = new Locale(eventLang);
	    
	    eventDuration = ConnectUtil.calculateEventDuration(beginDate, endDate, locale, resBundle);
	}
}

if (eventDuration == null) {
	eventDuration = resBundle.getString("defaultEventDuration");
}

String style = ContentUtils.getCSSStyle(properties, isIndependentCQInstance);
%>
<div class="event_time" <%= style %> ><%= eventDuration %></div>