package apps.connect.components.eventimage;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import javax.script.SimpleBindings;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.scripting.SlingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.day.cq.commons.ImageHelper;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.commons.AbstractImageServlet;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.image.Layer;
import com.adobe.connect.osgi.service.*;
import com.adobe.connect.osgi.info.*;
import java.util.HashMap;
import java.util.Map;
import com.day.cq.wcm.api.WCMMode;
import com.adobe.connect.osgi.util.*;
import javax.net.ssl.HttpsURLConnection;


import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;



/**
 * Renders an image
 */
public class eventimage_png extends AbstractImageServlet {


    private final static Logger log = LoggerFactory.getLogger(eventimage_png.class);
    private final static double DEFAULT_JPEG_COMPRESSION_RATIO = 0.82;
    private final static double DEFAULT_GIF_MAX_COLORS = 256;

    private Map<String, Integer> calculateImageSize(Node currentNode, int originalWidth, int originalHeight, int predefinedWidth, int predefinedHeight) throws RepositoryException
    {
        Map<String, Integer> imageSize = new HashMap<String, Integer>();
        imageSize.put("width",  predefinedWidth);
        imageSize.put("height", predefinedHeight);

        if ( currentNode.hasProperty("sizeSelector") )
        {
            String sizeSelector = currentNode.getProperty("sizeSelector").getValue().getString();
            if (currentNode!=null && currentNode.hasProperty("sizeSelector") && sizeSelector!=null && !sizeSelector.equals("predefinedSize"))
            {
                if (sizeSelector.equals("maintainAspectRatio"))
                {
                    if (currentNode!=null && currentNode.hasProperty("dimensionSelector") && currentNode.hasProperty("dimension"))
                    {
                        String dimensionSelector = currentNode.getProperty("dimensionSelector").getValue().getString().toLowerCase();
                        String dimensionSize = currentNode.getProperty("dimension").getValue().getString();
                        if ( dimensionSelector.equals("width") )
                        {
                            imageSize.put("width",  Integer.parseInt(dimensionSize));
                            imageSize.put("height", ((Integer.parseInt(dimensionSize)*originalHeight)/originalWidth));
                        }
                        else
                        {
                            imageSize.put("height",  Integer.parseInt(dimensionSize));
                            imageSize.put("width", ((Integer.parseInt(dimensionSize)*originalWidth)/originalHeight));
                        }
                    }
                }
                else if ( sizeSelector.equals("originalSize") )
                {
                    imageSize.put("width",  originalWidth);
                    imageSize.put("height", originalHeight);
                }
                else if ( sizeSelector.equals("cutsomSize") )
                {
                    if (currentNode!=null && currentNode.hasProperty("width"))
                    {
                        imageSize.put("width",  Integer.parseInt(currentNode.getProperty("width").getValue().getString()));
                    }
                    if (currentNode!=null && currentNode.hasProperty("height"))
                    {
                        imageSize.put("height", Integer.parseInt(currentNode.getProperty("height").getValue().getString()));
                    }
                }
            }
        }
        return imageSize;
    }


    protected Layer createLayer(ImageContext ctx) throws RepositoryException, IOException {
        // don't create the later yet. handle everything later
        return null;
    }


    private String getMimeType(String imgUrl)
    {
        String mimeType = imgUrl.substring(imgUrl.lastIndexOf(".") + 1);
        int parameterCnt = mimeType.indexOf("?");
        if ( parameterCnt != -1 ) {
            mimeType = mimeType.substring(0, mimeType.indexOf("?"));
        }
        return "image/" + mimeType.toLowerCase();
    }

    protected void writeLayer(SlingHttpServletRequest req, SlingHttpServletResponse resp, ImageContext ctx, Layer layer) throws IOException, RepositoryException
    {
        Map<String, Integer> imageSize;
        Layer imageLayer     = null;
        String imgUrl        = req.getParameter("imgUrl");
        String defaultImg    = req.getParameter("defaultImg");
        int predefinedWidth  = Integer.parseInt(req.getParameter("preWidth"));
        int predefinedHeight = Integer.parseInt(req.getParameter("preHeight"));
        String scoId         = req.getParameter("sco-id");
        Node currentNode     = ctx.resource.adaptTo(Node.class);
        if ( imgUrl != null && ! "".equals(imgUrl) )
        {
            URL url = null;
            URLConnection uc = null;
            String connectServerUrl = ContentUtils.getConnectServer(currentNode.getSession());
            String connectSessionId = ConnectUtil.validateAndGetConnectSessionId(req, connectServerUrl );
            imgUrl += "?connect-session=" + connectSessionId;
            url = new URL ( imgUrl );
            uc = url.openConnection();
            if ( url.getProtocol().equalsIgnoreCase("HTTPS") ) {
                try {
                    //ConnectUtil.ignoreHttpsSSLCert((HttpsURLConnection)uc);
                    ((HttpsURLConnection)uc).setFollowRedirects(true);
                } catch ( Exception e ) {}
            } else {
                ((HttpURLConnection)uc).setFollowRedirects(true);
            }
            BufferedImage img = ImageIO.read(uc.getInputStream());
            imageSize = calculateImageSize(currentNode, img.getWidth(), img.getHeight(), predefinedWidth, predefinedHeight);
            int width = imageSize.get("width"), height = imageSize.get("height");
            imageLayer = new Layer(width, height, new Color(255, 255, 255, 0));
            Graphics2D g = imageLayer.getG2();
            g.drawImage(img, AffineTransform.getScaleInstance((double)width / img.getWidth(), (double)height / img.getHeight()), null);
            String mimeType = getMimeType(imgUrl);
            double quality = ( mimeType.equalsIgnoreCase("image/gif") ? DEFAULT_GIF_MAX_COLORS : DEFAULT_JPEG_COMPRESSION_RATIO );
            imageLayer.write(mimeType, quality, resp.getOutputStream());
        }
        else
        {
            // load default image
            imageLayer  = ImageHelper.createLayer(currentNode.getSession().getNode(defaultImg));
            imageSize   = calculateImageSize(currentNode, imageLayer.getWidth(), imageLayer.getHeight(), predefinedWidth, predefinedHeight);
            if ( WCMMode.fromRequest(req) != WCMMode.DISABLED || scoId == null || "".equals(scoId))
            {
                // resize default image
                imageLayer.resize(imageSize.get("width"), imageSize.get("height"));
                String mimeType = getMimeType(defaultImg);
                double quality = ( mimeType.equalsIgnoreCase("image/gif") ? 256 : -1 );
                imageLayer.write(mimeType, quality, resp.getOutputStream());
            }
            else
            {
                imageLayer = new Layer(imageSize.get("width"), imageSize.get("height"), new Color(255, 255, 255, 0));
                imageLayer.write("image/png", 1.0, resp.getOutputStream());
            }
        }
        resp.flushBuffer();
    }
}