<%@include file="/apps/connect/common.jsp" %>
<%@page import="com.adobe.connect.osgi.service.*,
                java.util.*,
                java.text.*,
                com.adobe.connect.osgi.util.ConnectUtil,
                com.adobe.connect.osgi.info.Event,
                com.adobe.connect.osgi.info.Tag,
                com.day.cq.wcm.api.WCMMode"%><%
                
%>
<cq:includeClientLib categories="cq.jquery"/> 
<%!

private static final int STRIP_SIZE = 16;
private static final int STRIP_MARGIN = 1;

private static final String[] CSS_CLASS_COLORS = {
    " calendar_strip_color_1", " calendar_strip_color_2", " calendar_strip_color_3", " calendar_strip_color_4", " calendar_strip_color_5", " calendar_strip_color_6"  
};

private String getCssClassColor(int colorCounter) {
    return CSS_CLASS_COLORS[ colorCounter % CSS_CLASS_COLORS.length ];    
}

private class EventWrapper {
    
    private int eventIndex = 0;

    private final Event event; // the event we're wrapping 
    private final Calendar calendarBegin; 
    private final Calendar calendarEnd;
    private String landPageUrl;
    
    private int indexFirstDay;
    private int indexLastDay;
	
    private boolean showThisWeek; // helper field to avoid showing the same event more than once in a week
	
    public EventWrapper(Event event, HttpServletRequest request) throws Exception {
        this.event = event;
        this.calendarBegin = ConnectUtil.parseDate(event.getBeginDate());
        this.calendarEnd   = ConnectUtil.parseDate(event.getEndDate());
        this.calendarBegin.setTimeZone(getTimeZone(request));
        this.calendarEnd.setTimeZone(getTimeZone(request));
        String eventTemplatePath = event.getEventTemplatePath();
		XSSUtilService xssUtilService = (com.adobe.connect.osgi.util.XSSUtilService)request.getAttribute(XSSUtilService); 
		 
        if(eventTemplatePath != null)
        {
            landPageUrl = (eventTemplatePath.startsWith("content/connect/system/templates")?"/":"../../") + 
            eventTemplatePath + "/event_landing.html" + "?sco-id=" + event.getScoId();
            
            if( request.getParameter("campaign-id") != null)
            {
                landPageUrl += "&campaign-id="+ xssUtilService.filter(request.getParameter("campaign-id"));
            }
        }

    }
    
    public int getEventIndex() { return eventIndex; }
    public void setEventIndex(int eventIndex) { this.eventIndex = eventIndex; } 
    
    public String getName() { return event.getName(); }
    public String getScoId() { return event.getScoId(); }

    public Calendar getCalendarBegin() { return calendarBegin; }
    public Calendar getCalendarEnd() { return calendarEnd; }
    public String getLandPageUrl() { return landPageUrl; }
    
    public int getIndexFirstDay() { return indexFirstDay; }
    public void setIndexFirstDay(int indexFirstDay) { this.indexFirstDay = indexFirstDay; }
    public int getIndexLastDay() { return indexLastDay; }
    public void setIndexLastDay(int indexLastDay) { this.indexLastDay = indexLastDay; }
    
    public boolean getShowThisWeek() { return showThisWeek; }
    public void setShowThisWeek(boolean showThisWeek) { this.showThisWeek = showThisWeek; }  
    public String getUrlPath() { return event.getUrlPath(); }
}

private class EventCalendarDay {

    private final int year;
    private final int month;
    private final int day;
    private final long timeInMillis;
    
    private String cssClass;
    private int dayOfWeek;
    
    private EventWrapper[] events;
    private int size;
    
    public EventCalendarDay(Calendar cal) {
        timeInMillis = cal.getTimeInMillis();
        this.year = cal.get(Calendar.YEAR);
        this.month = cal.get(Calendar.MONTH);
        this.day = cal.get(Calendar.DAY_OF_MONTH);
        events = null;
        size = 0;
    }
    
    public int getYear() { return this.year; }
    public int getMonth() { return this.month; }
    public int getDay() { return this.day; }
    public long getTimeInMillis() { return this.timeInMillis; }
    
    public String getCssClass() { return this.cssClass; }
    public void setCssClass(String cssClass) { this.cssClass = cssClass; }
    
    public int getDayOfWeek() { return this.dayOfWeek; }
    public void setDayOfWeek(int dayOfWeek) { this.dayOfWeek = dayOfWeek; }
    
    public EventWrapper getAtPosition(int index) {
        if (events == null || index >= events.length)
            return null;
        else
            return events[index];
    }

    public void putAtPosition(int index, EventWrapper event) {
        if (events == null)
            events = new EventWrapper[index + 1 + 5];

        if (index >= events.length)
            events = Arrays.copyOf(events, index + 1 + 5);

        if (events[index] == null) {
            events[index] = event;
            if (index > size - 1)
                size = index + 1;
        }
    }
    
    public EventWrapper[] getEvents() { return events; }
    public int getSize() { return size; }
}

public static boolean putEvent(EventWrapper event, EventCalendarDay[] eventDays, int eventIndexCounter) {
    int indexFirstDay = -1;
    int indexLastDay  = -1;
    long eventBegin = event.getCalendarBegin().getTimeInMillis();
    long eventEnd = event.getCalendarEnd().getTimeInMillis();

    for (int i = 0; i < eventDays.length; i++) {
        long dayBegin = eventDays[i].getTimeInMillis();
        long dayEnd   = dayBegin + 86400000; // 24 * 60 * 60 * 1000
        if (indexFirstDay == -1 && eventBegin >= dayBegin && eventBegin < dayEnd)
            indexFirstDay = i;
        if (indexLastDay == -1 && eventEnd >= dayBegin && eventEnd < dayEnd)
            indexLastDay = i;
    }

    // if the event start day is not visible in current calendar view it is ok to leave the index as -1,
    // but for the end day we'll place the index just after the end of the current calendar view
    if (indexLastDay == -1) {
        indexLastDay = eventDays.length;
    }
    
    event.setIndexFirstDay(indexFirstDay);
    event.setIndexLastDay(indexLastDay);
    
    int indexInMonthFirstDay = indexFirstDay;
    if (indexInMonthFirstDay < 0 || indexInMonthFirstDay >= eventDays.length)
        indexInMonthFirstDay = 0;
    int indexInMonthLastDay = indexLastDay;
    if (indexInMonthLastDay < 0 || indexInMonthLastDay >= eventDays.length)
        indexInMonthLastDay = eventDays.length - 1;

    // put event to the current calendar view 
    int index = 0;
    while (true) {
        // detect first free offset in all days 
        boolean free = true;
        for (int i = indexInMonthFirstDay; i <= indexInMonthLastDay; i++) {
            if (eventDays[i].getAtPosition(index) != null) {
                index++;
                free = false;
                break;
            }
        }
        if (index > 100)
            return false;
        if (!free)
            continue;

        // put it in all days at the same offset
        for (int i = indexInMonthFirstDay; i <= indexInMonthLastDay; i++) {
            eventDays[i].putAtPosition(index, event);
        }
        
        event.setEventIndex(eventIndexCounter);
        
        break;
    }
    
    return true;
}

%><%
    
    String componentName = currentNode.getName(); // the name of the component from CRX

    // get today
    
    Calendar today  = new GregorianCalendar();
    today.setTimeZone(getTimeZone(request));
    

    // get year and month from HttpRequest or get them from "today"

    int year = -1;
    int month = -1; // zero based (eg. 0-11)
    
    if(request.getParameter("paramYear") != null){
        year = xssUtilService.getValidInteger(request.getParameter("paramYear"));
    }
    if(request.getParameter("paramMonth") != null){
        month = xssUtilService.getValidInteger(request.getParameter("paramMonth"));
    }
   
    //out.write("Year" + year + " Month" + month);
    
    if (year < 0) {
        year = today.get(Calendar.YEAR);
    }

    if (month < 0) {
        month = today.get(Calendar.MONTH);
    }
    
    
    // get first and last day of week
    
    int firstDayOfWeek; // 1 based (eg. 1-7)
    int lastDayOfWeek; 

    if(currentNode.hasProperty("firstDayOfWeek")) {
        firstDayOfWeek = (int)currentNode.getProperty("firstDayOfWeek").getLong();
        if (firstDayOfWeek < Calendar.SUNDAY && firstDayOfWeek > Calendar.SATURDAY)
            firstDayOfWeek = Calendar.SUNDAY;
    }
    else {
        firstDayOfWeek = Calendar.SUNDAY;
    }

    lastDayOfWeek = (firstDayOfWeek + 5) % 7 + 1;
    
    
    // define calendar dates for first and last days in the current view
    // (these can be in different months)

    Calendar calStart = new GregorianCalendar(year, month, 1);
    Calendar calEnd   = new GregorianCalendar(year, month, calStart.getActualMaximum(Calendar.DAY_OF_MONTH));
    
    calStart.setTimeZone(getTimeZone(request));
    calEnd.setTimeZone(getTimeZone(request));
    
    int dayOfWeek;
    
    dayOfWeek = calStart.get(Calendar.DAY_OF_WEEK);
    if (dayOfWeek > firstDayOfWeek) {
        calStart.add(Calendar.DAY_OF_MONTH, firstDayOfWeek - dayOfWeek);
    }
    else if (dayOfWeek < firstDayOfWeek) { 
        calStart.add(Calendar.DAY_OF_MONTH, firstDayOfWeek - dayOfWeek - 7);
    }

    dayOfWeek = calEnd.get(Calendar.DAY_OF_WEEK);
    if (dayOfWeek > lastDayOfWeek) {
        calEnd.add(Calendar.DAY_OF_MONTH, 7 - (dayOfWeek - lastDayOfWeek));
    }
    else if (dayOfWeek < lastDayOfWeek) { 
        calEnd.add(Calendar.DAY_OF_MONTH, lastDayOfWeek - dayOfWeek);
    }
    
    
    // calculate number of days in view of calendar month
    // (must be divisible by 7, the actual values can be 28, 35 or 42) 
    
    int days = calEnd.get(Calendar.DAY_OF_YEAR) - calStart.get(Calendar.DAY_OF_YEAR) + 1;
    if (days <= 0) {
        days += calStart.getActualMaximum(Calendar.DAY_OF_YEAR);
    }
    
    
    // get parameters for fetching event list
    
    //get Tag id for search
    List<String> tagIdList = new ArrayList<String>(); 
    String[] paramTagIdList = slingRequest.getParameterValues("paramTagIdList");
    if (paramTagIdList != null && paramTagIdList.length > 0) {
        tagIdList = Arrays.asList(paramTagIdList);
    }

    //get sub-filter tag
    String subFilterTagId  = xssUtilService.getValidLongAsString(slingRequest.getParameter("paramSubFilterTagId"));
    //out.write("subFilterTagId " + subFilterTagId);
    //get filter tags rule
    String filterTagsRule  = "any";
    if(currentNode.hasProperty("filterTagsRule")){
        filterTagsRule = currentNode.getProperty("filterTagsRule").getString();
    }


    Date dateStart = calStart.getTime();
    Date dateEnd = new Date(calEnd.getTimeInMillis() + 86400000); // include last day
    
    //get folder-id
    String folderId  = xssUtilService.getValidLongAsString(slingRequest.getParameter("folder-id"));
    
    //out.write("folderId " + folderId);
    String accountId = getAccountId(currentNode, request, connectInfo, connectAPIService, isIndependentCQInstance);
    
    boolean buildCatalogUsingConnectServer = "connectServer".equals(properties.get("buildCatalogUsing", "local")); 
    Map<String, String> subscribedEvents = null;
    String[] eventIds = null;
    if ( isIndependentCQInstance && ! buildCatalogUsingConnectServer ) {
        //fetch event list   
        subscribedEvents = ConnectUtil.getSubscribedEventIds(currentNode, currentPage.getParent().getPath(), Constants.EVENT_ASSOCIATER_COMPONENT);
        Object[] objectArr = subscribedEvents.keySet().toArray();        
        eventIds = Arrays.copyOf(objectArr, objectArr.length, String[].class);        
    }
    
    List<Event> eventList; 
    try { 
        eventList = connectAPIService.getEventList(eventIds, accountId, dateStart, dateEnd, folderId, tagIdList, Event.EventCategory.LIVE, subFilterTagId, filterTagsRule, false, Event.FilterFields.DATE_BEGIN.toString(), "asc", -1, -1, isIndependentCQInstance, false);
    } catch ( ConnectServiceException ex ) {
        if ( ! FailureCode.API_ERROR.equals(ex.getErrorCode()) )
        {
            throw ex;
        }   
        //out.write(eventResBundle.getString("errConnectingToServer"));
        return;
    } 
    
    EventWrapper[] eventWrappers = new EventWrapper[eventList.size()];
    for (int i = 0; i < eventList.size(); i++) {
        eventWrappers[i] = new EventWrapper(eventList.get(i), request);
    }

    //out.write("<script>alert(" + eventList.size() + ");</script>");
    
    //out.write(String.format("DEBUG: %1$tc<br/>", calStart));
    //out.write(String.format("DEBUG: %1$tc<br/>", calEnd));

    
    // put event list and timeZone into session to make it available in items.ics, i.e. in "Download ICS" servlet 

    slingRequest.getSession().setAttribute("eventList", eventList);
    slingRequest.getSession().setAttribute("timeZone", getTimeZone(request));
    
    
    // make calendar

    Calendar calDay = (Calendar)calStart.clone();

    EventCalendarDay[] calDays = new EventCalendarDay[days];
    for (int i = 0; i < days; i++, calDay.add(Calendar.DATE, 1)) {
        calDays[i] = new EventCalendarDay(calDay);
        calDays[i].setDayOfWeek(i % 7);
        
        String cssClass;
        if (ConnectUtil.isSameDate(today, calDay)) {
            cssClass = "today";
        }
        else if (calDay.get(Calendar.YEAR) == year && calDay.get(Calendar.MONTH) == month) {
            cssClass = "this_month";
        }
        else {
            cssClass = "other_month";
        }
        calDays[i].setCssClass(cssClass);
    }
    calDay.add(Calendar.DATE, -days);
    
    int eventIndexCounter = 0;
    for (int i = 0; i < eventWrappers.length; i++) {
        //out.write(String.format("DEBUG: %1$s (%2$tc - %3$tc)<br/>", eventWrappers[i].getName(), eventWrappers[i].getCalendarBegin(), eventWrappers[i].getCalendarEnd()));
        if (putEvent(eventWrappers[i], calDays, eventIndexCounter)) {
            eventIndexCounter++;
        }
        //out.write("DEBUG: " + eventWrappers[i].getIndexFirstDay() + "<br/>");
        //out.write("DEBUG: " + eventWrappers[i].getIndexLastDay() + "<br/>");
    }

    // get localized names for days and months
    
    Locale locale = currentPage.getLanguage(false);
    
    DateFormatSymbols symbols = new DateFormatSymbols(locale);
    String[] dayNames = symbols.getWeekdays();

    
    // prepare output
    
    String tagPanelPosition = "right";
    if(currentNode.hasProperty("tagPanelPosition")){
        tagPanelPosition = currentNode.getProperty("tagPanelPosition").getString();
    }

    String divCalendarCss = "";
    

    int maxEventsInDay = 0;
    for (EventCalendarDay eventCalendarDay : calDays) {
        if (eventCalendarDay.getSize() > maxEventsInDay) {
            maxEventsInDay = eventCalendarDay.getSize();
        }
    }
    
    String styleCalendarCellHeight;
    if (maxEventsInDay < 4) {
        styleCalendarCellHeight = Integer.toString( (STRIP_SIZE + STRIP_MARGIN) * 4 + 2 ) + "px";
    }
    else {
        styleCalendarCellHeight = Integer.toString( (STRIP_SIZE + STRIP_MARGIN) * maxEventsInDay + 2 ) + "px";
    }
    

    // output calendar on page
    
    out.write("<div style='"); out.write(divCalendarCss); out.write("'>");
    out.write("<table id='"); out.write(componentName); out.write("_table' class='eventlist-calendar'");

    // show names of days
    out.write("<tr>");
    for (int day = 0; day < 7; day++) {
        out.write("<td class='day_name' id='" + componentName + "_name" + day + "'>");
        out.write(dayNames[(day + firstDayOfWeek - 1) % 7 + 1]);
        out.write("</td>");
    }
    out.write("</tr>");

    int weeks = calDays.length / 7;
    for (int week = 0; week < weeks; week++) {
        
        // show date
        out.write("<tr>");
        for (int day = 0; day < 7; day++) {
            out.write("<td class='date'>");
            out.write(Integer.toString(calDays[week * 7 + day].getDay()));
            out.write("</td>");
        }
        out.write("</tr>");

        for (EventWrapper eventWrapper : eventWrappers)
            eventWrapper.setShowThisWeek(true); // new week starts: clear flag for displaying
        
        out.write("<tr>");
        for (int day = 0; day < 7; day++) {
            int indexDate = week * 7 + day;
            out.write("<td id='");
            out.write(componentName);
            out.write('_');
            out.write("day");
            out.write(Integer.toString(indexDate));
            out.write("' class='");
            out.write(calDays[indexDate].getCssClass());
            out.write("' style='height: ");
            out.write(styleCalendarCellHeight);
            out.write("; '>");
            
            EventWrapper[] events = calDays[indexDate].getEvents();
            if (events != null) {
                int y = 0;
                for (int position = 0; position < events.length; position++) {
                    EventWrapper event = events[position];
                    if (event == null)
                        continue;
                    
                    if (!event.getShowThisWeek()) {
                        continue; // we already displayed the event this week
                    }
                    else {
                        event.setShowThisWeek(false); // avoid showing it again this week
                    }
                    
                    int span = Math.min(7 - day, event.indexLastDay - indexDate + 1);

                    int indexStart = indexDate;
                    int indexEnd   = indexDate + span - 1;
                    boolean eventStartAtStripStart = event.indexFirstDay == indexStart;
                    boolean eventEndsAtStripEnd    = event.indexLastDay == indexEnd;
                    
                    String cssClassStripStart = eventStartAtStripStart ? " calendar_strip_start" : "";
                    String cssClassStripEnd   = eventEndsAtStripEnd ? " calendar_strip_end" : "";
                    String cssClassStripColor = CSS_CLASS_COLORS[ event.getEventIndex() % CSS_CLASS_COLORS.length ];
                    String cssClassStripSpan  = " calendar_strip_span_" + span;

                    String styleMarginTop = Integer.toString( (STRIP_MARGIN + STRIP_SIZE) * position + 1 ); 
                    
					String eventName = xssUtilService.encodeForHTMLAttr(event.getName());
                    //out.write("Event: `" + eventName + "`");
                    String eventNamePopup = eventName  + ": " + ConnectUtil.getLocalizedCalendarSpanString(event.getCalendarBegin(), event.getCalendarEnd(), locale);
                    Session session = currentNode.getSession();
                    String preview = xssUtilService.getValidJSToken(request.getParameter("preview"));
                    
                    //out.write("preview " + preview);
                    String eventPageUrl = ContentUtils.buildEventPagePath("landing", event.event, null, session, campaignId, preview, isIndependentCQInstance, buildCatalogUsingConnectServer, currentPage);

                    %><div <%
                      %>class='calendar_strip<%=cssClassStripStart%><%=cssClassStripEnd%><%=cssClassStripColor%><%=cssClassStripSpan%>' <%
                      %>style='margin-top: <%=styleMarginTop%>px; height: <%=STRIP_SIZE%>px;'><%
                        %><a <%
                          %>href='#' <%
                          %>onclick="window.location.href='<%=eventPageUrl%>'; return false;" <%
                          %>title='<%=eventNamePopup%>'><%
                            %><cq:text value="<%=eventName%>" /><%
                        %></a><%
                    %></div><%
                }
            }
            
            out.write("</td>");
        }
        out.write("</tr>");
    }
    
    out.write("</table>");
    out.write("</div>");
%>
<script type="text/javascript">
$CQ("#currentMonth_<%=componentName%>").text( "<%= String.format("%1$s %2$d", symbols.getMonths()[month % 12], year) %>" );
var calendarWidth = document.getElementById("<%=componentName%>_table").offsetWidth;
var cellWidth = calendarWidth / 7.01;
var padding = 6; <% /* 1 for border + 5 for padding */ %> 
$CQ("#<%=componentName%>_table tr td div.calendar_strip")
    .each( function() {
        var w = cellWidth - padding;
        if ($CQ(this).hasClass("calendar_strip_span_2"))
            w = 2 * cellWidth - padding;
        else if ($CQ(this).hasClass("calendar_strip_span_3"))
            w = 3 * cellWidth - padding;
        else if ($CQ(this).hasClass("calendar_strip_span_4"))
            w = 4 * cellWidth - padding;
        else if ($CQ(this).hasClass("calendar_strip_span_5"))
            w = 5 * cellWidth - padding;
        else if ($CQ(this).hasClass("calendar_strip_span_6"))
            w = 6 * cellWidth - padding;
        else if ($CQ(this).hasClass("calendar_strip_span_7"))
            w = 7 * cellWidth - padding;
        this.style.width = w + "px";
    } );

<%
    if (year*12+month <= today.get(Calendar.YEAR)*12 + today.get(Calendar.MONTH)) { /* Current month */
        %>
        $CQ("#prevMonth_<%=componentName%>").each(function(){this.style.display = "none";});
        $CQ("#prevMonth_<%=componentName%>_span").each(function(){this.style.display = "inline";});
        $CQ("#calendar-prev-month-id_<%=componentName%>").removeClass("calendar-prev-month-enabled");
        <%
    } else {
        %>
        $CQ("#prevMonth_<%=componentName%>").each(function(){this.style.display = "inline";});
        $CQ("#prevMonth_<%=componentName%>_span").each(function() {this.style.display = "none";});
        $CQ("#calendar-prev-month-id_<%=componentName%>").addClass("calendar-prev-month-enabled");
        <%      
    }
%>
</script>
<div class="spacer_20"></div>

