

<%--
 Get Event tag list and serialize to JSON object:
[
    {
        value: <tag id>,
        text: < tag name>
    }
]
 
An example: 
[
    {
        value: "18001",
        text: "Training"
    },
    {
        value: "18002",
        text: "Developing"
    },
    {
        value: "18003",
        text: "Testing"
    }
]
 

--%>

<%@include file="/libs/foundation/global.jsp" %>
<%@page
    import="com.adobe.connect.osgi.service.*,
    com.adobe.connect.osgi.util.*,
    com.adobe.connect.osgi.info.Tag,
    java.util.List,
    java.util.EnumSet,
    com.adobe.connect.osgi.info.TagGroupType,
    org.apache.sling.commons.json.io.JSONWriter"
%>

<%@page session="false" contentType="application/json"
    pageEncoding="utf-8"%>

<%!private static final String KEY_VALUE = "value";
    private static final String KEY_TEXT = "text";%>

<%


    APIProvider connectAPIService = null;
    try
    {
        ConnectService connectService = sling.getService(ConnectService.class);
        String connectSessionId = ConnectUtil.validateAndGetConnectSessionId(request, connectService.getConnectServerUrl());
        connectAPIService = connectService.getAPIProvider(connectSessionId);
    }
    catch(Exception exp)
    {
        throw new Exception("unable to initialize connect properties",exp);
    }

    try {
        JSONWriter json = new JSONWriter(out);  
        json.array();
		Session jcrSession = currentNode.getSession();
        Node connectInfo =  currentNode.getSession().getNode("/content/connect/connectinfo");
        boolean isIndependentCQInstance = ContentUtils.isIndependentCQInstance(jcrSession);          
        String accountId = ContentUtils.getConnectAccountId(currentNode, request, connectInfo, isIndependentCQInstance);;
        List<Tag> tagList = connectAPIService.getTagList(accountId, EnumSet.of(TagGroupType.EVENT_TAGS, TagGroupType.FEATURED_EVENT_TAGS));
        for (Tag tag : tagList) {
            json.object();    
            json.key(KEY_VALUE).value(tag.getTagId());
            json.key(KEY_TEXT).value(tag.getTagName());
            json.endObject();
        }
        json.endArray();
    } catch (Exception e) {
        response.sendError(
                HttpServletResponse.SC_INTERNAL_SERVER_ERROR, e
                        .getMessage());
    }
%>