<%--
/****************************************************************/
/*                                                              */
/* ADOBE CONFIDENTIAL                                           */
/* _ _ _ _ _ _ _ _ _ _ _ _ _                                    */
/*                                                              */
/* Copyright [2010-2011] Adobe Systems Incorporated             */
/* All Rights Reserved.                                         */
/*                                                              */
/* NOTICE: All information contained herein is, and remains the */
/* property of Adobe Systems Incorporated and its suppliers, if */
/* any. The intellectual and technical concepts contained       */
/* herein are proprietary to Adobe Systems Incorporated and its */
/* suppliers and may be covered by U.S. and Foreign Patents,    */
/* patents in process, and are protected by trade secret or     */
/* copyright law. Dissemination of this information or          */
/* reproduction of this material is strictly forbidden unless   */
/* prior written permission is obtained from Adobe Systems      */
/* Incorporated.                                                */
/*                                                              */
/****************************************************************/

  ==============================================================================
  Draws the Event Login Form.
  ==============================================================================
--%>

<%@page import="com.day.cq.wcm.api.WCMMode, com.adobe.connect.osgi.util.*, java.text.MessageFormat"%>
<%@include file="/apps/connect/common.jsp" %>

<%
// event info
EventInfo eventInfo = getEventInfo(request, currentNode, connectAPIService);

// Collecting parameters which define how the page should be rendered

// getting connectLogin and setting an activeSession param to activate the active sessoin workflow - user currently logged in AC
String connectLogin = null;
if (connectSessionId != null) {
	if (isIndependentCQInstance) {
		Map<String, Object> loggedInUser = ConnectUtil
				.getLoggedInConnectUserInfo(connectServer,
						connectSessionId);
		if (null != loggedInUser) {
			connectLogin = (String) loggedInUser.get("login");
		}
	} else {
		connectLogin = (String) request.getAttribute("connect-login");
	}	
}
boolean activeSession = connectLogin != null && connectSessionId != null;

// getting preview mode - checking whether the page should be openned in preview mode
String previewParam = xssUtilService.getValidJSToken(slingRequest.getParameter("preview"));
boolean isPreview = "true".equals(previewParam);

// getting login field - manage auto populate of login field
String loginParam = xssUtilService.encodeForHTML( slingRequest.getParameter("login") );

// is join automated - if event has password bypass and if user is not an existing user (automating is posible only for guests)
// also if specified user already is different that the one that have an active session then disable the automatic login
String isUserParam = xssUtilService.getValidJSToken(slingRequest.getParameter("is-user"));
boolean isUser = "true".equals(isUserParam);
boolean isAutomatedLogin = eventInfo != null && eventInfo.isPasswordBypass() && loginParam != null && !loginParam.isEmpty();

//disabling automatic login in case user does not have an active session and he is not a guest (password will be required)
if (isAutomatedLogin && !activeSession && isUser) {
	isAutomatedLogin = false;
}

//disabling automatic login in case diferent user is already logged in
if (isAutomatedLogin && activeSession && !loginParam.equals(xssUtilService.encodeForHTML(connectLogin))) {
	isAutomatedLogin = false;
}


// getting idpSource and socialProfile - social workflow data
// in case of automated login we need to disregard the idp-source information
String idpSource = null;
IDPSocialProfile socialProfile = null;
if (!isAutomatedLogin) {
    idpSource = xssUtilService.getValidJSToken(slingRequest.getParameter("idp-source")); 
    socialProfile = ConnectUtil.getIDPAuthData(request); 
}
// getting saml idp information
Map<String, String> samlInfo = null;
if(eventInfo != null)
	samlInfo = ConnectUtil.getSAMLIDPInformation(connectServer, null, eventInfo.getAccountId());
String scoID = null;
try{
	scoID = eventInfo.getScoId();
}catch(Exception e){}

String oktaDomain = null;
String idpURL = null;
if(samlInfo != null){
	oktaDomain = samlInfo.get("oktaDomain").toString();
 	idpURL =  samlInfo.get("idpURL").toString();
}
%>
<script>
	var oktadomain = "<%= oktaDomain %>";
    var oktaloginurl= "<%= idpURL %>" ;
    function redirectIDPServer(){
        var loginName = $("input[name=login]").val();
        if(oktadomain != "null"){
            if(loginName.indexOf(oktadomain) !== -1){
				var scoID= <%= scoID %>;
                var relayState='{"action":"EVENT_LOGIN","scoID":'+scoID.toString()+'}';
                window.location = makeSSOLoginUrl(oktaloginurl, relayState);
                return false;
            }
		}
        return true;
    }
	
	// function to construct sso login url based on template
	function makeSSOLoginUrl(oktaLoginURL, relayState ){
			var ssoLoginUrl = "";
			if(oktaLoginURL.indexOf('{$') == -1){
				ssoLoginUrl = makeDefaultSSOLoginUrl(oktaLoginURL, relayState);
			}        
			else
				ssoLoginUrl = oktaLoginURL.replace("{$RELAYSTATE}", encodeURIComponent(relayState));
			return ssoLoginUrl;
	}
	
	function makeDefaultSSOLoginUrl (oktaLoginURL, relayState){
		var ssoLoginUrl = "";
		if(oktaLoginURL.indexOf('?') == -1)
			ssoLoginUrl = oktaLoginURL + "?RelayState=" + encodeURIComponent(relayState);
		else
			ssoLoginUrl = oktaLoginURL + "&RelayState=" + encodeURIComponent(relayState);
		return ssoLoginUrl;
	}
</script>

<c:set var="loginPreview" value="<%= isPreview %>"/>
<c:set var="login" value="<%= loginParam %>"/>
<c:set var="isUser" value="<%= isUser %>"/>
<c:set var="password" value="<%= slingRequest.getParameter("password") != null ? xssUtilService.encodeForHTML(slingRequest.getParameter("password")) : "" %>"/>
<c:set var="eventInfo" value="<%= getEventInfo(request, currentNode, connectAPIService) %>"/>
<c:set var="inputLabelCSS" value="<%= ContentUtils.getCSSStyle(properties, "lbl", isIndependentCQInstance) %>"/>
<c:set var="errTextCSS" value="<%= ContentUtils.getCSSStyle(properties, "err", isIndependentCQInstance) %>"/>
<c:set var="notesTextCSS" value="<%= ContentUtils.getCSSStyle(properties, "notes", isIndependentCQInstance) %>"/>
<c:set var="idpError" value="<%= slingRequest.getParameter("idp-error") != null ? eventResBundle.getString(ConnectUtil.escapeHtml(xssUtilService.encodeForHTML(slingRequest.getParameter("idp-error")))) : "" %>"/>
<c:set var="msg" value="<%= slingRequest.getParameter("msg") != null ? eventResBundle.getString(ConnectUtil.escapeHtml(xssUtilService.encodeForHTML(slingRequest.getParameter("msg")))) : "" %>"/>
<c:set var="idpAuth" value="<%= xssUtilService.getValidJSToken(slingRequest.getParameter("idp-auth"))%>"/>
<c:set var="connectSessionId" value="<%= connectSessionId %>"/>   

<c:choose>
        <c:when test="${not empty eventInfo}">
            <c:choose>
                <c:when test="${eventInfo.name == null}">    
                    <div class="event_reg_info_err_msg" ${errTextCSS}><%= eventResBundle.getString("eventNotPublished") %></div>
                </c:when>
                <c:when test="${eventInfo.eventStatus == 'cancelled'}">
                    <div class="event_reg_info_err_msg" ${errTextCSS}><%= eventResBundle.getString("errMsgEventCancelled") %></div>
                </c:when>
                <c:otherwise>
                    <c:set var="tooLateLogin" value="<%= LoginAvailability.TOO_LATE %>"/>
                    <c:set var="tooEarlyLogin" value="<%= LoginAvailability.NOT_STARTED %>"/>
                    <% if (WCMMode.fromRequest(request) != WCMMode.DISABLED) { %>
                    	<c:set var="loginAvailability" value="<%= LoginAvailability.CAN_JOIN %>"/>
                    <% } else { %>
                        <c:set var="loginAvailability" value="<%= ConnectUtil.eventLoginAvailability((EventInfo)pageContext.getAttribute("eventInfo")) %>"/>
					 <% } %>
                    <c:set var="beginDateCal" value="<%= ConnectUtil.parseDate(((EventInfo)pageContext.getAttribute("eventInfo")).getBeginDate()) %>"/>
                    <c:set var="beginDate" value="<%= ConnectUtil.getLocalizedCalendarString(((Calendar)pageContext.getAttribute("beginDateCal")), new Locale(pageLanguagePreference)) %>"/>

                    <c:choose>
                       <c:when test="${tooLateLogin == loginAvailability}">
                           <div class="event_reg_info_err_msg" ${errTextCSS}><%= eventResBundle.getString("tooLateRegistration") %></div>                  
                       </c:when>
                       <c:when test="${idpAuth == 'true' and connectSessionId != null and loginPreview != 'true'}">
                           <script>
                               window.location.href = '<%= eventInfo.getDomainName() + eventInfo.getUrlPath() %>';
                            </script>  
                       </c:when> 
                       <c:when test="${tooEarlyLogin == loginAvailability}">
                           <div class="event_reg_info_err_msg" ${errTextCSS}><%= eventResBundle.getString("tooEarlyLogin") %> <c:out value="${beginDate}" /></div>
                       </c:when>
                       <c:otherwise>            
                            <%-- forgot password form --%>
                            <div id="eventResetPwdContainer" class="container"></div>
                
                            <%-- login form --%>
                            <div id="eventLoginContainer" class="container">                                
                                <c:choose>
                                    <c:when test="${eventInfo.ended}">
                                        <div class="event_reg_info_msg" ${notesTextCSS}><%= eventResBundle.getString("errMsgEventEnded") %></div>
                                    </c:when>                                            
                                    <c:otherwise>
                                        <div class="event_reg_info_msg" ${notesTextCSS}>
                                        	<%
                                        	String templatePath = currentPage.getPath().substring(0, currentPage.getPath().lastIndexOf("/"));
                                        	if (connectLogin != null && isPreview == false) {
                                        		
                                        		// getting logout link                                        		
                                        		String logPageUrl = ContentUtils.buildEventPagePath("login", eventInfo, templatePath, currentNode.getSession(), xssUtilService.filter(request.getParameter("campaign-id")), xssUtilService.getValidJSToken(request.getParameter("preview")), isIndependentCQInstance, false, currentPage);
                                        		if (idpSource != null) {
                                        			logPageUrl = logPageUrl + "&idp-source=" + idpSource;
                                        		}
                                        		String logoutLink;
                                        		if ( isIndependentCQInstance ) {
                                        		    logoutLink = "<a href=\"javascript: logoutConnect(true);\">" + eventResBundle.getString("logout") + "</a>";
                                        		} else {
                                        		    logoutLink = ConnectUtil.getLogoutLink(slingRequest, request, logPageUrl, connectServer, eventResBundle);
                                        		}
                                        		%> <%= MessageFormat.format (eventResBundle.getString("loggedInAsUserLoginPage"), connectLogin, logoutLink ) %> <%
                                        	} else {	                                            
                                        		  String regPageUrl;
                                                  if (isPreview == false) {                                             
                                                      regPageUrl = ContentUtils.buildEventPagePath("registration", eventInfo, templatePath, currentNode.getSession(), xssUtilService.filter(request.getParameter("campaign-id")), xssUtilService.getValidJSToken(request.getParameter("preview")), isIndependentCQInstance, false, currentPage);
                                                  } else {
                                                      regPageUrl = "javascript:void(0);";
                                                  }
												%> <%= MessageFormat.format (eventResBundle.getString("eventLoginHeader"), regPageUrl) %> <%	                                            
                                       		}
                                            %>
                                            
                                        </div>
                                        
                                        <div style="clear:both"></div>
                                        
                                        <c:choose>
                                        	<%-- ACTIVE SESSION WORKFLOW: USER IS LOGGEDIN IN AC - DISPLAY JOIN BUTTON AND LOGOUT LINK --%>
                                            <c:when test="<%= activeSession == true && isPreview == false %>">
                                            	 <div class="event_login_form" style="float:left;width:100%">
                                                
                                                 <div id="activeSessionErrMsg" class="event_reg_info_err_msg" ${errTextCSS}>${msg}</div>
                                                 <div class="event_login_form"> 
                                                     <a id="submitActiveSessionLoginFormLink" class="roundCornerButtonLink" href="<%= eventInfo.getDomainName() + eventInfo.getUrlPath() %>">
                                                         <span class="leftBtnImg">&nbsp;</span>
                                                         <span class="centerBtnImg">
                                                             <div style="vertical-align: middle; padding-top: 4px;">
															    <% 
																if (eventInfo.getEventCategory().equals(Event.EventCategory.ONDEMAND)) 
																{
																%>
																<%=	eventResBundle.getString("viewBtnLbl") %> 
																<%
																}
																else 
																{
																%>
																<%= eventResBundle.getString("joinEventBtnLbl") %>        
																<%
																}
																%>
                                                             </div>
                                                         </span>
                                                         <span class="rightBtnImg">&nbsp;</span>
                                                     </a> 
                                                 </div>
                                                 <div style="clear:both"></div>
                                               
                                             </div>         
                                            </c:when>
                                            <%-- END STANDARD WORKFLOW ACTIVE SESSION: USER IS LOGGEDIN IN AC - DISPLAY JOIN BUTTON AND LOGOUT LINK --%>
                                        
                                       		<%-- SOCIAL WORKFLOW1: SOCIAL PROFILE RETRIEVED - SHOW PICTURE AND JOIN BUTTON --%>
                                            <c:when test="<%= socialProfile != null && isPreview == false %>">
                                             <%                                              
                                             String idpLoginUrl = eventInfo.getDomainName() + eventInfo.getUrlPath() + "event/login.html?idp-auth=true&idp-action=login-user&idp-provider=" + socialProfile.getAttribute("idp-source") + "&event-id=" + eventInfo.getScoId();
                                             if (idpSource != null && !idpSource.isEmpty()){
                                                 idpLoginUrl = idpLoginUrl + "&idp-source=" + idpSource;
                                             }
                                             %>
                                                                                              
                                             <div class="event_login_form_top" style="float:left;width:100%">  
                                                 
                                                 <div class="event_login_form">  
													<%     
														String name = socialProfile.getAttribute("first-name") + " " + socialProfile.getAttribute("last-name");
													 	// making name not wrappable
										              	name = name.replaceAll(" ", "&nbsp;");
														String email = socialProfile.getAttribute("email");
														String social = socialProfile.getAttribute("idp-source").toLowerCase();
														String socialLink = "https://" + social + ".com";
														String socialFriendly = social.substring(0,1).toUpperCase() + social.substring(1);
													%>                 
									                <% if (socialProfile.containsAttribute("picture")) { %>     
									                     <div style="width:100%;overflow: auto;">   
									                        <div style="float:left;padding-right: 10px;overflow: auto;">
									                             <a href="<%=socialLink%>">
									                           		<img src="<%=socialProfile.getAttribute("picture")%>" width="50px" height="50px" style="border: none" >
									                         	 </a>
									                        </div>
									                        <div class="event_reg_info_msg" style="margin-top:5px;">
									                            <a style="text-decoration:none;" href="<%=socialLink%>"><span class="social_username"> <%=name%> </span> </a> 
									                        </div>
									                    </div>               
									                <% } else { %>
									                   <div class="event_reg_info_msg" style="width:100%;">
									                         <%= eventResBundle.getString("eventRegistrationIDPLoggedInAsUser")%> <a style="text-decoration:none;" href="<%=socialLink%>"><span class="social_username"> <%=name%> </span> </a>
									                   </div>									                   
									                <% } %>               
									                <div style="clear:both"></div>   
									                <div class="event_reg_info_msg not_you_msg">
									                    <%= MessageFormat.format ( eventResBundle.getString("incorrectIDPUser"), socialLink, socialFriendly, ConnectUtil.removeQueryParameter(slingRequest, "idp-data", socialProfile.getIdpData()))%>                    
									                </div>										   
                                                     
                                                 </div>                                            
                                                 
                                                 <%-- message error handling --%>
                                                 <c:if test="${idpError != ''}">                                                 
                                                     <div class="event_login_form" style="width:60%;">                 
                                                         <span id="idpErrorMsg" class="event_reg_info_err_msg" ${errTextCSS}>${idpError}</span>                                                 
                                                     </div>
                                                 </c:if>
                                                 <div class="event_login_form"> 
                                                     <a id="submitRegistrationFormLink" class="roundCornerButtonLink" href="<%= idpLoginUrl%>">
                                                         <span class="leftBtnImg">&nbsp;</span>
                                                         <span class="centerBtnImg">
                                                             <div style="vertical-align: middle; padding-top: 4px;">
															    <% 
																if (eventInfo.getEventCategory().equals(Event.EventCategory.ONDEMAND)) 
																{
																%>
																<%=	eventResBundle.getString("viewBtnLbl") %> 
																<%
																}
																else 
																{
																%>
																<%= eventResBundle.getString("joinEventBtnLbl") %>        
																<%
																}
																%>
                                                             </div>
                                                         </span>
                                                         <span class="rightBtnImg">&nbsp;</span>
                                                     </a> 
                                                 </div>
                                                 <div style="clear:both"></div>
                                                
                                             </div>         
                                            </c:when>
                                            <%-- END SOCIAL WORKFLOW1: SOCIAL PROFILE RETRIEVED - SHOW PICTURE AND JOIN BUTTON --%>
                                            
                                            <%-- SOCIAL WORKFLOW2: IDP SOURCE ACTIVED - SHOW APPROPRIATE SOCIAL OPTION --%>
                                            <c:when test="<%=idpSource != null && isPreview == false %>">
                                                <%
                                                String idpAuthUrl = eventInfo.getDomainName() + eventInfo.getUrlPath() + "event/login.html?idp-auth=true&idp-action=get-user-profile&idp-provider=" + idpSource + "&idp-source=" + idpSource; 
                                                String idpSourceCSSFriendly = idpSource.trim().toLowerCase();
                                                %>
                                                <div class="event_login_form_top" style="float:left;">  
                                                     <span class="event_reg_info_msg" ${notesTextCSS}><%= eventResBundle.getString("eventLoginWithIDPFull") %></span>                                                     
                                                      
                                                     <div style="margin-top:10px;">                                                             
                                                         <div class="event_reg_info_msg" ${notesTextCSS}>              
                                                             <a class="event_sso_link <%="event_sso_link_" + idpSourceCSSFriendly%>" href="<%= idpAuthUrl%>"></a>
                                                         </div>
                                                     </div>                                                          
                                                     <div style="clear:both; margin-bottom:25px"></div>
                                                     
                                                     <div class="event_login_form" style="width:60%;">  <%// need to remove idp-source param %>                                                              
                                                         <span class="event_reg_info_msg" ${notesTextCSS}><%= MessageFormat.format( eventResBundle.getString("eventIDPLoginFooter"), ConnectUtil.removeQueryParameter(slingRequest, "idp-source", idpSource) ) %></span>
                                                     </div>
                                                 </div>  
                                            </c:when>
                                            <%-- END SOCIAL WORKFLOW2: IDP SOURCE ACTIVED - SHOW APPROPRIATE SOCIAL OPTION --%>
                                            
                                            <%-- STANDARD LOGIN WORKFLOW: SHOW LOGIN&PASSWORD FIELDS --%>
                                            <c:otherwise>
                                                <div class="event_login_form_top" style="float:left;width:275px;">                                                   
                                                <span class="event_reg_info_msg" ${notesTextCSS}><%= eventResBundle.getString("eventLoginWithEmail") %></span>
                                            
                                                    <div class="event_login_form">      
                                                        <form name="loginForm" action="" method="post" onsubmit="return false;">
                                                           <c:choose>      
                                                                 <c:when test="${eventInfo.passwordBypass or eventInfo.loginIsEmail}"> 
                                                                    <div class="event_reg_label" ${inputLabelCSS}><%= eventResBundle.getString("emailAddress") %>:</div>
                                                                    <input type="hidden" name="loginIsEmail" id="loginIsEmail" value="true" /> 
                                                                    <input id="loginField" type="text" id="loginField" onblur="redirectIDPServer()" name="login" value="${login}" class="event_reg_field" /> 
                                                                 </c:when>                                                
                                                                 <c:otherwise>
                                                                    <div class="event_reg_label" ${inputLabelCSS}><%= eventResBundle.getString("loginLabel") %></div>
                                                                    <input id="loginField" type="text" id="loginField"  name="login" value="${login}" class="event_reg_field" />
                                                                 </c:otherwise>
                                                            </c:choose>   
                                                            <br/><span id="loginField_errorMessage" class="error_msg_registration"></span>
                                                            
                                                             <c:if test="${(not eventInfo.passwordBypass) or isUser}">
                                                                <div class="event_reg_label" ${inputLabelCSS}><%= eventResBundle.getString("passwordLabel") %></div>
                                                                <input id="passwordField" type="password" name="password" value="${password}" class="event_reg_field" /> 
                                                                <br/><span id="passwordField_errorMessage" class="error_msg_registration"></span>
                                                            </c:if>
                                                            
                                                            
                                                             <c:if test="${isUser }">
                                                                <input id="isUserField" type="hidden" name="is-user" value=""/>
                                                             </c:if>
                                                            
                                                            <%-- message error handling --%>                
                                                            <br>
                                                            <div id="errorMsg" class="event_reg_info_err_msg" ${errTextCSS}>${msg}</div>      
                                                            <div id="loading" class="event_reg_info_msg" ${notesTextCSS}><%= eventResBundle.getString("eventLoginLoggingIn") %></div>
                                                            
                                                            <br>
                                                            
                                                            <a id="loginBtn-eventlogin" class="roundCornerButtonLink" href="javascript:">
                                                                <span class="leftBtnImg">&nbsp;</span>
                                                                <span class="centerBtnImg">
                                                                    <div style="vertical-align: middle; padding-top: 4px;"><%= eventResBundle.getString("loginBtnLabel") %></div>
                                                                </span>
                                                                <span class="rightBtnImg">&nbsp;</span>
                                                            </a>
                                                            <div style="clear: both;">&nbsp;</div>
                                                   
                                                            <c:choose>         
                                                                <c:when test="${(not eventInfo.passwordBypass) or isUser}">                                 
                                                                    <div class="event_reg_info_msg" ${notesTextCSS}><a id="eventForgotPwdLink" href="javascript:void(0);"><%= eventResBundle.getString("eventForgotPassword") %></a></div>                                   
                                                                </c:when>
                                                            </c:choose>
                                                        </form>
                                                    </div>
                                                </div>
                                            
                                            </c:otherwise>
                                            <%-- END STANDARD LOGIN WORKFLOW: SHOW LOGIN&PASSWORD FIELDS --%>
                                        </c:choose>                                                                       
                                        
                                       
                                      <%@include file="idpLink.jsp" %>
                                      
                                      <div style="clear:both"></div>
                                      
                                    </c:otherwise>
                                </c:choose>    
                                        
                                                         
                            </div>
                            <script type="text/javascript">
                                var curr_page_url = "<%= eventInfo.getDomainName() + eventInfo.getLoginURL() %>";
                                var isAutomatedLogin = <%= isAutomatedLogin %>;
                                var isActiveSession = <%= activeSession %>;
                                $CQ(document).ready(function() {
                                    initEventLogin('${eventInfo.scoId}', '${loginPreview}', '${resource.path}');     
                               		
                                    // loginAutomatically will only auto-click the appropraite link - if link does not exist then no action will be undertaken
                                    if (isAutomatedLogin){
                                        
                                        if (isActiveSession) {
                                            loginAutomatically("#submitActiveSessionLoginFormLink");
                                        } else {
                                            loginAutomatically("#loginBtn-eventlogin");
                                        }
                                       
                                    }          
                                });
                            </script>
                         </c:otherwise>
                      </c:choose>
                </c:otherwise>
            </c:choose>
                          
        </c:when>
        <c:otherwise>
            <%-- in case eventId is missing write an empty string in publish mode and custom message in author mode  --%>
            <c:choose>
                <c:when test="<%= WCMMode.fromRequest(request) != WCMMode.DISABLED %>">
                    <div class="event_reg_label" ${inputLabelCSS}><%= eventResBundle.getString("eventLoginEventIdMissing") %></div>
                </c:when>
                <c:otherwise>
                    <div class="event_reg_label" ${inputLabelCSS}></div>
                </c:otherwise>
            </c:choose>
        </c:otherwise>
</c:choose>
