
if (CQ.form) {
CQ.form.rte.plugins.ConfirmMsgVariablePlugin = CQ.Ext.extend(CQ.form.rte.plugins.Plugin, {

    cachedVariables: null,

    variablesUI: null,

    constructor: function(editorKernel) {
        CQ.form.rte.plugins.ConfirmMsgVariablePlugin.superclass.constructor.call(this, editorKernel);
    },

    getFeatures: function() {
        return [ "variables" ];
    },

    getVariables: function() {
        var com = CQ.form.rte.Common;
        if (!this.cachedVariables) {
            this.cachedVariables = this.config.variables || { };
            com.removeJcrData(this.cachedVariables);
        }
        return this.cachedVariables;
    },

    initializeUI: function(tbGenerator) {
        var plg = CQ.form.rte.plugins;
        var ui = CQ.form.rte.ui;
        if (this.isFeatureEnabled("confirmmsgvariable")) {
            this.variablesUI = new ui.ConfirmMsgVariableSelector("confirmmsgvariable", this, null, this.getVariables());
            tbGenerator.addElement("confirmmsgvariable", plg.Plugin.SORT_STYLES, this.variablesUI, 10);
        }
    },

    notifyPluginConfig: function(pluginConfig) {
        pluginConfig = pluginConfig || { };
        CQ.Util.applyDefaults(pluginConfig, {
            "variables": {
                // empty default value
            }
        });
        this.config = pluginConfig;
    },

    execute: function(cmdId) {
        if (!this.variablesUI) {
            return;
        }
        var cmd = null;
        var value = null;
        switch (cmdId.toLowerCase()) {
            case "confirmmsgvariable_insert":
                cmd = "inserthtml";
                value = this.variablesUI.getSelectedVariable();
                break;
        }
        if (cmd && value) {
            var vt = "{"+value+"}";
            //var html = "<span class=\"cq-variable cq-variable-code cq-variable-vars-"+value+"\" title=\""+vt+"\">"+vt+"</span>&nbsp;";
            this.editorKernel.relayCmd(cmd, vt);
        }
    }
});

// register plugin
CQ.form.rte.plugins.PluginRegistry.register("confirmmsgvariable", CQ.form.rte.plugins.ConfirmMsgVariablePlugin);
}