
function validateReg(form)
{
	var validationPassed = true;
	for(i=0; i<form.elements.length; i++) 
	{
		var validationElemPassed = triggerChange(form.elements[i]);
		if (!validationElemPassed) 
		{
			validationPassed = false;
		}
	}
	
	if (validationPassed==true)
	{
		validationPassed = repasswordValidation(form);
	}
	
	return validationPassed;
}

function triggerChange(field){
	var returnValue = $CQ(field).triggerHandler('change');
	if ( (returnValue == null) // chrome, opera, safari
			  || (returnValue == undefined) ) 
	{
		returnValue = true;
	}
	return returnValue;
}

function validate(field, isRequired, validationType) 
{
	//1st check: Are required fields present
	var validationPassed = true;
	
	if ((field.id==='first-name' || field.id==='last-name')
		&& (document.getElementById("firstLastName_errorMessage")!=null))
	{
		document.getElementById("firstLastName_errorMessage").innerHTML='';
	}
	
	if (isRequired == true)
	{
		validationPassed = validateRequired(field);
	} 
	else
	{
		if ((field.type!="text" && field.type!="password") || field.value.trim()=="")
		{
			var elementName = field.id + '_errorMessage';
			if (document.getElementById(elementName))
			{
				document.getElementById(elementName).innerHTML='';
			}
			setErrorStyle(field, false);
			return true;
		}
	}
	
	//if required field is empty error must be reported
	if (validationPassed == false)
	{
		return validationPassed;
	}
	
	if (field.type=="text" || field.type=="password")
	{
		switch(validationType)
		{
			case "email-interaction": validationPassed = emailValidation(field); break;
			case "password-interaction": validationPassed = passwordValidation(field); break;
			case "numeric-interaction": validationPassed = numericValidation(field); break;
			case "text-interaction": validationPassed = textValidation(field); break;
			case "url-interaction": validationPassed = urlValidation(field); break;
			case "phone-number-interaction": validationPassed = phoneValidation(field); break;
			default: break;
		}
	}
	
	return validationPassed;
}

function validateFirstLastName()
{
	var firstNameField = document.getElementById("first-name");
	var lastNameField = document.getElementById("last-name");

	var msg = eventResBundle.getMessage("eventRegistrationNameLength");
	var length = 0;
	
	if (firstNameField!=null)
	{
		length = length + firstNameField.value.length;
	}
	
	if (lastNameField!=null)
	{
		length = length + lastNameField.value.length;
	}
	
	if (length > 59)
	{
		document.getElementById("firstLastName_errorMessage").innerHTML=' '+msg+' ';
		return false;
	}
	
	document.getElementById("firstLastName_errorMessage").innerHTML=' ';
	return true;
}


function regReset()
{
	var elementName = null;
	var form = document.getElementById("eventReg");
    for(i=0; i<form.elements.length; i++)
    {
    	if (form.elements[i].readOnly == true)
    		continue;
    	
    	if (form.elements[i].type=="radio")
    	{
    		elementName = form.elements[i].name + '_errorMessage';
    	}
    	//hidden field is used for unchecked checkbox and has same name as checkbox
    	else if (form.elements[i].type=="checkbox" || form.elements[i].type=="hidden")
    	{
    		elementName = form.elements[i].name + '_errorMessage';
    	}
    	else
    	{
    		elementName = form.elements[i].id + '_errorMessage';
    	}
        if (document.getElementById(elementName)) 
        {
        	setErrorStyle(form.elements[i], false);
        	
        	if (form.elements[i].type=="select-one")
        	{
        		var myList = form.elements[i];
        		form.elements[i].selectedIndex = 0;
        	} 
        	else if (form.elements[i].type=="radio")
        	{
        		var elems = document.getElementsByName(form.elements[i].name);
        		form.elements[i].checked = false; 
        	}
        	//enable of disable checkbox based on prechecked value
        	else if (form.elements[i].type=="checkbox")
        	{
        		if (form.elements[i].getAttribute("prechecked")=="true")
        		{
            		form.elements[i].checked = true; 
        		}
        		else
        		{
            		form.elements[i].checked = false; 
        		}
        	} 
        	//disable hidden field if prechecked true, otherwise enable 
        	//used for checked/unchecked checkbox
        	else if (form.elements[i].type=="hidden")
        	{
        		if (form.elements[i].getAttribute("prechecked")=="true")
        		{
            		form.elements[i].disabled = true; 
        		}
        		else
        		{
            		form.elements[i].disabled = false; 
        		}
        	}
        	else if (! form.elements[i].disabled)  
        	{
        		form.elements[i].value='';
        	}
        	//reset _errorMessage
        	document.getElementById(elementName).innerHTML='';
        }
    }
    elementName = "errorMsg1";
    if (document.getElementById(elementName))
    {
    	document.getElementById(elementName).innerHTML='';
    }
    elementName = "errorMsg2";
    if (document.getElementById(elementName))
    {
    	document.getElementById(elementName).innerHTML='';
    }
}


// Radio Button Validation
function isCheckedButton(elems) 
{
	for (var i=elems.length-1; i > -1; i--) 
	{
		if (elems[i].checked) 
		{
			return true;
		}
	}
	return false;
}

// check if field is empty - write error message
function validateRequired(field) 
{
	var elementName = field.name +"_errorMessage";
	var iserror = false;
	if (field.type=="radio")
	{
		var isChecked = isCheckedButton(document.getElementsByName(field.name));
		if (isChecked==false)
		{
			msg = eventResBundle.getMessage('fieldRequired');
			document.getElementById(elementName).innerHTML='  '+msg+' ';
			iserror = true;
		} 
		else 
		{
			document.getElementById(elementName).innerHTML='';
			iserror = false;
		}
	} 
	else if (field.type=="checkbox") 
	{
		var isChecked = isCheckedButton(document.getElementsByName(field.name));
		if (isChecked==false)
		{
			msg = eventResBundle.getMessage('checkboxRequired');
			document.getElementById(elementName).innerHTML='  '+msg+' ';
			iserror = true;
		} 
		else 
		{
			document.getElementById(elementName).innerHTML='';
			iserror = false;
		}
	}
	else if (field.type=="text" || field.type=="password")
	{
		if ((field.type=="text" && field.value.trim()=="") || (field.type=="password" && field.value==""))  
		{
			 msg = eventResBundle.getMessage('fieldRequired');
			 document.getElementById(elementName).innerHTML='  '+msg+' ';
			 iserror = true;
		} 
		else
		{
			 document.getElementById(elementName).innerHTML='';
			 iserror = false;
		}
	} 
	else if (field.type=="select-one") 
	{
		if (field.value=="")
		{
			msg = eventResBundle.getMessage('fieldRequired');
			document.getElementById(elementName).innerHTML='  '+msg+' ';
			iserror = true;
		} 
		else
		{
			document.getElementById(elementName).innerHTML='';
			iserror = false;
		}
	}
	setErrorStyle(field, iserror);
	return !iserror;
}

// color error fields
function setErrorStyle(field, iserror) 
{
	if (iserror==true) 
	{
		field.style.borderColor = "red";
		field.style.borderWidth = "1px 1px 1px 2px";
	} 
	else 
	{
		field.style.borderColor = "";
		field.style.borderWidth = "";
	}
}



//is field numeric
function numericValidation(field)
{
	var numericPattern = /^[0-9]+$/;
	var iserror = !(numericPattern.test(field.value.trim()));
	var elementName = field.id + '_errorMessage';
	if (iserror)
	{
		msg = eventResBundle.getMessage('numericInvalid');
		document.getElementById(elementName).innerHTML='  '+msg+' ';
		iserror = true;
	} 
	else 
	{
		document.getElementById(elementName).innerHTML='';
		iserror = false;
	}
	setErrorStyle(field, iserror);
	return !iserror;
}

//is field text
function textValidation(field)
{
	var iserror = false;
	var elementName = field.id + '_errorMessage';
	
	if (field.value.length > 2048)
	{
		msg = eventResBundle.getMessage('textlengthNotValid');
		document.getElementById(elementName).innerHTML='  '+msg+' ';
		iserror = true;
	}
	else
	{
		document.getElementById(elementName).innerHTML='';
		iserror = false;
	}
	setErrorStyle(field, iserror);
	return !iserror;
}

//is field url
function urlValidation(field)
{
		var urlRegExp = /^(((ht|f)tp(s?)):\/\/)([^\t\r\n\v\f\~\!\$\%\^\&\*=\+\}\{\\'"\?\#/`\|]+\.)*[^\t\r\n\v\f\~\!\$\%\^\&\*=\+\}\{\\'"\?\#/`\|]+(:[0-9]+)?(\/\S*)?$/;
	var urlPattern = new RegExp(urlRegExp);
	var illegalChars = /[\s]/;
	
	var url = field.value.trim();
	url = url.toLowerCase();	
	
	var iserror = !(urlPattern.test(url));
	//can not contain blank
	if (!iserror)
	{
		iserror = illegalChars.test(field.value.trim());
	}
	var elementName = field.id + '_errorMessage';
	if (iserror)
	{
		msg = eventResBundle.getMessage('urlInvalid');
		document.getElementById(elementName).innerHTML='  '+msg+' ';
		iserror = true;
	} 
	else 
	{
		document.getElementById(elementName).innerHTML='';
		iserror = false;
	}
	setErrorStyle(field, iserror);
	return !iserror;
}

//is field phone
function phoneValidation(field)
{
	var phonePattern = /^[+]{0,1}\s*(\(\s*[0-9]+\s*\)\s*)?([0-9]+\s*-?\s*)*[0-9]+$/;
	var iserror = !(phonePattern.test(field.value.trim()));
	var elementName = field.id + '_errorMessage';
	if (iserror)
	{
		msg = eventResBundle.getMessage('phoneNoInvalid');
		document.getElementById(elementName).innerHTML='  '+msg+' ';
		iserror = true;
	} 
	else 
	{
		document.getElementById(elementName).innerHTML='';
		iserror = false;
	}
	setErrorStyle(field, iserror);
	return !iserror;
}

//is field password
function passwordValidation(field)
{
	return true;
}

//check if password match retype password
function repasswordValidation(form) 
{
	if (document.getElementById("password") == null || document.getElementById("password-verify") == null)
	{
		return true;
	}
	if (document.getElementById("password-verify").value == "") 
	{
		msg = eventResBundle.getMessage('fieldRequired');
		document.getElementById("password-verify_errorMessage").innerHTML='  '+msg+' ';
		iserror = true;
	} 
	else if (document.getElementById("password").value != document.getElementById("password-verify").value) 
	{
		msg = eventResBundle.getMessage('passwordsDoNotMatch');
		document.getElementById("password-verify_errorMessage").innerHTML='  '+msg+' ';
		iserror = true;
	}
	else
	{
		document.getElementById("password-verify_errorMessage").innerHTML='';
		iserror = false;
	}
	setErrorStyle(document.getElementById("password-verify"), iserror);
	return !iserror;
}

