<%@include file="/apps/connect/common.jsp" %>


<%
    String inputLabelCSS = ContentUtils.getCSSStyle(properties, "lbl", isIndependentCQInstance);
    request.setAttribute("registrationPageCSS", inputLabelCSS);
    String errTextCSS   = ContentUtils.getCSSStyle(properties, "err", isIndependentCQInstance);
    String notesTextCSS = ContentUtils.getCSSStyle(properties, "notes", isIndependentCQInstance);

    EventInfo eventInfo = getEventInfo(request, currentNode, connectAPIService);
    String eventId = eventInfo != null ? eventInfo.getScoId() : null;

    String forgotPwdPage = xssUtilService.getValidJSToken(slingRequest.getParameter("forgot-password"));
    if(forgotPwdPage == null) {
        forgotPwdPage = slingRequest.getRequestURI();
    }

%>

<div class="container">

<%
    String statusCode = (String)slingRequest.getAttribute("code");
    if("ok".equals(statusCode)) { 
        String login = xssUtilService.encodeForHTML(slingRequest.getParameter("login"));
        String passwordResetTitle = eventResBundle.getString("passwordResetTitle");
        String passwordResetPart1 = eventResBundle.getString("passwordResetPart1");
        String passwordResetPart2 = eventResBundle.getString("passwordResetPart2"); %>

        <div class="event_reg_info_msg" <%= notesTextCSS %>>
            <br/>
            <p><b><%= passwordResetTitle %></b></p>
            <br/>
            <p><%= passwordResetPart1 %></p>
            <br/>
            <div id="loginEcho" style="font-size:18px; text-weight: strong;"><%=login%></div>
            <br/>
            <p><%= passwordResetPart2 %></p>
        </div>
        <br>
        <a class="roundCornerButtonLink" onclick="window.location.href = '<%= xssUtilService.encodeForHTML(slingRequest.getParameter("login-link")) %>?sco-id=<%= eventId %>&login-ok=<%= xssUtilService.encodeForHTML(slingRequest.getParameter("login-ok")) %>';" href="javascript:">
            <span class="leftBtnImg">&nbsp;</span>
            <span class="centerBtnImg">
                <div style="vertical-align: middle; padding-top: 4px;"><%= eventResBundle.getString("returnToLogin") %></div>
            </span>
            <span class="rightBtnImg">&nbsp;</span>
        </a>
        <span style="float:left">&nbsp;&nbsp;</span>
        <% 
        String contactSupportLblField = properties.get("contactSupportLblField", "Contact Support").toString();
        String contactSupportLinkField = properties.get("contactSupportLinkField", Constants.ADOBE_SUPPORT_LINK).toString(); 
        %>
        <a class="roundCornerButtonLink" onclick="javascript: window.open('<%= contactSupportLinkField %>');" href="javascript:">
            <span class="leftBtnImg">&nbsp;</span>
            <span class="centerBtnImg">
                <div style="vertical-align: middle; padding-top: 4px;"><%= contactSupportLblField %></div>
            </span>
            <span class="rightBtnImg">&nbsp;</span>
        </a>        
        <div style="clear: both;">&nbsp;</div>  
    <%
    } else {
        // render the form
    %>
    
    <form id="forgotPwdForm" name="input" action="/content/connect/connect-action" method="post">
        <% String resetPasswordPromptTitle = eventResBundle.getString("resetPasswordPromptTitle"); %>
        <% String resetPasswordPromptMessage = eventResBundle.getString("resetPasswordPromptMessage"); %>

        <div class="event_reg_info_msg" <%= notesTextCSS %>>
            <br/>
            <p><b><%= resetPasswordPromptTitle  %></b></p>
            <br/>
            <p><%= resetPasswordPromptMessage  %></p>
        </div>
        <br>
        <input type="hidden" name="account-id" id="account-id" value="<%=getAccountId(currentNode, request, connectInfo, connectAPIService, isIndependentCQInstance) %>">
        <div class="event_reg_label" <%= inputLabelCSS %>><%= eventResBundle.getString("emailAddress") %></div>
        <input id="login" type="text" name="login" value="<%=  slingRequest.getParameter("login") != null ? xssUtilService.encodeForHTML( slingRequest.getParameter("login")) : "" %>" class="event_reg_field" onKeyPress="return checkSubmit(event, forgotPasswordSubmit)" />
        <br/><span id="login_errorMessage" class="error_msg_registration"></span>

        <%-- message error handling --%>
        <div id="errorMsg" class="event_reg_info_err_msg" <%= errTextCSS %>>
        <%
            if(statusCode != null) {
                if("invalid".equals(statusCode)) {
                    String subcode = (String)slingRequest.getAttribute("subcode");
                    if("missing".equals(subcode)) { %>
                        <%= eventResBundle.getString("eventRegistrationForgotPwdMissing") %>
                    <%
                    } else if("range".equals(subcode)) { %> 
                        <%= eventResBundle.getString("eventRegistrationForgotPwdRange") %>
                    <%
                    } else {
                        out.println(subcode);
                    }
                } else {
                    out.println(statusCode);
                }
            }
        %>
        </div>
        <br>
        <a class="roundCornerButtonLink" onclick="javascript:forgotPasswordSubmit();" href="javascript:">
            <span class="leftBtnImg">&nbsp;</span>
            <span class="centerBtnImg">
                <div style="vertical-align: middle; padding-top: 4px;"><%= eventResBundle.getString("submitButtonLabel") %></div>
            </span>
            <span class="rightBtnImg">&nbsp;</span>
        </a>
        <span style="float:left">&nbsp;&nbsp;</span>
        <a class="roundCornerButtonLink" onclick="javascript:forgotPasswordCancel('<%= xssUtilService.encodeForHTML(slingRequest.getParameter("login-link")) %>?sco-id=<%= eventId %>&login-ok=<%= xssUtilService.encodeForHTML(slingRequest.getParameter("login-ok"))%>');" href="javascript:">
            <span class="leftBtnImg">&nbsp;</span>
            <span class="centerBtnImg">
                <div style="vertical-align: middle; padding-top: 4px;"><%= eventResBundle.getString("cancelButtonLabel") %></div>
            </span>
            <span class="rightBtnImg">&nbsp;</span>
        </a> 
        <div style="clear: both;">&nbsp;</div>
        
        <input type="hidden" name="login-ok" value="<%= xssUtilService.encodeForHTML(slingRequest.getParameter("login-ok")) %>"/>
        <input type="hidden" name="login-link" value="<%= xssUtilService.encodeForHTML(slingRequest.getParameter("login-link")) %>"/>
        <input name="action" type="hidden" value="reset-password" />
        <input name="sco-id" type="hidden" value="<%= eventId %>"/>
        <input name="forgot-password" type="hidden" value="<%= forgotPwdPage %>" />
        <input name="_charset_" type="hidden" value="UTF-8" />
                
    </form>
    <script type="text/javascript"> 
        window.onload=onEventRegLoad('forgotPwdForm');
    </script>
    <%
    }
    %>
</div>
 
