<%@include file="/apps/connect/common.jsp" %>
<%@page import="com.adobe.connect.osgi.service.exception.*, java.util.Date, java.util.Calendar" %>
<%@include file="/libs/foundation/global.jsp" %>
<%
    String errTextCSS   = ContentUtils.getCSSStyle(properties, "err", isIndependentCQInstance);
    String notesTextCSS = ContentUtils.getCSSStyle(properties, "notes", isIndependentCQInstance);

    String accountId = getAccountId(currentNode, request, connectInfo, connectAPIService, isIndependentCQInstance);
    OmnitureAcountInfo omnitureAccountInfo = connectAPIService.getOmnitureAccountInfo(accountId);
    
    Map<String, Object> params = new HashMap<String, Object>();
    params.putAll(slingRequest.getParameterMap());
    
    String responseCode    = (String)slingRequest.getAttribute("code");
    String responseSubCode = (String)slingRequest.getAttribute("subcode");

    Date currentDate    = new Date();
    
    EventInfo eventInfo = getEventInfo(request, currentNode, connectAPIService);
    String eventId = eventInfo != null ? eventInfo.getScoId() : null;
    
    RegistrationAvailability registrationAvailability = ConnectUtil.eventRegistrationAvailability(eventInfo);   
    String nextRedirect = "next=" + eventInfo.getUrlPath() + "&amp;account-id=" + accountId + "&amp;sco-id=" + eventId; 
    String eventLoginURL = eventInfo.getDomainName() + "/system/event-login/login?" + nextRedirect;
    String errorRedirectURL = eventInfo.getLoginURL() + "?login-error=true";
    
    String idpSource = xssUtilService.getValidJSToken(slingRequest.getParameter("idp-source")); 
    
    String rawMessage = eventResBundle.getString("event-registration-confirm");
    
    String resolvedMsg;
    try {
        if(rawMessage.indexOf("{") == -1)
        {
            resolvedMsg = rawMessage;
        }
        else
        {
            connectSessionId = (String)slingRequest.getAttribute("BREEZESESSION");
            resolvedMsg = connectAPIService.getEventResolvedMsg(eventId, rawMessage, connectSessionId, null);
        }   
    } catch ( ConnectServiceException ex ) {
        if ( ! FailureCode.API_ERROR.equals(ex.getErrorCode()) )
        {
            throw ex;
        }
            out.write(eventResBundle.getString("errConnectingToServer"));
            return;     
    }

%>

<div style="width: 100%"> 
    <div class="event_reg_info_msg" <%= notesTextCSS %>>
<%
if (RegistrationAvailability.CAN_JOIN.equals(registrationAvailability)) { %>
        <%= eventResBundle.getString("msgRegistrationRedirect") %>
<% } else { %>
        <% 
        String registrationSuccessCustomization = properties.get("registrationSuccessCustomization", "customMessage");
        if ( "customMessage".equals(registrationSuccessCustomization) ) { %>
            <%= resolvedMsg != null ? resolvedMsg : properties.get("customMessageField", "Thank you for your registration request. Your information has been submitted to the event host. Please check your inbox for more details about this event.") %>
        <% } else { 
            if ( isIndependentCQInstance ) { %>
                <script>window.location.href = '<%= properties.get("redirectUrlField") %>.html'; </script>
            <% } else {
                String regConfirm = currentPage.getPath();
                regConfirm = regConfirm.substring(0, regConfirm.lastIndexOf("/")) + "/registration_confirm.html";
                %>
                <script>window.location.href = '<%= regConfirm %>'; </script>
            <% } %>
        <% } %>
<% } %> 
    </div>
</div>    
<br />&nbsp;<br />
<div id="resultdiv" class="event_reg_info_err_msg"></div> 
<%
if ( null != connectSessionId && RegistrationAvailability.CAN_JOIN.equals(registrationAvailability) )    
{
%>
    <script>        
        var entryUrl = '<%= eventInfo.getDomainName() + eventInfo.getUrlPath() %>';                
        window.location.href = entryUrl;
    </script>
<% 
} 
else if("ok".equals(responseCode) || "already-registered-login".equals((String)slingRequest.getAttribute("reasonfield")))
{ 
%>
        
    <% if (RegistrationAvailability.CAN_JOIN.equals(registrationAvailability)) { %>
    
    
        <%  if (idpSource != null) {
            String idpLoginUrl = eventInfo.getDomainName() + eventInfo.getUrlPath() + "event/login.html?idp-auth=true&idp-action=login-user&idp-provider=" + idpSource + "&idp-source=" + idpSource + "&event-id=" + eventInfo.getScoId();
            %>
            <script>
               window.location = "<%=idpLoginUrl%>";
            </script>

        <% } else { %>
    
            <script>
            var loginValue = "<%= xssUtilService.encodeForJSString(request.getParameter("login")) %>";
            var passwordValue = "<%= request.getParameter("password") != null ? xssUtilService.encodeForJSString(request.getParameter("password")) : "" %>";
            
            var loginReq = { login: loginValue, password: passwordValue, action: 'event-login', 'sco-id': '<%= eventId %>' };
            $CQ.post(
                    "/content/connect/connect-action", loginReq,
                    function(xml){ 
                        var code = $CQ("status", xml).attr('code');  
                        var msg1 = "", msg2 = "";                   
                        switch(code) {
                        case 'ok':
                            var eventURL = $CQ("session", xml).find("entry-url").text(); 
                            var sessionId = $CQ("session", xml).find("session").text();
                            window.location = eventURL + '?session=' + sessionId;
                            break;
                        case 'no-data':
                            var currPage = "<%= currentPage.getPath() %>";
                            var redirectUrl = currPage + ".login.html?login-ok=" + currPage + ".html&sco-id=<%= eventId  %>&login=" + loginValue;
                            window.location = redirectUrl;
                            break;
                        case 'invalid':
                            msg1 = eventResBundle.getMessage('eventLoginInvalid');
                            var subcode = $CQ("status", xml).find("invalid").attr("subcode");
                            if('missing' == subcode) {
                                field = $CQ("status", xml).find("invalid").attr("field");
                                msg2 = eventResBundle.getMessage('eventLoginMissing', [field]);
                            }
                            if('not-allowed' == subcode) {
                                var reason = $CQ("status", xml).find("invalid").attr("field");
                                if ( reason == "not-registered" ) {
                                    msg1 = eventResBundle.getMessage('errMsgNotRegistered');    
                                    $CQ("#errorMsg").html(msg1).show();  
                                } else {
                                    window.location = '<%= currentPage.getParent().getPath() + "/event_login.html?sco-id=" + eventId + "&_charset_=utf-8&is-user=true" %>';
                                    msg1 = "";
                                    msg2 = "";                                      
                                }
                            } else {
                                msg2 = makeDefaultMessage('unknownErrorSubcode', subcode);
                            }                        
                            $CQ("#resultdiv").html(msg1 + '<br>' + msg2).show();
                            break;
                        case 'no-access':
                            var subcode = $CQ("status", xml).attr("subcode");
                            if ( 'denied' == subcode ) {
                                msg1 = eventResBundle.getMessage('errMsgRegistrationDenied');
                            } else {
                                msg1 = makeDefaultMessage('unknownErrorSubcode', subcode);
                            }
                            $CQ("#resultdiv").html(msg1).show();                  
                            break;    
                        default:
                            msg1 = makeDefaultMessage('unknownErrorCode', code);
                            $CQ("#resultdiv").html(msg1).show();
                        }
                    }
            );
            </script>
         
        <% } 
    }
}
%>
                                 