<%@include file="/apps/connect/common.jsp" %>
<cq:setContentBundle/>
<%
ResourceBundle resBundle = slingRequest.getResourceBundle(null);

String eventStartTime = null;

EventInfo eventInfo = getEventInfo(slingRequest, currentNode, connectAPIService);
if (eventInfo != null) {
	String beginDateStr = eventInfo.getBeginDate();
	String eventLang = eventInfo.getLang();

	if (beginDateStr != null && beginDateStr.length() > 0 && eventLang != null && eventLang.length() > 0) {
	    Calendar beginDate = ConnectUtil.parseDate(beginDateStr);
	    beginDate.setTimeZone(getTimeZone(request));
	
	    Locale locale = new Locale(eventLang);
	            
	    // get datetime pattern
	    String dateTimePattern = null;
	    if (currentNode.hasProperty("timeFormat")) {
	        dateTimePattern = properties.get("timeFormat", "");
	    }
	            
	    eventStartTime = ConnectUtil.getLocalizedCalendarString(beginDate, dateTimePattern, locale);
	}
}

if (eventStartTime == null) {
	eventStartTime = resBundle.getString("defaultBeginDate");
}

String style = ContentUtils.getCSSStyle(properties, isIndependentCQInstance);
%>

<div class="event_time" <%= style %>><%= eventStartTime %></div>