<%--
/****************************************************************/
/*                                                              */
/* ADOBE CONFIDENTIAL                                           */
/* _ _ _ _ _ _ _ _ _ _ _ _ _                                    */
/*                                                              */
/* Copyright [2010-2011] Adobe Systems Incorporated             */
/* All Rights Reserved.                                         */
/*                                                              */
/* NOTICE: All information contained herein is, and remains the */
/* property of Adobe Systems Incorporated and its suppliers, if */
/* any. The intellectual and technical concepts contained       */
/* herein are proprietary to Adobe Systems Incorporated and its */
/* suppliers and may be covered by U.S. and Foreign Patents,    */
/* patents in process, and are protected by trade secret or     */
/* copyright law. Dissemination of this information or          */
/* reproduction of this material is strictly forbidden unless   */
/* prior written permission is obtained from Adobe Systems      */
/* Incorporated.                                                */
/*                                                              */
/****************************************************************/

  ==============================================================================
  Default content script.
  Draws the HTML content.
  ==============================================================================
--%>
<%@include file="/apps/connect/common.jsp" %>
<%
String acceptLanguageHeader = request.getHeader("Accept-Language");
if ( null == acceptLanguageHeader ) {
	acceptLanguageHeader = "en-us";
}
String locale = acceptLanguageHeader.split(",", 2)[0];
String componentName = xssUtilService.getValidJSToken(request.getParameter("component"));   
Session session      = currentNode.getSession();
String helpPathNode  = connectInfo.getProperty("sites").getString() + "/system/helplinks";
String helpPath;
if ( session.nodeExists(helpPathNode + "/" + componentName) ) 
{
    helpPath = session.getNode(helpPathNode + "/" + componentName).getProperty("sling:message").getString();
}
else
{
    helpPath = session.getNode(helpPathNode).getProperty("default").getString();
}

String helpServer  = session.getNode(helpPathNode).getProperty("server").getString();
if ( null == helpServer || "".equals(helpServer) ) {
    helpServer  = session.getNode("/content/connect/c1/jcr:content").getProperty("helpHost").getString();
    locale = locale.toLowerCase();
    if ( null == helpServer || "".equals(helpServer) ) {
        helpServer = session.getNode("/content/connect/c1/jcr:content").getProperty("serverUrl").getString() + "/common/help/";        
        if ( ! "pt-br".equals(locale) && ! "zh-cn".equals(locale) ) {
            locale = locale.split("-", 2)[0];
        }        
        if ( ! ( "en".equals(locale) || "de".equals(locale) || "es".equals(locale) || "fr".equals(locale) || "it".equals(locale) || "ja".equals(locale) || "ko".equals(locale) || "nl".equals(locale) || "pt-br".equals(locale) || "ru".equals(locale)|| "tr".equals(locale)|| "zh-cn".equals(locale) ) ) {
            locale = "en";
        }
    }
    else
    {        
        locale = locale.replace("-", "_");
        if ( locale == null || "".equals(locale) ) {
            locale = "en_US";
        }
        
        String[] langVariants = locale.split("_");
        if ( langVariants.length >= 2 ) {
            locale = langVariants[0].toLowerCase() + "_" + langVariants[1].toUpperCase();
        }
    }
}
else 
{
    locale = locale.replace("-", "_");
    if ( locale == null || "".equals(locale) ) {
        locale = "en_US";
    }
}

helpServer = (helpServer.startsWith("http:") || helpServer.startsWith("https:")) ? helpServer : ("http://" + helpServer);
String redirectUrl   = helpServer + (helpServer.endsWith("/") ? "" : "/") + locale + "/" + helpPath;
response.sendRedirect(redirectUrl); 
%>