<%@include file="/apps/connect/common.jsp"%>
<%!
String getBtnImageLoc ( Node currentNode, String btnStyle, String location ) throws Exception
{
    String imagePath = null, img = location + "image/file";
    if ( "plain".equals(btnStyle) )
        return null;
    else if ( "round".equals(btnStyle) )
        imagePath = "/etc/designs/connect/images/" + location + "img_imgbtn.png";
    else if ( "roundarrow".equals(btnStyle) )
    {
        if ( "right".equals(location) )
            location = "rightarrow";
        
        imagePath = "/etc/designs/connect/images/" + location + "img_imgbtn.png";
    }
    else if ( "custom".equals(btnStyle) && currentNode.hasNode(img) )
        imagePath = currentNode.getPath() + "/" + img;
    
    return imagePath;
}

String getButtonImageCSS(Node currentNode, String btnStyle, String btnHeight, String location) throws Exception
{   
    String imagePath = getBtnImageLoc ( currentNode, btnStyle, location );
    String style = "vertical-align: middle; float:left; height: " + btnHeight + "px;";  
    if ( ! "center".equals(location) ) 
        style += "width: 20px; background: url(" + imagePath + ") no-repeat"; 
    else
        style += "background: url(" + imagePath + ") repeat-x";
    
    style = "style=\"" + style + "\"";
    return style;
}


String getLink(EventInfo eventInfo, String templatePath, boolean isIndependentCQInstance, Node currentNode, HttpServletRequest request, ValueMap properties, Node connectInfo, String accountId, Page currentPage) throws Exception
{
    String link        = properties.get("link",    "external");
    String extLink     = properties.get("relLink", "");
    if ( "external".equals(link) ) 
        return extLink;
    
    String linkPage = "";
    if ( "catalog".equals(link) )
    {
        linkPage = connectInfo.getProperty("sites").getString() + "/c1/" + accountId + "/" + connectInfo.getProperty("catalogRelativePath").getString() + "catalog.html";
    }
    else
    {
		XSSUtilService xssUtilService = (com.adobe.connect.osgi.util.XSSUtilService)request.getAttribute(XSSUtilService); 
    	String campaignId = request.getParameter("campaign-id");
		if(campaignId != null){			
              campaignId = ConnectUtil.customUrlEncode(xssUtilService.filter(campaignId));
        }
		String preview = xssUtilService.getValidJSToken(request.getParameter("preview"));
    	Session session = currentNode.getSession();    	
    	linkPage = ContentUtils.buildEventPagePath(link, eventInfo, templatePath, session, campaignId, preview, isIndependentCQInstance, false, currentPage);
    }
    return linkPage;
}
%>

<%
EventInfo eventInfo = getEventInfo(request, currentNode, connectAPIService);
String eventId = eventInfo != null ? eventInfo.getScoId() : null;
String accountId = getAccountId(currentNode, request, connectInfo, connectAPIService, isIndependentCQInstance);
String templatePath = currentPage.getPath().substring(0, currentPage.getPath().lastIndexOf("/"));               

String label       = properties.get("label",        "Button");
String btnStyle    = properties.get("style",        "round");
String btnHeight   = properties.get("btnHeight",    "");
String disableFontProperties = ContentUtils.getDefaultDisableFontProperties(properties, isIndependentCQInstance);
String style = "";
if (currentNode!=null && "custom".equalsIgnoreCase(disableFontProperties)) {
	StringBuffer styleBuffer = new StringBuffer("style=\"");
    if(currentNode.hasProperty("fontSize") ) { 
        styleBuffer.append("font-size: ");
        styleBuffer.append(properties.get("fontSize", ""));
        styleBuffer.append(";");
    }
    if (currentNode.hasProperty("fontColor")) { 
        styleBuffer.append("color: #");
        styleBuffer.append(properties.get("fontColor", ""));
        styleBuffer.append(";");
    }
    if (currentNode.hasProperty("fontFamily")) { 
        styleBuffer.append("font-family: ");
        styleBuffer.append(properties.get("fontFamily", ""));
        styleBuffer.append(";");
    }
    if (currentNode.hasProperty("fontStyle")) { 
        styleBuffer.append("font-style: ");
        styleBuffer.append(properties.get("fontStyle", ""));
        styleBuffer.append(";");
    }
    if (currentNode.hasProperty("fontWeight")) { 
        styleBuffer.append("font-weight: ");
        styleBuffer.append(properties.get("fontWeight", ""));
        styleBuffer.append("px;");
    }
    if (currentNode.hasProperty("btnHeight")) { 
        styleBuffer.append("height: ");
        styleBuffer.append(properties.get("btnHeight", ""));
        styleBuffer.append("px;");
    }
    if (currentNode.hasProperty("textDecoration")) { 
        styleBuffer.append("text-decoration: ");
        styleBuffer.append(properties.get("textDecoration", ""));
        styleBuffer.append(";");
    }
    styleBuffer.append("vertical-align: middle;");
    styleBuffer.append("\"");
    style = styleBuffer.toString();
}    

%>

<% if ( "plain".equals(btnStyle) ) { %>

    <input <%= style %> type="button" onclick="javascript: window.location.href = '<%= getLink(eventInfo, templatePath, isIndependentCQInstance, currentNode, request, properties, connectInfo, accountId, currentPage) %>';" value="<%= label %>" />
    
<% } else { %>    
    <a href="<%= getLink(eventInfo, templatePath, isIndependentCQInstance, currentNode, request, properties, connectInfo, accountId, currentPage) %>" <%= style %>  class="linkbuttonHref"> 
        <span class="linkbutton leftBtnImg" <%= getButtonImageCSS(currentNode, btnStyle, btnHeight, "left") %>>&nbsp;</span>
        <span class="linkbutton centerBtnImg" <%= getButtonImageCSS(currentNode, btnStyle, btnHeight, "center") %>><span <%= style %>><%= label %></span></span>
        <span class="linkbutton rightBtnImg" <%= getButtonImageCSS(currentNode, btnStyle, btnHeight, "right") %>>&nbsp;</span>        
    </a>
    <div style="clear:both">&nbsp;</div>

<% } %>