/*
 * Left menu component configuration.
 */
(function($) {
    $(function () {
        
        //collapse all nested menu items
        //$("#connect-event-leftnav > li a + ul").slideUp(1);
        
        // Expand or collapse:
        $("#connect-event-leftnav li a").click(function() {
            $(this).parent().parent().find("> ul").slideToggle("fast");
        });
        
        //highlight menu items on click
        var items = $("#connect-event-leftnav li span").not(".connect-leftnav-item-group");
        
        items.children("a").click ( function() {
            var link = $(this);
            //parent span element to set background color
            var parent = link.parent();
            if (!parent.is('.connect-leftnav-active')) {
                items.removeClass('connect-leftnav-active');
                parent.addClass('connect-leftnav-active');
            }
        });
        
        // build Event Management link
        
        $("#eventMgmtLink").click(function(e){
        	e.preventDefault();
        	$.get(
            		"/content/connect/connect-action",
            		{action: "sco-shortcuts"},
            		function(xml){
            			
            			var eventMgmtLink = $("#eventMgmtLink").attr('href');
            			
            			var code = $("status", xml).attr('code');
            			if(code == 'ok') {
            				var myEventsScoId, sharedEventsScoId;
            				$(xml).find('sco').each(function(){
            					if($(this).attr('type') == 'my-events') {
            						myEventsScoId = $(this).attr('sco-id');
            						return false;
            					}
								
								if($(this).attr('type') == 'events') {
            						sharedEventsScoId = $(this).attr('sco-id');
            						return false;
            					}
            				});
            				 
            				var ampersandOrQuestionMark;
							if(eventMgmtLink.indexOf('?') != -1)
								ampersandOrQuestionMark = '&';
							else
								ampersandOrQuestionMark = '?';
							if(myEventsScoId) {
        						eventMgmtLink = eventMgmtLink + ampersandOrQuestionMark + 'filter-rows=100&filter-start=0&sco-id=' + myEventsScoId + '&tab-id=' + myEventsScoId;
            				} else if(sharedEventsScoId) {
								eventMgmtLink = eventMgmtLink + ampersandOrQuestionMark + 'filter-rows=100&filter-start=0&sco-id=' + sharedEventsScoId + '&tab-id=' + sharedEventsScoId;
							}
            				window.location = eventMgmtLink;
            				
            			} else {
            				window.location = eventMgmtLink;
            			}
            		}
            );
        });
        
    });
})($CQ || $);