<%@include file="/apps/connect/common.jsp" %>
<%@ page import="com.day.cq.commons.Doctype,
        com.day.cq.wcm.api.PageFilter,
        com.day.cq.wcm.foundation.Navigation,        
        com.day.text.Text" %>
<%@ page import="com.day.text.Text" %>
<cq:setContentBundle/> 

        
<%
Session session = resource.getResourceResolver().adaptTo(Session.class);
String home = "/content/connect/c1/" + getAccountId(currentNode, request, connectInfo, connectAPIService, isIndependentCQInstance) + "/en"; // e.g. /content/connect/microsites/c1/7/en 

String eventManagementLink= connectServer + "/admin/event/folder/list";
if(cqSessionParameterString != null){
	eventManagementLink = eventManagementLink + "?" + cqSessionParameterString;
}

String catalogPageLink = home + "/events/catalog.html";
boolean hasCatalogModifyPermission = ContentUtils.hasPermission(session, home + "/events/catalog", "set_property");
boolean hasUserPrivateEmailFolderModifyPermission = ContentUtils.hasPermission(session, home + "/events/email/private", "set_property");
boolean hasUserPrivateEventFolderModifyPermission = ContentUtils.hasPermission(session, home + "/events/event/private", "set_property");


String eventMyTemplatesLink = home + "/events/event/private";
String eventSharedTemplatesLink = home + "/events/event/shared.html";
String emailMyTemplatesLink = home + "/events/email/private";  
String emailSharedTemplatesLink = home + "/events/email/shared.html";  

String principalId = (String)request.getAttribute("principal-id");
if(principalId == null) {
    //show message that user is not logged in when opening "My Templates" 
    eventMyTemplatesLink = eventMyTemplatesLink + ".html";
    emailMyTemplatesLink = emailMyTemplatesLink + ".html";
} else {
    //Session session = currentNode.getSession();
    
    //check if private node exists
    String eventPrivateNode = eventMyTemplatesLink + "/" + principalId;
    if(session.nodeExists(eventPrivateNode )){
        eventMyTemplatesLink = eventPrivateNode + ".html";
    }
    
    String emailPrivateNode = emailMyTemplatesLink + "/" + principalId;
    if(session.nodeExists(emailPrivateNode)){
        emailMyTemplatesLink = emailPrivateNode + ".html";
    }
}

//highlight menu item after page reload - determine menu item depending on loaded page.
String highlightCatalog = ""; 
String highlightEventMyTemplates = "";
String highlightEventUserTemplates = "";
String highlightEventSharedTemplates = "";
String highlightEmailMyTemplates = "";
String highlightEmailUserTemplates = "";
String highlightEmailSharedTemplates = "";
final String highlightCssClass = "connect-leftnav-active";
String currPagePath = currentPage.getPath();

if(currPagePath.indexOf("/event/private/" + principalId) > 0){
    highlightEventMyTemplates = highlightCssClass;
} else if(currPagePath.indexOf("/event/private") > 0){
    highlightEventUserTemplates = highlightCssClass;
} else if(currPagePath.indexOf("/event/shared") > 0){
    highlightEventSharedTemplates = highlightCssClass;
} else if(currPagePath.indexOf("/email/private/" + principalId) > 0){
    highlightEmailMyTemplates = highlightCssClass;
} else if(currPagePath.indexOf("/email/private") > 0){
    highlightEmailUserTemplates = highlightCssClass;
} else if(currPagePath.indexOf("/email/shared") > 0){
    highlightEmailSharedTemplates = highlightCssClass;
} else if(currPagePath.indexOf("/catalog") > 0){
    //search for templates before checking catalog because 
    //user can create template which name can start with catalog 
    //TODO: should we look for /en/catalog instead? 
    highlightCatalog = highlightCssClass;
}

Boolean hasEmailPrivateFolder = (Boolean)request.getAttribute("hasEmailPrivateFolder");
Boolean hasEventPrivateFolder = (Boolean)request.getAttribute("hasEventPrivateFolder");
%>

<cq:setContentBundle/>  

<div class="connect-leftnav">

        <ul id="connect-event-leftnav">
            <li><span><a id="eventMgmtLink" href="<%=eventManagementLink %>"><%= eventResBundle.getString("menuEventManagement") %></a></span></li>
            <% if(hasCatalogModifyPermission) { %>
                <li><span class="<%=highlightCatalog%>"><a href="<%=catalogPageLink%>"><%= eventResBundle.getString("menuCatalog") %></a></span></li>
            <% } %>
            <li><span class="connect-leftnav-item-group"><a href="#"><%= eventResBundle.getString("menuEventTemplates") %></a></span>
                <ul>
                    <% if ( hasEventPrivateFolder ) { %>
                        <li><span class="<%=highlightEventMyTemplates%>"><a href="<%=eventMyTemplatesLink%>"><%= eventResBundle.getString("menuMyTemplates") %></a></span></li>
                    <% } %>
                    <% if ( hasUserPrivateEventFolderModifyPermission ) { %>
                        <li><span class="<%=highlightEventUserTemplates%>"><a href="<%=home + "/events/event/private.html"%>"><%= eventResBundle.getString("titleUserTemplates") %></a></span></li>
                    <% } %>
                    <li><span class="<%=highlightEventSharedTemplates%>"><a href="<%=eventSharedTemplatesLink%>"><%= eventResBundle.getString("menuSharedTemplates") %></a></span></li>
                </ul>
            </li>
            <li><span class="connect-leftnav-item-group"><a href="#"><%= eventResBundle.getString("menuEmailTemplates") %></a></span> 
                <ul>
                    <% if ( hasEmailPrivateFolder ) { %>
                        <li><span class="<%=highlightEmailMyTemplates%>"><a href="<%=emailMyTemplatesLink%>"><%= eventResBundle.getString("menuEmailMyTemplates") %></a></span></li>
                    <% } %>
                    <% if ( hasUserPrivateEmailFolderModifyPermission ) { %>
                        <li><span class="<%=highlightEmailUserTemplates%>"><a href="<%=home + "/events/email/private.html"%>"><%= eventResBundle.getString("titleUserTemplates") %></a></span></li>
                    <% } %>
                    <li><span class="<%=highlightEmailSharedTemplates%>"><a href="<%=emailSharedTemplatesLink%>"><%= eventResBundle.getString("menuEmailSharedTemplates") %></a></span></li>
                </ul>
            </li>
        </ul>
</div>