<%--
  Copyright 1997-2010 Day Management AG
  Barfuesserplatz 6, 4001 Basel, Switzerland
  All Rights Reserved.

  This software is the confidential and proprietary information of
  Day Management AG, ("Confidential Information"). You shall not
  disclose such Confidential Information and shall use it only in
  accordance with the terms of the license agreement you entered into
  with Day.

  ==============================================================================

  Default head script.

  Draws the HTML head with some default content:
  - includes the WCML init script
  - includes the head libs script
  - includes the favicons
  - sets the HTML title
  - sets some meta data

  ==============================================================================

--%>
<%@include file="/apps/connect/common.jsp" %>
<%@include file="checkRedirect.jsp" %>





    
    

<%
%><%@ page import="com.day.cq.commons.Doctype,
				   java.util.Date,
                   java.util.GregorianCalendar,
				   com.day.cq.wcm.api.WCMMode,
                   org.apache.commons.lang.StringEscapeUtils" %><%
    String xs = Doctype.isXHTML(request) ? "/" : "";
    String favIcon = currentDesign.getPath() + "/favicon.ico";
    if (resourceResolver.getResource(favIcon) == null) {
        favIcon = null;
    }
%><head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"<%=xs%>>
    <meta http-equiv="keywords" content="<%= StringEscapeUtils.escapeHtml(WCMUtils.getKeywords(currentPage, false)) %>"<%=xs%>>
    <meta http-equiv="description" content="<%= StringEscapeUtils.escapeHtml(properties.get("jcr:description", "")) %>"<%=xs%>>
	
	<cq:includeClientLib categories="cq.clientlibrarymanager"/>
    <script>
    CQClientLibraryManager.setChannelCB(function(){
        return "";        
    });  
    CQClientLibraryManager.setChannelCB = function() { };
    </script>   
	
    <cq:include script="headlibs.jsp"/>
    
    <% if (favIcon != null) { %>
    <link rel="icon" type="image/vnd.microsoft.icon" href="<%= favIcon %>"<%=xs%>>
    <link rel="shortcut icon" type="image/vnd.microsoft.icon" href="<%= favIcon %>"<%=xs%>>
    <% } %>
    <cq:include script="head_title.jsp"/>
    
	
	<%@include file="/apps/connect/custom_scripts.jsp" %>
	
	
	<%
	if (WCMMode.fromRequest(request) != WCMMode.DISABLED) 
	{
		GregorianCalendar lastModifiedCal   = (GregorianCalendar)properties.get("cq:lastModified");
		GregorianCalendar lastReplicatedCal = (GregorianCalendar)properties.get("cq:lastReplicated");
		if ( lastModifiedCal != null && lastReplicatedCal != null )
		{
			Date lastModified   = ((GregorianCalendar)properties.get("cq:lastModified")).getTime();
			Date lastReplicated = ((GregorianCalendar)properties.get("cq:lastReplicated")).getTime();
			if ( lastModified.after(lastReplicated) ) { %>            
				<script>
				CQ.Ext.onReady(function(){
					CQ.Notification.notify(eventResBundle.getMessage("titleActivateTemplate"), eventResBundle.getMessage("infoMsgTemplateEdited"));
					}); 
				</script>
			<% } 
		 } 
	} %>
</head>
