<%--
/****************************************************************/
/*                                                              */
/* ADOBE CONFIDENTIAL                                           */
/* _ _ _ _ _ _ _ _ _ _ _ _ _                                    */
/*                                                              */
/* Copyright [2010-2011] Adobe Systems Incorporated             */
/* All Rights Reserved.                                         */
/*                                                              */
/* NOTICE: All information contained herein is, and remains the */
/* property of Adobe Systems Incorporated and its suppliers, if */
/* any. The intellectual and technical concepts contained       */
/* herein are proprietary to Adobe Systems Incorporated and its */
/* suppliers and may be covered by U.S. and Foreign Patents,    */
/* patents in process, and are protected by trade secret or     */
/* copyright law. Dissemination of this information or          */
/* reproduction of this material is strictly forbidden unless   */
/* prior written permission is obtained from Adobe Systems      */
/* Incorporated.                                                */
/*                                                              */
/****************************************************************/

  ==============================================================================
  Header script.
  Draws the top header of the page
  ==============================================================================
--%>

  <%!
String getMicrositeRoot(String sites, String currentPath){
    
        if (currentPath.length() > sites.length()
                && currentPath.startsWith(sites)) {
            String remaining = currentPath.substring(sites.length());

            if (remaining.startsWith("/")) {
                remaining = remaining.substring(1);
            }


            String[] arr = remaining.split("/");
            if (arr.length >= 2)
            {
            
                //return arr[1];
                return sites+ "/" + arr[0] + "/" + arr[1];
                
            }
            
        }
        return null;
}

%>


<%!

String getTemplateFolderType(String siteRoot, String currentPath){
    
        if (siteRoot != null && currentPath.length() > siteRoot.length()
                && currentPath.startsWith(siteRoot)) {
            String remaining = currentPath.substring(siteRoot.length());

            if (remaining.startsWith("/")) {
                remaining = remaining.substring(1);
            }

            String[] arr = remaining.split("/");
            if (arr.length >= 3)
                return arr[2];
        }
        return null;
}

%>

    <%@include file="/apps/connect/common.jsp" %>
    
    
  
    
    <%

//Node connectInfo =  currentNode.getSession().getNode("/content/connect/connectinfo");

String sitesRoot = connectInfo.getProperty("sites").getString();

//take out the microsite root
//String micrositeRoot = "/content/connect/microsites/c1/" + getMicrositeRoot(sitesRoot, currentPage.getPath());

String micrositeRoot = getMicrositeRoot(sitesRoot, currentPage.getPath());

String templateType = getTemplateFolderType(micrositeRoot, currentPage.getPath());

String templateId = null;
try {
	if ( "email".equals(templateType) ) {
		templateId = currentNode.getParent().getNode("jcr:content").getProperty("templateId").getString();
	} else {
	    templateId = currentNode.getParent().getParent().getNode("jcr:content").getProperty("templateId").getString();
	}
} catch ( Exception e ) { }

%>

<script type="text/javascript">

var CQTemplateType = "<%=templateType %>" 
var CQMicrositeRoot = "<%=micrositeRoot%>"
var CQTemplateId = "<%=templateId%>"
</script>

    
    <%@include file="init.jsp" %>
    
    <%
    String foreGroundStyle = "";
    String foregroundColor =  properties.get("foregroundColor", "");
    if ( ! "".equals(foregroundColor) )
        foreGroundStyle += "background-color: #" + foregroundColor + "; ";

    foreGroundStyle = "style=\"" + foreGroundStyle + "\"";
    %>

    <%if (currentPage.getName().equals("catalog")) { %>

        <div class="header_wide" <%= foreGroundStyle %>>
            <cq:include path="header" resourceType="foundation/components/parsys"/>
        </div>

    <% } %>
    