<%--


  ==============================================================================

  connect pages init script (copy from /libs/wcm/core/components/init/init.jsp).

  Draws the initialization code. This is called by the head.jsp
  of the page. If the WCM is disabled, no output is written.

  ==============================================================================

--%>

<%@include file="/libs/foundation/global.jsp" %><%
%>




<%@page import="com.day.cq.wcm.api.WCMMode" %>


<%

if (WCMMode.fromRequest(request) != WCMMode.DISABLED) {
    String dlgPath = null;
    if (editContext != null && editContext.getComponent() != null) {
        dlgPath = editContext.getComponent().getDialogPath();
    }   
    
    String sharedFolderPath  = getTemplateFolderPath(connectInfo.getProperty("sites").getString(), (String)request.getAttribute("principal-id"), ContentUtils.getConnectAccountId(currentNode, request, connectInfo, isIndependentCQInstance), "email", "shared");
    String privateFolderPath = getTemplateFolderPath(connectInfo.getProperty("sites").getString(), (String)request.getAttribute("principal-id"), ContentUtils.getConnectAccountId(currentNode, request, connectInfo, isIndependentCQInstance), "email", "private");
    Boolean isEventAdmin     = hasWriteAccess(currentNode.getSession().getNode(sharedFolderPath), currentNode.getSession());
    Boolean isEventHost      = currentNode.getSession().nodeExists(privateFolderPath);
    %>
    
    <cq:includeClientLib categories="cq.wcm.edit" />
    <script type="text/javascript">
    var dialog;
    var resetDialog;
    
    /* START - Code for 'Page Background' button in sidekick. */    
    var pagebackgroundComponentBtn = {
            "text": CQ.I18n.getMessage("titlePageProperties"),
            "handler": function() {
               var contentWindow = CQ.utils.WCM.getContentWindow();
               pagebgDialogPath = "/apps/connect/components/page/dialog";
               var pagebgDialogConfig = contentWindow.CQ.WCM.getDialogConfig(pagebgDialogPath);
               if ( CQTemplateType == "email" ) {
                   pagebgDialogConfig.items.items.splice(1,1);   
               }               
               pageDialog = contentWindow.CQ.WCM.getDialog(pagebgDialogConfig, pagebgDialogPath);
               pageDialog.loadContent(this.getPath() + "/jcr:content");
               pageDialog.formUrl = "";                       
               pageDialog.success = function() { window.location.reload(true); } 
               pageDialog.setTitle(CQ.I18n.getMessage("titlePageBackgroundColor"));            
               pageDialog.show();                                                                  
            },
            "context": [
                        CQ.wcm.Sidekick.PAGE
            ]
     };
     /* END   - Code for 'Page Background' button in sidekick. */
     
     
    /* Start - Code for 'Activate Page' button in sidekick. */
     var customPublishPage = {
             "text": CQ.I18n.getMessage("titleActivateTemplate"),
             "handler": function() {
                    var publishPagePath = this.getPath();                    
                    CQ.Ext.Msg.confirm ( CQ.I18n.getMessage("titleActivateTemplate"), CQ.I18n.getMessage("confirmationMessagePageActivation"), function(btn){                                                   
                            if(btn === 'yes'){
                                var toActivate = [], totalActivated = 0;                                
                                if ( CQTemplateType == "event" )
                                {
                                    <% String thisTemplateRootPath = (currentPage != null && currentPage.getParent() != null) ? (currentPage.getParent().getPath() + "/") : ""; %>
                                    toActivate.push('<%= thisTemplateRootPath + "event_landing" %>');
                                    toActivate.push('<%= thisTemplateRootPath + "speaker_info" %>');
                                    toActivate.push('<%= thisTemplateRootPath + "event_registration" %>');
                                    toActivate.push('<%= thisTemplateRootPath + "event_login" %>');
                                    toActivate.push('<%= thisTemplateRootPath + "registration_confirm" %>');
                                }
                                else
                                {
                                    toActivate.push('<%= (currentPage != null) ? currentPage.getPath() : "" %>');
                                }

                                for ( var i = 0 ; i < toActivate.length ; i ++ ) {
                                    CQ.wcm.SiteAdmin.internalActivatePage(toActivate[i], function(options, success, response) {                                                                        
                                        if (success) {
                                            totalActivated ++;
                                            if ( totalActivated == toActivate.length )
                                                CQ.Notification.notify(CQ.I18n.getMessage("titleActivateTemplate"), CQ.I18n.getMessage("infoMsgPageActivated"));
                                        } else {
                                            CQ.Notification.notifyFromResponse(response);
                                        }
                                    });
                                }
                            }  
                    });
             }
     };
     /* END   - Code for 'Activate Page' button in sidekick. */
     
    /* Start - Code for 'Create a new Template' button in sidekick */
    var createNewTemplate = {
       text: CQ.I18n.getMessage("titleCreateNewTemplate"),
       handler: function(b, e , skPath) {
             
           var path;
           if(skPath != undefined && skPath != null) {
                path = skPath;
           } else {
                path = this.getPath();                  
           }
                   
           var templateType = CQTemplateType;
                 
           var httpProxy = new CQ.Ext.data.HttpProxy({ "url":"/content/connect/connect-action?action=list-templates&template-type=" + templateType, "method":"GET" });
                
           httpProxy.on("exception", function() {
               CQ.Notification.notify(CQ.I18n.getMessage("labelError"), CQ.I18n.getMessage("errorMsgTemplateListLoadingFail") );
           });
    
           var selectedValue = "", destPathOptions = [];
           <%                       
           if ( isEventAdmin ) { %> 
               destPathOptions.push({text: CQ.I18n.getMessage("labelSharedAccess"), value: "shared"});
               selectedValue = "shared";                    
           <% } %>                
           
           <%           
           if ( isEventHost ) { %>    
               destPathOptions.push({text: CQ.I18n.getMessage("labelPrivateAccess"), value: "private"});
               selectedValue = "private";
           <% } %>

           if ( destPathOptions.length == 2 )
               selectedValue = path.indexOf("/event/private") > 0 || path.indexOf("/email/private") > 0 ? 'private' : 'shared';
           
           //data provider for thetemplate list 
           var templatesStore = new CQ.Ext.data.Store({
               "proxy": httpProxy,
               "reader": new CQ.Ext.data.XmlReader(
               {
                   record: "cq-template",
                   path: "path"//,
                   
               },
               [
                   {name: 'name', mapping: 'name'},     // "mapping" property not needed if it's the same as "name"
                   {name: 'path'},                 // This field will use "occupation" as the mapping.
                   {name: 'display-name'},
                   {name: 'lang'}
               ] 
                       
               )

           });

           templatesStore.on ( "load", function(me, records, options) {                       
               for ( var i = 0 ; i < records.length ; i ++ ) 
               {                   
                   records[i].set("name", URLDecode(records[i].get("name")));
                   records[i].set("path", URLDecode(records[i].get("path")));
                   var lang = records[i].get("lang");
                   var dispName = URLDecode(records[i].get("display-name"));                     
                   if(lang == "system") {                       
                       dispName = eventResBundle.getMessage(dispName) + " (" + eventResBundle.getMessage("system") + ")";                      
                   } else if ( null != lang && lang.trim() != "" ) {                       
                       var locDict = CQ.utils.I18n.getDictionary(lang);
                       if (locDict) {                          
                           dispName = locDict[dispName];
                       } else {
                           dispName = eventResBundle.getMessage(dispName);
                       }                       
                   }
                   records[i].set("display-name", dispName);
               }                                             
           });
                              
                                                
           var dataView = new CQ.Ext.DataView({
               "id": "pathList",
               "multiSelect": false,
               "singleSelect": true,
               "emptyText": CQ.I18n.getMessage("noteNoTemplateAvailable"),
               "store": templatesStore,
               "overClass": "x-view-over",
               "itemSelector" :"div.template-item",
               
               "tpl":new CQ.Ext.XTemplate(
                   '<tpl for=".">',
                   '<div class="template-item">',
                   
                   '<div class="template-title">{display-name}</div>',
                   '<div class="template-description">{path}</div>',
                   
                   '<div style="clear:both"></div>',
                   '</div>',
                   '</tpl>',
                   '<div style="height:5px;overflow:hidden"></div>')
           });
            
           var createDialog = {
               "jcr:primaryType": "cq:Dialog",
               "id": CQ.Util.createId("cq-createdialog"),
               "title":CQ.I18n.getMessage("labelCreateTemplate"),
               "formUrl":"",
               "params": {
                   "cmd":"createPage",
                   "_charset_":"utf-8"
               },
               "height": 520,
               "items": {
                   "jcr:primaryType": "cq:Panel",
                   "items": {
                       "jcr:primaryType": "cq:WidgetCollection",
                       /*"title": {
                           "fieldLabel":CQ.I18n.getMessage("labelTemplateDisplayName"),
                           "allowBlank":false,
                           "name":"title",
                           "maxLength": "60",
                           "regex": new RegExp("^[a-zA-Z0-9_]+$"),
                           "regexText" :  CQ.I18n.getMessage("infoMsgDisplayNameFormat")
                       },*/
                       "label": {
                           "fieldLabel":CQ.I18n.getMessage("labelTemplateName"),
                           "vtype":"name",
                           "allowBlank":false,
                           "name":"label",
                           "maxLength": "60"                           
                       },

                       "access": {
                           "xtype": "selection",
                           "type": "select",                                   
                           "fieldLabel": CQ.I18n.getMessage("Access"),                                
                           "name":"destFolder",                                
                           "value": selectedValue,   
                           "defaultValue": selectedValue,
                           "options": destPathOptions
                       },
                      
                       "template": {
                           "xtype": "panel",
                           "title":CQ.I18n.getMessage("noteSelectTemplate"),
                           "border": false,
                           "cls": "cq-template-view",
                           "autoScroll":true,
                           "width": "100%",
                           "autoHeight":false,
                           "height": 350,
                           "items": [
                               
                               dataView
                           ]
                           
                           ,"listeners": {
                               "render" : {
                                   fn: function() {
                                       templatesStore.load();
                                       
                                   }
                               }
                           }
                       }
                   }
               },
               "okText":CQ.I18n.getMessage("labelCreate")
           };
    
           if(dialog == undefined)                  
               dialog = CQ.WCM.getDialog(createDialog);
        
           dialog.on("beforesubmit", function() {
            
               //var displayName = this.getField( "title" ).getValue();           
               var name = this.getField( "label" ).getValue();
               if(this.findById("pathList").getSelectedRecords()[0] == undefined)
               {
                   CQ.Notification.notify(CQ.I18n.getMessage("labelError"), CQ.I18n.getMessage("noteSelectTemplate") );
                   
               } 
               var selectedPath = this.findById("pathList").getSelectedRecords()[0].data;
               var access = this.getField("destFolder").getValue();
                   
               var templateType = CQTemplateType;
               var micrositeRoot = CQMicrositeRoot;

               if(templateType == "email"){
                       showWaitingBar(true);
                       CQ.HTTP.get("/content/connect/connect-action" + 
                       "?action=create-email-template"+
                       "&name="+encodeURIComponent(name)+
                       "&src-path="+ encodeURIComponent(selectedPath.path) +
                       "&microsite-root-path=" + escape(micrositeRoot)+
                       "&display-name="+ encodeURIComponent(name) + 
                       "&_charset_=utf-8"+
                       "&template-access="+ escape(access), 
    
                           function(options, success, response) {
                            showWaitingBar(false);
                            if(success) {
                                CQ.Notification.notify(CQ.I18n.getMessage("labelInfo"), CQ.I18n.getMessage("infoMsgTemplateCreated") );    
     
                                var redirectTo = decodeURIComponent(response.getResponseHeader('redirect-to-template'));                                
                                var currentLocation = window.location;
                                if (redirectTo != undefined){
                                    var paramsIndex = currentLocation.href.lastIndexOf("?");
                                    if(paramsIndex != -1) redirectTo = redirectTo + currentLocation.href.substring(paramsIndex);
                                     
                                    setTimeout("window.location = '" + redirectTo + "';", 2000);
                                 }
                            } else {
                                    if ( response.status == 403 && response.statusText == "Forbidden" && response.responseXML == null)
                                    {
                                        window.location.reload();
                                    }
                                    
                                   txt = response.responseText
                                   if (window.DOMParser) 
                                   {
                                         parser=new DOMParser();
                                         xmlDoc=parser.parseFromString(txt,"text/xml");
                                   }
                                   else // Internet Explorer
                                   {
                                         xmlDoc=new ActiveXObject("Microsoft.XMLDOM");
                                         xmlDoc.async="false";
                                         xmlDoc.loadXML(txt);
                                   }
                                     
                                   var errorMessage = xmlDoc.getElementsByTagName("status")[0].childNodes[0].nodeValue;
                                   if(errorMessage == "login-error" )
                                   {
                                   window.location.reload();//it will take care of the relogin 
                                   } 
                                   else
                                   {
                                       CQ.Ext.Msg.alert(CQ.I18n.getMessage("labelError"),  CQ.I18n.getMessage(errorMessage ));
                                   }
                               
                               
                              }
                           });
               
                }
                else if(templateType == "event")
                {           
                       showWaitingBar(true);           
                       CQ.HTTP.get("/content/connect/connect-action" + 
                        "?action=create-event-template"+
                        "&name="+encodeURIComponent(name)+
                        "&src-path="+ encodeURIComponent(selectedPath.path) +
                        "&microsite-root-path=" + escape(micrositeRoot)+
                        "&display-name="+ encodeURIComponent(name)+
                        "&_charset_=utf-8"+
                        "&template-access="+ escape(access), 
                       
                           function(options, success, response) { 
                            showWaitingBar(false);                      
                            if(success) {
                               CQ.Notification.notify(CQ.I18n.getMessage("labelInfo"), CQ.I18n.getMessage("infoMsgTemplateCreated") );
                               var redirectTo = decodeURIComponent(response.getResponseHeader('redirect-to-template'));                                  
                               var currentLocation = window.location;
                               if (redirectTo != undefined){
                                        var paramsIndex = currentLocation.href.lastIndexOf("?");
                                        if(paramsIndex != -1) redirectTo = redirectTo + currentLocation.href.substring(paramsIndex);
                                         
                                        setTimeout("window.location = '" + redirectTo + "';", 2000);
                               }
                                
                            }
                            else
                            {
                                    if ( response.status == 403 && response.statusText == "Forbidden" && response.responseXML == null)
                                    {
                                        window.location.reload();
                                    }
                                    
                                   txt = response.responseText
                                   if (window.DOMParser)
                                   {
                                         parser=new DOMParser();
                                         xmlDoc=parser.parseFromString(txt,"text/xml");
                                   }
                                   else // Internet Explorer
                                   {
                                         xmlDoc=new ActiveXObject("Microsoft.XMLDOM");
                                         xmlDoc.async="false";
                                         xmlDoc.loadXML(txt);
                                   }
                                     
                                   var errorMessage = xmlDoc.getElementsByTagName("status")[0].childNodes[0].nodeValue;
                                   if(errorMessage == "login-error" )
                                   {
                                        window.location.reload();//it will take care of the relogin 
                                   }
                                   else
                                   {
                                       CQ.Ext.Msg.alert(CQ.I18n.getMessage("labelError"),  CQ.I18n.getMessage(errorMessage ));
                                   }
                               
                               }
                           });
               }
    
               var field21 = this.getField( "label" );
                    
           });
                        
           dialog.show();
                                                   
        }
     };
    /* End - Code for 'Create a new Template' button in sidekick */
    
    /* Start - Code for 'Copy a Template' button in sidekick */
    var copyTemplate = {
             text: CQ.I18n.getMessage("titleCreateTemplateCopy"),
             handler: function(b, e , skPath) {
             
                var path;
                if(skPath != undefined && skPath != null) {
                    path = skPath;
                } else {
                    path = this.getPath();                  
                }
                
                var templateType = CQTemplateType;                
                var templateNode = path;
                if(templateType == "email")
                {
                    var to = path.substring(0, path.lastIndexOf("/"));
                    var label = "CopyOf" + path.substring(path.lastIndexOf("/") + 1);
                }
                else if(templateType == "event")
                {
                    templateNode = path.substring(0, path.lastIndexOf("/"));
                }               

                var selectedValue = "", destPathOptions = [];
                <%                             
                if ( isEventAdmin ) { %> 
                    destPathOptions.push({text: CQ.I18n.getMessage("labelSharedAccess"), value: "shared"});
                    selectedValue = "shared";                    
                <% } %>                
                
                <%                 
                if ( isEventHost ) { %>    
                    destPathOptions.push({text: CQ.I18n.getMessage("labelPrivateAccess"), value: "private"});
                    selectedValue = "private";
                <% } %>

                if ( destPathOptions.length == 2 )
                    selectedValue = path.indexOf("/event/private") > 0 || path.indexOf("/email/private") > 0 ? 'private' : 'shared';
                
                var copyDialog = {
                        "jcr:primaryType": "cq:Dialog",
                        "id": CQ.Util.createId("cq-copydialog"),
                        "title":CQ.I18n.getMessage("labelCopyTemplate"),
                        "formUrl":"",
                        "params": {
                            "cmd":"copyPage",
                            "_charset_":"utf-8",
                            "before": ""
                        },
                        "height": 220,
                        "items": {
                            "jcr:primaryType": "cq:Panel",
                            "items": [{
                                "xtype": "textfield",
                                "fieldLabel":CQ.I18n.getMessage("labelTemplateCopy"),
                                "allowBlank":false,
                                "name":"srcPath",
                                "readOnly": true,
                                "value": templateNode 
                            }, 
                            {
                                "xtype": "selection",
                                "type": "select",                                   
                                "fieldLabel": CQ.I18n.getMessage("To"),                                
                                "name":"destFolder",                                
                                "value": selectedValue,   
                                "defaultValue": selectedValue,
                                "options": destPathOptions
                            },
                            {
                                "xtype": "textfield",
                                "fieldLabel":CQ.I18n.getMessage("labelTemplateCopyName"),
                                "allowBlank":false,
                                "vtype": "name",
                                "name":"destName",
                                "maxLength": "60"
                            }/*,
                            
                            {
                            "xtype": "textfield",
                            "fieldLabel":CQ.I18n.getMessage("labelDisplayName"),
                            "allowBlank":false,
                            "name":"title",
                            "maxLength": "60",
                            "regex": new RegExp("^[a-zA-Z0-9_]+$"),
                            "regexText" :  CQ.I18n.getMessage("infoMsgDisplayNameFormat")
                            }                                
                            */
                            ]
                        },
                        "okText":CQ.I18n.getMessage("labelCopy")
                    };
                    
                    var dialog = CQ.WCM.getDialog(copyDialog);
                        
                    dialog.on("beforesubmit", function() {
        
                        var srcPath = encodeURIComponent(path);//this.getField( "srcPath" ).getValue();
                        var destParentPath = encodeURIComponent(to);//this.getField( "destParentPath" ).getValue();           
                        var destNamePath = encodeURIComponent(this.getField( "destName" ).getValue());
                        var destFolder = this.getField("destFolder").getValue();
                        //var displayName = this.getField( "title" ).getValue(); 
                       // var selectedPath = this.findById("pathList").getSelectedRecords()[0].data;
                        //var field21 = this.getField( "label" );

                        var templateType = CQTemplateType;
                        var micrositeRoot = CQMicrositeRoot;
                        
                        showWaitingBar(true);
                        CQ.HTTP.get("/content/connect/connect-action" + 
                            "?action=copy-template"+
                            "&name="+ destNamePath+ 
                            "&src-path="+ srcPath+ 
                            "&dest-folder="+ destFolder +                            
                            "&microsite-root-path=" + micrositeRoot+
                            "&display-name="+ destNamePath+
                            "&_charset_=utf-8"+   
                            "&type="+ templateType,

                            function(options, success, response) {
                                showWaitingBar(false);
                                if(success) {
                                    CQ.Notification.notify(CQ.I18n.getMessage("labelInfo"), CQ.I18n.getMessage("infoMsgTemplateCopied") );   
                                    var redirectTo = decodeURIComponent(response.getResponseHeader('redirect-to-template')) ;
                                    var currentLocation = window.location;
                                    if (redirectTo != undefined) {
                                        var paramsIndex = currentLocation.href.lastIndexOf("?");
                                        if(paramsIndex != -1) redirectTo = redirectTo + currentLocation.href.substring(paramsIndex);
                                        setTimeout("window.location = '" + redirectTo + "';", 2000);                                         
                                    }
                                } else {
                                    if ( response.status == 403 && response.statusText == "Forbidden" && response.responseXML == null)
                                    {
                                        window.location.reload();
                                    }
                                    
                                    txt = response.responseText
                                    if (window.DOMParser)
                                    {
                                         parser=new DOMParser();
                                         xmlDoc=parser.parseFromString(txt,"text/xml");
                                    }
                                    else // Internet Explorer
                                    {
                                        xmlDoc=new ActiveXObject("Microsoft.XMLDOM");
                                        xmlDoc.async="false";
                                        xmlDoc.loadXML(txt);
                                    }
                                    
                                    var errorMessage = xmlDoc.getElementsByTagName("status")[0].childNodes[0].nodeValue;
                                    if(errorMessage == "login-error" )
                                    {
                                        window.location.reload();//it will take care of the relogin 
                                    }   
                                    else
                                    {
                                        CQ.Ext.Msg.alert(CQ.I18n.getMessage("labelError"),  CQ.I18n.getMessage(errorMessage ));
                                    }
                                }
                        });
                        
                        var field21 = this.getField( "label" );
                         
                    });
              
                    dialog.show();
                    // CQ.WCM.Page.getCopyPageDialog().show();      
            }
    };
    /* End - Code for 'Copy a Template' button in sidekick */
    
    
    
    
    /* Start - Code for 'Reset Template' button in sidekick */
    var resetTemplate = {
               text: CQ.I18n.getMessage("titleResetTemplate"),
               handler: function(b, e , skPath) {
                     
                   var path;
                   if(skPath != undefined && skPath != null) {
                        path = skPath;
                   } else {
                        path = this.getPath();                  
                   }
                           
                   var templateType = CQTemplateType;
                         
                   var httpProxy = new CQ.Ext.data.HttpProxy({ "url":"/content/connect/connect-action?action=list-templates&template-type=" + templateType, "method":"GET" });
                        
                   httpProxy.on("exception", function() {
                       CQ.Notification.notify(CQ.I18n.getMessage("labelError"), CQ.I18n.getMessage("errorMsgTemplateListLoadingFail") );
                   });
            
                   
                            
                   //data provider for the template list 
                   var templatesStore = new CQ.Ext.data.Store({
                       "proxy": httpProxy,
                       "reader": new CQ.Ext.data.XmlReader(
                       {
                           record: "cq-template",
                           path: "path"//,
                           
                       },
                       [
                           {name: 'name', mapping: 'name'},     // "mapping" property not needed if it's the same as "name"
                           {name: 'path'},                 // This field will use "occupation" as the mapping.
                           {name: 'display-name'},
                           {name: 'template-id', mapping: '@template-id'},
                           {name: 'lang'}
                       ]
                               
                       )
                                           
                   });

                   templatesStore.on ( "load", function(me, records, options) {
                       var currTemplatePath = "";
                       <% if ( "email".equals(templateType) ) { %>
                           currTemplatePath = "<%= currentNode.getParent().getPath() %>";                           
                       <% } else { %>
                           currTemplatePath = "<%= currentNode.getParent().getParent().getPath() %>";
                       <% } %>                                                                                                        
                       this.remove ( this.getAt(this.find("template-id", CQTemplateId)) );
                       this.remove ( this.getAt(this.findBy(
                                            function(record, id) {
                                                return ( currTemplatePath == CQMicrositeRoot + "/" + URLDecode(record.get("path")) );
                                            }
                               )) );
                       for ( var i = 0 ; i < records.length ; i ++ ) 
                       {
                           records[i].set("name", URLDecode(records[i].get("name")));
                           records[i].set("path", URLDecode(records[i].get("path")));
                            var lang = records[i].get("lang");
                            var dispName = URLDecode(records[i].get("display-name"));                     
                            if(lang == "system") {                       
                                dispName = eventResBundle.getMessage(dispName) + " (" + eventResBundle.getMessage("system") + ")";                     
                            } else if ( null != lang && lang.trim() != "" ) {                       
                                var locDict = CQ.utils.I18n.getDictionary(lang);
                                if (locDict) {                         
                                   dispName = locDict[dispName];
                                } else {
                                   dispName = eventResBundle.getMessage(dispName);
                                }                       
                            } 
                           records[i].set("display-name", dispName);                           
                        }                        
                   });
                                                        
                   var dataView = new CQ.Ext.DataView({
                       "id": "pathList",
                       "multiSelect": false,
                       "singleSelect": true,
                       "emptyText": CQ.I18n.getMessage("noteNoTemplateAvailable"),
                       "store": templatesStore,
                       "height": "100%",
                       "overClass": "x-view-over",
                       "itemSelector" :"div.template-item",
                       
                       "tpl":new CQ.Ext.XTemplate(
                           '<tpl for=".">',
                           '<div class="template-item">',
                           
                           '<div class="template-title">{display-name}</div>',
                           '<div class="template-description">{path}</div>',
                           
                           '<div style="clear:both"></div>',
                           '</div>',
                           '</tpl>',
                           '<div style="height:5px;overflow:hidden"></div>')
                   });
                    
                   var resetPanel = {
                       "jcr:primaryType": "cq:Dialog",
                       "id": CQ.Util.createId("cq-resetdialog"),
                       "title":CQ.I18n.getMessage("labelResetTemplate"),
                       "formUrl":"",
                       "params": {
                           "cmd":"createPage",
                           "_charset_":"utf-8"
                       },
                       "height": 400,
                       "items": {
                           "jcr:primaryType": "cq:Panel",
                           "items": {
                               "jcr:primaryType": "cq:WidgetCollection",
                               
            
                               
                               
                              
                                "template": {
                                   "xtype": "panel",
                                   "title":CQ.I18n.getMessage("noteSelectTemplate"),
                                   "border": false,
                                   "cls": "cq-template-view",
                                   "autoScroll":true,
                                   "width": "100%",
                                   "autoHeight":false,
                                   "height": "100%",
                                   "items": [
                                       
                                       dataView
                                   ]
                                   
                                   ,"listeners": {
                                       "render" : {
                                           fn: function() {
                                               templatesStore.load();
                                               
                                           }
                                       }
                                   }
                               }
                           }
                       },
                       "okText":CQ.I18n.getMessage("labelReset")
                   };
            
                   if(resetDialog == undefined)                  
                       resetDialog = CQ.WCM.getDialog(resetPanel);

                   resetDialog.on("beforesubmit", function() {

                       if(this.findById("pathList").getSelectedRecords()[0] == undefined)
                       {
                           CQ.Notification.notify(CQ.I18n.getMessage("labelError"), CQ.I18n.getMessage("noteSelectTemplate") );
                           
                       } 
                       var selectedPath = this.findById("pathList").getSelectedRecords()[0].data;                                        
       
                       var srcPath = path;//this.getField( "srcPath" ).getValue();

                       var templateType = CQTemplateType;
                       var micrositeRoot = CQMicrositeRoot;
                       
                       showWaitingBar(true);
                       CQ.HTTP.get("/content/connect/connect-action" + 
                           "?action=reset-template"+
                           "&src-path="+ encodeURIComponent(selectedPath.path ) +
                           "&tgt-path=" + encodeURIComponent(path ) +
                           "&microsite-root-path=" + escape(micrositeRoot)+
                           "&_charset_=utf-8"+
                           "&type="+ escape(templateType),
                       
                           function(options, success, response) {
                               showWaitingBar(false);
                               if(success) {
                                   CQ.Notification.notify(CQ.I18n.getMessage("labelInfo"), CQ.I18n.getMessage("infoMsgTemplateReset") );
                                   var redirectTo = decodeURIComponent(response.getResponseHeader('redirect-to-template')) ;
                                   var currentLocation = window.location;                                   
                                   if (redirectTo != undefined && redirectTo != "undefined") {                                  
                                       var paramsIndex = currentLocation.href.lastIndexOf("?");
                                       if(paramsIndex != -1) redirectTo = redirectTo + currentLocation.href.substring(paramsIndex);
                                       setTimeout("window.location = '" + redirectTo + "';", 2000);                                       
                                   }
                                   else
                                   {
                                       setTimeout("window.location.reload();", 2000); 
                                   }
                                   
                               } else {                                
                                    if ( response.status == 403 && response.statusText == "Forbidden" && response.responseXML == null)
                                    {
                                        window.location.reload();
                                    }
                                    
                                   txt = response.responseText
                                   if (window.DOMParser)
                                   {
                                        parser=new DOMParser();
                                        xmlDoc=parser.parseFromString(txt,"text/xml");
                                   }
                                   else // Internet Explorer
                                   {
                                       xmlDoc=new ActiveXObject("Microsoft.XMLDOM");
                                       xmlDoc.async="false";
                                       xmlDoc.loadXML(txt);
                                   }
                                   
                                   var errorMessage = xmlDoc.getElementsByTagName("status")[0].childNodes[0].nodeValue;
                                   if(errorMessage == "login-error" )
                                   {
                                       window.location.reload();//it will take care of the relogin 
                                   }   
                                   else
                                   {
                                       CQ.Ext.Msg.alert(CQ.I18n.getMessage("labelError"),  CQ.I18n.getMessage(errorMessage ));
                                   }
                               }
                       });
                       
                        
                   });
                   
                   resetDialog.show();
                                                                  
                }
             };
    /* End - Code for 'Reset Template' button in sidekick */
    
    /* Start - Code for 'Delete Template' button in sidekick */                    
    var deleteTemplate = {
               text: CQ.I18n.getMessage("titleDeleteTemplate"),
               handler: function(b, e , skPath) {
                        
                   //var sidekick = CQ.wcm.Sidekick.findSidekick(this);
                    var path;
                    if(skPath != undefined && skPath != null) {
                        path = skPath;
                    } else {
                        path = this.getPath();                  
                    }
                
                    var micrositeRoot = CQMicrositeRoot;
                       
                    var label = path.substring(path.lastIndexOf("/") + 1);
                    
                    var templateType = CQTemplateType;                    

                    CQ.Ext.Msg.confirm(
                            CQ.I18n.getMessage("titleDeleteTemplate"),
                            CQ.I18n.getMessage("confirmationMsgDeleteTemplate"),
                                
                            function(btnId) {
                                if (btnId == "yes") {
                                    showWaitingBar(true);
                                    CQ.HTTP.get("/content/connect/connect-action" + 
                                        "?action=delete-template"+
                                        "&src-path="+ encodeURIComponent(path) +  
                                        "&type="+ escape(templateType)+
                                        "&_charset_=utf-8"+
                                        "&microsite-root-path=" + escape(micrositeRoot),
                                    
                                            function(options, success, response) {
                                                showWaitingBar(false);
                                                if(success) {
                                                    var parsedXml = $CQ.parseXML(response.responseText);
                                                    var redirectUrl = $CQ(parsedXml).find("redirect-path").text() + ".html" + "<%= null !=  request.getParameter("user") ? "?user=" + xssUtilService.encodeForJSString(request.getParameter("user")) : ""  %>";
                                                    CQ.Notification.notify(CQ.I18n.getMessage("labelInfo"), CQ.I18n.getMessage("infoMsgTemplateDeleted") );                                                    
                                                    setTimeout("window.location.href = '" + redirectUrl + "';", 2000);
                                                } else {
                                                    CQ.Notification.notify(CQ.I18n.getMessage("labelError"), CQ.I18n.getMessage("errorMsgTemplateDeletion") );
                                                }
                                            }
                                    );
                                }
                            },
                            this
                        );
               }
    }; 
    /* End - Code for 'Delete Template' button in sidekick */
    
    
    
    /* Start - Code for 'Rename Template' button in sidekick */
    var renameTemplate = {
             text: CQ.I18n.getMessage("titleRenameTemplate"),
             handler: function(b, e , skPath) {

                var path;
                if(skPath != undefined && skPath != null) {
                    path = skPath;
                } else {
                    path = this.getPath();                  
                }
                
                var templateNode = path;                                
                if(CQTemplateType == "event")
                {
                    templateNode = path.substring(0, path.lastIndexOf("/"));                    
                }
                                               
                var renameDialog = {
                        "jcr:primaryType": "cq:Dialog",
                        "id": CQ.Util.createId("cq-renamedialog"),
                        "title":CQ.I18n.getMessage("titleRenameTemplate"),
                        "formUrl":"",
                        "params": {
                            "cmd":"renamePage",
                            "_charset_":"utf-8",
                            "before": ""
                        },
                        "height": 220,
                        "items": {
                            "jcr:primaryType": "cq:Panel",
                            "items": [{
                                "xtype": "textfield",
                                "fieldLabel":CQ.I18n.getMessage("titleRenameTemplate"),
                                "allowBlank":false,
                                "name":"srcPath",
                                "readOnly": true,
                                "value": templateNode 
                            },                            
                            {
                                "xtype": "textfield",
                                "fieldLabel":CQ.I18n.getMessage("To"),
                                "allowBlank":false,
                                "vtype": "name",
                                "name":"renameTo",
                                "maxLength": "60"
                            }
                            ]
                        }, 
                        "okText":CQ.I18n.getMessage("labelRename")
                    };
                    
                    var dialog = CQ.WCM.getDialog(renameDialog);
                        
                    dialog.on("beforesubmit", function() {
                        var renameTo = encodeURIComponent(this.getField( "renameTo" ).getValue());
                        var templateId = templateNode.substring(templateNode.lastIndexOf("/")+1);
                        showWaitingBar(true);
                        CQ.HTTP.get("/content/connect/connect-action?action=update-template" +
                            "&name="             + renameTo      +
                            "&template-id="      + templateId  +
                            "&src-path="         + templateNode  + 
                            "&_charset_=utf-8",
                        
                            function(options, success, response) {
                                showWaitingBar(false);
                                if(success) {
                                    CQ.Notification.notify(CQ.I18n.getMessage("labelInfo"), CQ.I18n.getMessage("infoMsgTemplateRenamed") );   
                                    setTimeout("window.location.reload();", 2000);                                           
                                } else {
                                    if ( response.status == 403 && response.statusText == "Forbidden" && response.responseXML == null)
                                    {
                                        window.location.reload();
                                    }
                                    
                                    txt = response.responseText
                                    if (window.DOMParser)
                                    {
                                         parser=new DOMParser();
                                         xmlDoc=parser.parseFromString(txt,"text/xml");
                                    }
                                    else // Internet Explorer
                                    {
                                        xmlDoc=new ActiveXObject("Microsoft.XMLDOM");
                                        xmlDoc.async="false";
                                        xmlDoc.loadXML(txt);
                                    }
                                    
                                    var errorMessage = xmlDoc.getElementsByTagName("status")[0].childNodes[0].nodeValue;
                                    CQ.Ext.Msg.alert(CQ.I18n.getMessage("labelError"),  CQ.I18n.getMessage(errorMessage ));                                    
                                }
                        });
                    });
              
                    dialog.show();
                    // CQ.WCM.Page.getCopyPageDialog().show();      
            }
    };
    /* End - Code for 'Rename Template' button in sidekick */
    
    
                 
    <% if( templateType != null && ((templateType.equals("email") || templateType.equals("event"))) ){ %>
                    
        var SidekickActions = [
            createNewTemplate,
            copyTemplate,
            resetTemplate,
             <% if ( null != templateId ) { %>
            deleteTemplate,
            renameTemplate,
            <% } %>
            pagebackgroundComponentBtn, 
            customPublishPage  
        ];
    
    <% } else { %>

           var SidekickActions =  [pagebackgroundComponentBtn, customPublishPage];         
    
    <% }

    %>
            
    <% if ( ! "connect/components/templatepage".equals(currentNode.getProperty("sling:resourceType").getString()) ) { %>
            var customSidekick;
            CQ.Ext.onReady(function() {
                customSidekick = function(config) {
                    customSidekick.superclass.constructor.call(this, config);
                };
                

                CQ.Ext.extend(customSidekick, CQ.wcm.Sidekick, {
                    addButtons: function() {
                        var bbar = this.getBottomToolbar();
                        bbar.removeAll(true);
                        bbar.add([
                            this.editButton,
                            this.previewButton,
                            "-",                            
                            this.reloadButton
                        ]);
                     },

                     loadPanels: function(content, config) {
                         var sidekick = this;
                         if (!config) config = {};
                         config = CQ.Ext.applyIf(config, this.initialConfig);
                         if (!this.panelsLoaded) {
                             this.panels = {};                           
                             for (var i = 0; i < customSidekick.CONTEXTS.length; i++) {
                                 if (customSidekick.CONTEXTS[i] == CQ.wcm.Sidekick.COMPONENTS) {
                                     this.panels[customSidekick.CONTEXTS[i]] = new CQ.Ext.Panel({
                                         "border": false,
                                         "autoScroll":true,
                                         "layout":"accordion",
                                         "stateful": false,
                                         "id": "cq-sk-tab-" + customSidekick.CONTEXTS[i]
                                     });
                                 }
                                 else if (customSidekick.CONTEXTS[i] == CQ.wcm.Sidekick.VERSIONING ||
                                          customSidekick.CONTEXTS[i] == CQ.wcm.Sidekick.WORKFLOW){
                                     this.panels[customSidekick.CONTEXTS[i]] = new CQ.Ext.Panel({
                                         "border": false,
                                         "stateful": false,
                                         "layout": "fit",
                                         "id": "cq-sk-tab-" + customSidekick.CONTEXTS[i]
                                     });
                                 }
                                 else {
                                     this.panels[customSidekick.CONTEXTS[i]] = new CQ.Ext.Panel({
                                         "autoScroll":true,
                                         "border": false,
                                         "stateful": false,
                                         "id": "cq-sk-tab-" + customSidekick.CONTEXTS[i]
                                     });
                                 }
                             }

                             this.items.get(0).getEl().fadeOut({
                                 callback: function(element) {
                                     sidekick.removeLoadingPanel();
                                     sidekick.add({
                                         "xtype":"tabpanel",
                                         "border": false,
                                         "enableTabScroll":true,
                                         "deferredRender":false,
                                         "activeTab":0,
                                         "stateful": true,
                                         "id": "cq-sk-tabpanel",
                                         "listeners": {
                                             "tabchange": function(tabPanel, tab, currentTab) {
                                                 tab.doLayout();
                                             }
                                         },
                                         "items": [
                                             {
                                                 "tabTip": CQ.I18n.getMessage("Components"),
                                                 "iconCls": "cq-sidekick-tab cq-sidekick-tab-icon-components",
                                                 "items": sidekick.panels[CQ.wcm.Sidekick.COMPONENTS],
                                                 "layout":"fit"
                                             },{
                                                 "tabTip": CQ.I18n.getMessage("Page"),
                                                 "iconCls": "cq-sidekick-tab cq-sidekick-tab-icon-page",
                                                 "items": sidekick.panels[CQ.wcm.Sidekick.PAGE],
                                                 "layout":"fit"
                                             }
                                         ]
                                     });
                                     sidekick.doLayout();
                                     try {
                                         sidekick.items.get(0).getEl().fadeIn({
                                             duration: .5
                                         });
                                     } catch(e) {
                                     }
                                 },
                                 duration: .5
                             });
                             this.panelsLoaded = true;
                         } else {
                             // check for and remove existing content in panels
                             for (var context in this.panels) {
                                 if (this.panels[context].items) {
                                     while (this.panels[context].items.getCount() > 0) {
                                         this.panels[context].remove(this.panels[context].items.get(0), true);
                                     }
                                 }
                             }
                         }
                         this.loadActions(config);
                         var cl = CQ.WCM.getComponentList(this.path);
                         if( CQ.WCM.getContentWindow().CQ.WCM.areEditablesReady()) {
                             CQ.wcm.ComponentList.loadPanel(cl, sidekick.panels[CQ.wcm.Sidekick.COMPONENTS]);
                         } else {
                             CQ.WCM.getContentWindow().CQ.WCM.on("editablesready", function() {
                                 var cl = CQ.WCM.getComponentList();

                                 // remove old panels first
                                 var panel = this.panels[CQ.wcm.Sidekick.COMPONENTS];
                                 if (panel.items) {
                                     panel.items.each(function(item){
                                         this.remove(item, true);
                                     }, panel);
                                 }
                                 CQ.wcm.ComponentList.loadPanel(cl, panel);
                             }, sidekick);
                         }
                         cl.addListener("updatecomponents", function(cl) {
                             if( CQ.WCM.getContentWindow().CQ.WCM.areEditablesReady()) {
                                 // remove old panels first
                                 var panel = this.panels[CQ.wcm.Sidekick.COMPONENTS];
                                 if (panel.items) {
                                     panel.items.each(function(item){
                                         this.remove(item, true);
                                     }, panel);
                                 }
                                 CQ.wcm.ComponentList.loadPanel(cl, panel);
                             }
                         }, sidekick);
                         (function() {
                             // use timeout to load component list asynchronously
                             sidekick.loadVersioningTab();
                             sidekick.loadWorkflowTab();
                         }).defer(16);
                         this.doLayout();
                     },

                     loadVersioningTab: function() { },

                     loadWorkflowTab: function() { }
                });

                customSidekick.CONTEXTS = [  
                            CQ.wcm.Sidekick.PAGE,
                            CQ.wcm.Sidekick.COMPONENTS 
                        ];

                var sidekick = new customSidekick({actions: SidekickActions});                
                sidekick.loadContent("<%= currentPage.getPath() %>");                               
                sidekick.show();
            });
    <% } %>
    
    </script>
<% } %>    