if (!String.prototype.trim) 
{
    String.prototype.trim=function(){return this.replace(/^\s\s*/, '').replace(/\s\s*$/, '');};
    String.prototype.ltrim=function(){return this.replace(/^\s+/,'');}
    String.prototype.rtrim=function(){return this.replace(/\s+$/,'');}
    String.prototype.fulltrim=function(){return this.replace(/(?:(?:^|\n)\s+|\s+(?:$|\n))/g,'').replace(/\s+/g,' ');}
}
Array.prototype.exists = function(search) {
      for ( var i = 0 ; i < this.length ; i ++ ) {
        if (this[i] == search) { 
            return true;
        }
      }
      return false;
} 
function isEmpty(x) 
{
    if ( undefined == x || null == x || "" == x.trim() )
        return true;
    return false;
}

//validates email
function emailValidation(email)
{
    var elementId = email.id + "_errorMessage"; 
    var emailPattern = /^[^\t\r\n\v\f\\\(\)<>@;:\[\]"]+@[^\t\r\n\v\f\\\(\)<>@;:\[\]"]+\.[^\t\r\n\v\f\\\(\)<>@;:\[\]"]+$/;  
    var lowerCaseValue = email.value.trim().toLowerCase();
    
    if (!emailPattern.test(lowerCaseValue)) 
    {
        msg = eventResBundle.getMessage('emailNotValid');
        document.getElementById(elementId).innerHTML='  '+msg+' ';
        iserror = true;
    } 
    else 
    {
        //no error in syntax, check length (for local-part - before the @ symbol)
        var mySplitResult = lowerCaseValue.split("@");
        if (mySplitResult[0].length > 64)
        {
            msg = eventResBundle.getMessage('emailNotValid');
            document.getElementById(elementId).innerHTML='  '+msg+' ';
            iserror = true;
        } 
        else
        {
            document.getElementById(elementId).innerHTML='';
            iserror = false;
        }
    }
    
    setErrorStyle(email, iserror);
    return !iserror;
}

function colorFieldTextChange(value, el)
{
    if (value.length==6) 
    {
        var mid=0.2126*parseInt(value.substring(0,2),16)
        +0.7152*parseInt(value.substring(2,4),16)
        +0.0722*parseInt(value.substring(4,6),16); 
        if (mid>parseInt("7f",16))
        { 
            el.setStyle({"color":"#000000"});
        }
        else
        {
            el.setStyle({"color":"#ffffff"});
        }
    }
    if (value.length==3)
    {
        var mid=0.2126*parseInt(value.substring(0,1),16)
        +0.7152*parseInt(value.substring(1,2),16)
        +0.0722*parseInt(value.substring(2,3),16); 
        if (mid>parseInt("7",16))
        { 
            el.setStyle({"color":"#000000"});
        }
        else
        {
            el.setStyle({"color":"#ffffff"});
        }
    }
}
function setFormFieldFocus(form, field) {
    if(form == undefined || form == null) {
        return true;
    }
    if(field == undefined || field == null) {       
        var firstField;
        for(i = 0; i < form.length; i++) {
            firstField = form.elements[i];            
            if(firstField != undefined && firstField != null && firstField.type != "hidden" && firstField.disabled != true && firstField.readOnly != true)
            {
                firstField.focus();
                break;
            }
        }
    } else {
        field.focus();
    }
}    
function URLDecode(encodedStr)
{       
    return decodeURIComponent(encodedStr.replace(/\+/g, "%20"));
}
function setCookie(c_name, value, exdays)
{
    var exdate=new Date();
    exdate.setDate(exdate.getDate() + exdays);
    var c_value=escape(value) + ((exdays==null) ? "" : "; expires="+exdate.toUTCString());
    document.cookie=c_name + "=" + c_value;
}
function getCookie(c_name)
{
    var i,x,y,ARRcookies=document.cookie.split(";");
    for (i=0 ; i<ARRcookies.length ; i++)
    {
      x=ARRcookies[i].substr(0,ARRcookies[i].indexOf("="));
      y=ARRcookies[i].substr(ARRcookies[i].indexOf("=")+1);
      x=x.replace(/^\s+|\s+$/g,"");
      if (x==c_name)
      {
        return y;
      }
    }   
    return null;    
}

function getAnchorParams()
{       
    var anchorLinkIndex = window.location.href.lastIndexOf("#");
    var paramsObj = {};
    var params = [];
    var url = window.location.href;
    if ( anchorLinkIndex != -1 )
    {
        params = window.location.href.substring(anchorLinkIndex + 1).split(";");
        url    = window.location.href.substring(0, anchorLinkIndex);
    }
    for ( var i = 0 ; i < params.length ; i ++ )
    {
        var keyVal = params[i].split("=", 2);
        paramsObj[keyVal[0]] = keyVal[1];
    }
    return {"url": url, "params": paramsObj};
}
function setAnchorParams(key, val)
{
    var anchorParams = getAnchorParams();
    var params = "";
    anchorParams.params[key] = val;
    for ( key in anchorParams.params )
    {
        params += key + "=" + anchorParams.params[key];
    }
    window.location.href = anchorParams.url + "#" + params;
}
function showWaitingBar(show)
{
    if ( show === false )
        CQ.Ext.getBody().unmask();
    else
        CQ.Ext.getBody().mask("<img src='/etc/designs/connect/images/spinner.gif' />", "");
}
function isDST()
{
    var today = new Date();
    var yr = today.getFullYear();
    var jan = new Date(yr,0);   // January 1
    var jul = new Date(yr,6);   // July 1
    // northern hemisphere test
    if (jan.getTimezoneOffset() > jul.getTimezoneOffset() && today.getTimezoneOffset() != jan.getTimezoneOffset()){
        return true;
        }
    // southern hemisphere test 
    if (jan.getTimezoneOffset() < jul.getTimezoneOffset() && today.getTimezoneOffset() != jul.getTimezoneOffset()){
        return true;
        }
    // if we reach this point, DST is not in effect on the client computer. 
    return false;
}


function hideDialogTab(dialog, tabItemId) 
{
    var tabObj = dialog.getComponent(tabItemId);
    if ( undefined != tabObj ) { 
        tabObj.destroy(); 
    }   
    return true;
}


function hideDialogComponents(dialog) 
{       
    var componentsToHide = dialog.findBy(function(component, thisContainer) {       
        if ( undefined === component.initialConfig.customHide || undefined === component.initialConfig.customHideFor ) {
            return false;       
        }
        return true;
    });
    
    for ( var i = 0 ; i < componentsToHide.length ; i ++ ) 
    {       
        if ( isIndependentCQInstance === componentsToHide[i].initialConfig.customHideFor ) {
            componentsToHide[i].setVisible(! componentsToHide[i].initialConfig.customHide);
        }
    }
    return true;
}


function hideSelectionOption(selection, optionsToHide)
{
    if ( undefined !== selection ) {
        var initialOptions = selection.initialConfig.options;
        var newOptions = [];
        for ( var i = 0 ; i < initialOptions.length ; i ++ ) {
            if ( -1 == optionsToHide.indexOf(initialOptions[i].value) ) {
                newOptions.push(initialOptions[i]);
            }
        }
        selection.setOptions(newOptions);
    }   
    return true;
}

function disableComponent(parentComponent, componentItemId, disableFlag)
{
    var field = parentComponent.getComponent(componentItemId);
    field.setDisabled(disableFlag);
}


function selectionToggle(selectionObj, parentComponent, toggleFor, siblingItemId, disableFlag)
{
    var selectionVal = selectionObj.getValue();
    if ( selectionVal == toggleFor ) { 
        disableComponent(parentComponent, siblingItemId, disableFlag);
    } else {        
        disableComponent(parentComponent, siblingItemId, ! disableFlag);
    }
}


function selectionChanged(selectionObj, parentComponent, mappings) 
{
    var selectionVal = selectionObj.getValue();
    for ( var itemId in mappings ) {
        var val = mappings[itemId];
        var comp = parentComponent.getComponent(itemId);
        if ( selectionVal == val ) {
            comp.show();
        } else {
            comp.hide();
        }       
        if ( undefined !== comp.initialConfig.customHide && isIndependentCQInstance == comp.initialConfig.customHideFor ) {         
            comp.setVisible(! comp.initialConfig.customHide);
        }
    }
}

function getCampaignCookie(scoId)
{
    if ( scoId == null )
        return null;
    var campCookie =  getCookie(scoId + "_campaign-id");
    if(campCookie != null)
    	return campCookie;
    return  getCookie("connectevent_campaign-id");
} 


function disableFontProperties(parentObj, val)
{
    if ( ! isIndependentCQInstance ) {
        return;
    }
    var childWidgets = parentObj.items.items;
    var disableFlag = (true === isIndependentCQInstance && ("inherit" === val || "" === val));
    for ( var i = 0 ; i < childWidgets.length ; i ++ ) 
    {
        var item = childWidgets[i];
        var itemId = item.getItemId();
        if ( "disableFontProperties" === itemId || "label" === itemId ) {
            continue;
        }
        item.setDisabled(disableFlag);
    }
}

function hideInheritOptionForHostedCQ(selectObj, parentObj)
{
    if ( ! isIndependentCQInstance ) { 
        selectObj.hide();       
    }
}

function ellipsisString(str, len) {
    if ( str.length <= len ) {
        return str;
    }
    return str.substring(0, len-3) + "...";
}

function parseXML(xml) {
    if ( typeof xml === "string" ) {   
        return $CQ.parseXML(xml);
    }   
	return xml;
}