function isLoggedIn() 
{
    var isConnectLoggedIn = false;
    checkConnectLogin(accountId, [], function() {
        isConnectLoggedIn = true;
    }, function() {
        isConnectLoggedIn = false;
    }, function() {
        isConnectLoggedIn = false;
    }, false);
    return isConnectLoggedIn;
}


function connectLoginAndRefresh()
{
    var loginFlag = isLoggedIn();
    if ( false === loginFlag )
    {
        loginToConnect(accountId, [], function(){
            window.location.reload(true);
        }, false);
    }
    
    return loginFlag;
}

function checkConnectLogin(accountId, checkGrpMembership, loggedInCallback, notLoggedInCallback, unauthorizedLoginCallback, isAsync)
{
    if ( null == accountId ) {
        return;
    }
    var url = "/content/connect/connect-action?action=call-api";
    var groupIds = getAllConnectGroupIds();
    var paramNames = ["get-primary-group-membership"];
    var paramVals  = ["true"];  
    for ( var i = 0 ; i < groupIds.length ; i ++ ) {
        paramVals.push(groupIds[i]);
        paramNames.push("group-id");
    }
    var params = { "api-name": "common-info", "param-name": paramNames, "param-val":  paramVals };
    showWaitingBar(true);
    $CQ.ajax ({
        type:   "post",
        url:    url,
        data:   params,
        async:  isAsync,
        error: function(request, type, errorThrown) {
            showWaitingBar(false);
            CQ.Ext.Msg.alert(CQ.I18n.getMessage("labelError"),  eventResBundle.getMessage("errAPICall", [request.status])); 
        },
        success: function (responseXml) {
            showWaitingBar(false);
            var code = $CQ("status", responseXml).attr('code');
            if ( "ok" != code.toLowerCase() ) {
                CQ.Ext.Msg.alert(CQ.I18n.getMessage("labelError"),  eventResBundle.getMessage("unknownErrorCode", [code]));
                return;
            }
            var commonInfo = {};
            commonInfo["accountId"] = $CQ(responseXml).find("common").find("account").attr("account-id");
            commonInfo["loggedInName"]  = $CQ(responseXml).find("common").find("user").find("name").text();
            commonInfo["loggedInLogin"] = $CQ(responseXml).find("common").find("user").find("login").text();
            commonInfo["connectServerUrl"] = $CQ(responseXml).find("common").find("host").text();
            if ( "" === commonInfo["loggedInLogin"] || commonInfo["accountId"] != accountId || commonInfo["connectServerUrl"] != connectServerUrl ) {    
                if ( typeof notLoggedInCallback == "function" ) {
                	$CQ("#loginDiv").show();
                	$CQ("#loggedInInfo").hide();
                    notLoggedInCallback(commonInfo);
                }
                return;
            }
            
            var primaryGroupMemberShip = $CQ(responseXml).find("primary-group-membership");
            commonInfo["grpMemberships"] = [];
            for ( var i = 0 ; i < paramVals.length ; i ++ ) {               
                var isMember = $CQ(primaryGroupMemberShip).find(paramVals[i]).text();               
                if ( "true" === isMember ) {
                    commonInfo["grpMemberships"].push(paramVals[i]);
                }
            }
                             
            var isMember = true;
            for ( var i = 0 ; i < checkGrpMembership.length ; i ++ ) {
                isMember = isMember && commonInfo["grpMemberships"].exists(checkGrpMembership[i]);
            }
            
            if ( ! isMember ) {
                if ( typeof unauthorizedLoginCallback == "function" ) {
                    unauthorizedLoginCallback(commonInfo);
                }               
            } else if ( typeof loggedInCallback == "function" ) {
            	$CQ("#loggedInInfo #username").html(commonInfo["loggedInName"]);
            	$CQ("#loggedInInfo #useremail").html(commonInfo["loggedInLogin"]);
            	$CQ("#loginDiv").hide();
            	$CQ("#loggedInInfo").show();
                loggedInCallback(commonInfo);
            }
        }
    }); 
}

function loginToConnect(accountId, checkGrpMembership, callback, isAsync)
{
    var notLoggedInCallback = function(commonInfo) {
        callConnectLoginApi(function(){
            loginToConnect(accountId, checkGrpMembership, callback);
        }, accountId, isAsync);
    };
    
    var unauthorizedLoginCallback = function(commonInfo) {
        CQ.Ext.Msg.alert(CQ.I18n.getMessage("labelError"),  eventResBundle.getMessage("errUnauthorized"));
    };
    
    checkConnectLogin(accountId, checkGrpMembership, callback, notLoggedInCallback, unauthorizedLoginCallback, isAsync);
}

function logoutConnect(isAsync) 
{
	var url = "/content/connect/connect-action?action=call-api&api-name=logout";
	showWaitingBar(true);
    $CQ.ajax ({
        type:   "get",
        url:    url,
        data:   {},
        async:  isAsync,
        error: function(errorXml) {
            showWaitingBar(false);
            msgField.html(eventResBundle.getMessage("errAPICall", [errorXml]));            
        },
        success: function (responseXml) {
            showWaitingBar(false);
            var code = $CQ("status", responseXml).attr('code');
            if ( "ok" != code.toLowerCase() ) {
            	msgField.html(eventResBundle.getMessage("unknownErrorCode", [code]));
                return;
            }
            var expiredDate = new Date();
            expiredDate.setDate(expiredDate.getDate() - 1);
            CQ.Ext.util.Cookies.set('cqconnectsession', null, expiredDate);
            window.location.reload(true);
        }
    });
}

function showMsgErrDiv(msg) 
{
	if ( isEmpty(msg) ) {
		return;
	}
	var msgField = $CQ(".loginSliderDiv #loginPanelErrDiv");
	msgField.html(msg);
	$CQ(".slidercontent").css("height", "180px");
}


function callConnectLoginApi(callback, accountId, isAsync)
{
	$CQ("#loginDiv #loginBtn").click(function() {
		var login = $CQ("#loginDiv #connectlogin").val();                               
        if ( isEmpty(login) || login == $CQ("#loginDiv #connectlogin").attr("placeholder") ) {
        	showMsgErrDiv(eventResBundle.getMessage('msgEmptyLogin'));            
            return;
        }
        
        var password = $CQ("#loginDiv #connectpasswd").val();  
        if ( isEmpty(password) || password == $CQ("#loginDiv #connectpasswd").attr("placeholder") ) {
        	showMsgErrDiv(eventResBundle.getMessage('msgEmptyPassword'));
            return;
        }
        
        var url = "/content/connect/connect-action?action=login-connect";
        var params = {"login": login, "password": password, "account-id": accountId};                                
        
        showWaitingBar(true);
        showMsgErrDiv(eventResBundle.getMessage('labelPleaseWait'));
        $CQ.ajax ({
            type:   "post",
            url:    url,
            data:   params,
            async:  isAsync,
            error: function(errorXml) {
                showWaitingBar(false);
                var code = $CQ("status", errorXml.responseText).text();
                if ( "login-error" == code.toLowerCase() || "no-data" == code.toLowerCase() ) {                                         
                	showMsgErrDiv(eventResBundle.getMessage('errInvalidLoginData'));
                } else {                                            
                	showMsgErrDiv(eventResBundle.getMessage("unknownErrorCode", [code]));
                }
            },
            success: function (responseXml) {
                showWaitingBar(false);
                var code = $CQ("status", responseXml).attr('code');
                if ( "ok" != code.toLowerCase() ) {
                	showMsgErrDiv(eventResBundle.getMessage("msgErrorLoggingIn"));
                    return;
                }
                var breezeSession = $CQ("BREEZESESSION", responseXml).text();
                CQ.Ext.util.Cookies.set('cqconnectsession', breezeSession);
                loginPanelHide();
                if ( typeof callback == "function" ) {
                    callback();
                }
            }
        });
	});
	loginPanelShow();
}


function loginPanelToggle() {
	var sliderContentDiv = $CQ('#loginslidercontent');
	var width = sliderContentDiv.css("width");
	if (sliderContentDiv.css("display") == "none") {
		sliderContentDiv.css("display", "block");
	}
	sliderContentDiv.animate({width: (width == "0px" ? "250px" : "0px") }, function() {
		if ( sliderContentDiv.css("width") == "0px" || sliderContentDiv.css("width") == "0" ) {
			sliderContentDiv.css("display", "none");
		}
	});
}



function loginPanelShow() {
	if ( ! $CQ(".slider").hasClass("active") ) {
		loginPanelToggle();
	}
}


function loginPanelHide() {
	if ( $CQ(".slider").hasClass("active") ) {
		loginPanelToggle();
	}
}

function getAllConnectGroupIds()
{
    return ["event-admins"];
}

function fetchEventPage(dialog)
{
	var eventId = dialog.getField("./sco").getValue();
	dialog.getField("force").setValue("false");
	if ( ! isEmpty(eventId) ) 
	{		
		$CQ.ajax ({
            type:   "post",
            url:    "/content/connect/connect-action?action=event-page-redirect",
            data:   "event-id=" + eventId,
            error: function(errorXml) {
            },
            success: function (responseXml) {
                var headerInfo, isInfoShown = false;
                var staticMsgs = dialog.findByType("label");
                for ( var i = 0 ; i < staticMsgs.length ; i ++ ) 
                {
                	if ( isEmpty(staticMsgs[i].itemId) ) {
                		headerInfo = staticMsgs[i];
                	}                	
                	var pageLink = $CQ(staticMsgs[i].itemId, responseXml).text();                	
                	if ( ! isEmpty(pageLink) ) {
                		staticMsgs[i].update(CQ.I18n.getMessage("labelAssociated" + staticMsgs[i].itemId + "Page", [pageLink+".html", pageLink]));                		
                		staticMsgs[i].setVisible(true);
                		isInfoShown = true;
                	} else {
                		staticMsgs[i].setVisible(false);
                	}
                }
                
                if ( true === isInfoShown ) {
                	headerInfo.setVisible(true);
                }
            }
        });
	}
}


function eventAssociatorDialogFailure(form, action, thisObj)
{	
	var thisDialog = thisObj.dialogs.EDIT;
	thisDialog.setVisible(true);
	var msg = "<div class='associatedPageErrMsgHeader'>" + CQ.I18n.getMessage("msgPageExistingAssociations") + "</div>";
	var parsedXml = $CQ.parseXML(action.response.responseText);
	$CQ(parsedXml).find("conflicts").children().each(function() {
		var child = $CQ(this);
		msg += "<div class='associatedPageErrMsg associatedPageErrMsgExtend'>" + CQ.I18n.getMessage("labelAssociated" + child.prop("tagName") + "Page", [child.text()+".html", child.text()]) + "</div>";
	});
	msg += "<div class='associatedPageErrMsgHeader'>" + CQ.I18n.getMessage("confirmMsg") + "</div>";
	CQ.Ext.Msg.show({
		   title: CQ.I18n.getMessage("warningMsg"),
		   msg: msg,
		   buttons: CQ.Ext.Msg.YESNO,
		   fn: function(btn) {
			   if ( "yes" === btn ) {
				   thisDialog.getField("force").setValue("true");				   
				   thisDialog.ok();
			   } else {
				   thisDialog.getField("force").setValue("false");
			   }
		   },
		   minWidth: 600
	});
}




function populateContainerEventsField() 
{
    var options = [];
    // options.push({"text": "EVENT NAME HERE", "value": "EVENT SCO ID HERE"});
    var params = {"editable-by-me": "true", "get-unpublished": "true", "include-remote-cq-events": "true"}; 
    showWaitingBar(true);
    $CQ.ajax ({
        type:   "post",
        url:    "/content/connect/connect-action?action=event-list",
        data:   params,
        async:  false,
        error: function(errorXml) {
    		showWaitingBar(false);
    		CQ.Ext.Msg.alert(CQ.I18n.getMessage("labelError"),  eventResBundle.getMessage("errFetchingEventList"));    		
        },
        success: function (responseXml) {
        	showWaitingBar(false);
        	$CQ(responseXml).find("event-list").find("event").each(function(key, e) {
        		var eventName = $CQ(e).find("name").text();
        		var scoId = $CQ(e).attr("sco-id");
        		options.push({"text": eventName, "value": scoId});
        	});             
        }
    });
    return options;
}


function setDefaultEventPageSubscription(multiField)
{
	if ( 0 === multiField.getValue().length ) {
		var currLoc = window.location.pathname;
		multiField.setValue([currLoc.substring(0, currLoc.lastIndexOf("/"))]);
	} 
}